import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountAgreementConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#agreement_type LogicAppIntegrationAccountAgreement#agreement_type}.
     *
     * @stability stable
     */
    readonly agreementType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#content LogicAppIntegrationAccountAgreement#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#guest_partner_name LogicAppIntegrationAccountAgreement#guest_partner_name}.
     *
     * @stability stable
     */
    readonly guestPartnerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#host_partner_name LogicAppIntegrationAccountAgreement#host_partner_name}.
     *
     * @stability stable
     */
    readonly hostPartnerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#integration_account_name LogicAppIntegrationAccountAgreement#integration_account_name}.
     *
     * @stability stable
     */
    readonly integrationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#metadata LogicAppIntegrationAccountAgreement#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#name LogicAppIntegrationAccountAgreement#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#resource_group_name LogicAppIntegrationAccountAgreement#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * guest_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#guest_identity LogicAppIntegrationAccountAgreement#guest_identity}
     *
     * @stability stable
     */
    readonly guestIdentity: LogicAppIntegrationAccountAgreementGuestIdentity;
    /**
     * host_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#host_identity LogicAppIntegrationAccountAgreement#host_identity}
     *
     * @stability stable
     */
    readonly hostIdentity: LogicAppIntegrationAccountAgreementHostIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#timeouts LogicAppIntegrationAccountAgreement#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppIntegrationAccountAgreementTimeouts;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountAgreementGuestIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#qualifier LogicAppIntegrationAccountAgreement#qualifier}.
     *
     * @stability stable
     */
    readonly qualifier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#value LogicAppIntegrationAccountAgreement#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function logicAppIntegrationAccountAgreementGuestIdentityToTerraform(struct?: LogicAppIntegrationAccountAgreementGuestIdentityOutputReference | LogicAppIntegrationAccountAgreementGuestIdentity): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountAgreementGuestIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountAgreementGuestIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountAgreementGuestIdentity | undefined);
    private _qualifier?;
    /**
     * @stability stable
     */
    get qualifier(): string;
    /**
     * @stability stable
     */
    set qualifier(value: string);
    /**
     * @stability stable
     */
    get qualifierInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountAgreementHostIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#qualifier LogicAppIntegrationAccountAgreement#qualifier}.
     *
     * @stability stable
     */
    readonly qualifier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#value LogicAppIntegrationAccountAgreement#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function logicAppIntegrationAccountAgreementHostIdentityToTerraform(struct?: LogicAppIntegrationAccountAgreementHostIdentityOutputReference | LogicAppIntegrationAccountAgreementHostIdentity): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountAgreementHostIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountAgreementHostIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountAgreementHostIdentity | undefined);
    private _qualifier?;
    /**
     * @stability stable
     */
    get qualifier(): string;
    /**
     * @stability stable
     */
    set qualifier(value: string);
    /**
     * @stability stable
     */
    get qualifierInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountAgreementTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#create LogicAppIntegrationAccountAgreement#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#delete LogicAppIntegrationAccountAgreement#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#read LogicAppIntegrationAccountAgreement#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement#update LogicAppIntegrationAccountAgreement#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppIntegrationAccountAgreementTimeoutsToTerraform(struct?: LogicAppIntegrationAccountAgreementTimeoutsOutputReference | LogicAppIntegrationAccountAgreementTimeouts): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountAgreementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountAgreementTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountAgreementTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement azurerm_logic_app_integration_account_agreement}.
 *
 * @stability stable
 */
export declare class LogicAppIntegrationAccountAgreement extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_agreement azurerm_logic_app_integration_account_agreement} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppIntegrationAccountAgreementConfig);
    private _agreementType?;
    /**
     * @stability stable
     */
    get agreementType(): string;
    /**
     * @stability stable
     */
    set agreementType(value: string);
    /**
     * @stability stable
     */
    get agreementTypeInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _guestPartnerName?;
    /**
     * @stability stable
     */
    get guestPartnerName(): string;
    /**
     * @stability stable
     */
    set guestPartnerName(value: string);
    /**
     * @stability stable
     */
    get guestPartnerNameInput(): string | undefined;
    private _hostPartnerName?;
    /**
     * @stability stable
     */
    get hostPartnerName(): string;
    /**
     * @stability stable
     */
    set hostPartnerName(value: string);
    /**
     * @stability stable
     */
    get hostPartnerNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationAccountName?;
    /**
     * @stability stable
     */
    get integrationAccountName(): string;
    /**
     * @stability stable
     */
    set integrationAccountName(value: string);
    /**
     * @stability stable
     */
    get integrationAccountNameInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _guestIdentity;
    /**
     * @stability stable
     */
    get guestIdentity(): LogicAppIntegrationAccountAgreementGuestIdentityOutputReference;
    /**
     * @stability stable
     */
    putGuestIdentity(value: LogicAppIntegrationAccountAgreementGuestIdentity): void;
    /**
     * @stability stable
     */
    get guestIdentityInput(): LogicAppIntegrationAccountAgreementGuestIdentity | undefined;
    private _hostIdentity;
    /**
     * @stability stable
     */
    get hostIdentity(): LogicAppIntegrationAccountAgreementHostIdentityOutputReference;
    /**
     * @stability stable
     */
    putHostIdentity(value: LogicAppIntegrationAccountAgreementHostIdentity): void;
    /**
     * @stability stable
     */
    get hostIdentityInput(): LogicAppIntegrationAccountAgreementHostIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppIntegrationAccountAgreementTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppIntegrationAccountAgreementTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppIntegrationAccountAgreementTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
