import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppTriggerRecurrenceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#frequency LogicAppTriggerRecurrence#frequency}.
     *
     * @stability stable
     */
    readonly frequency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#interval LogicAppTriggerRecurrence#interval}.
     *
     * @stability stable
     */
    readonly interval: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#logic_app_id LogicAppTriggerRecurrence#logic_app_id}.
     *
     * @stability stable
     */
    readonly logicAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#name LogicAppTriggerRecurrence#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#start_time LogicAppTriggerRecurrence#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#time_zone LogicAppTriggerRecurrence#time_zone}.
     *
     * @stability stable
     */
    readonly timeZone?: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#schedule LogicAppTriggerRecurrence#schedule}
     *
     * @stability stable
     */
    readonly schedule?: LogicAppTriggerRecurrenceSchedule;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#timeouts LogicAppTriggerRecurrence#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppTriggerRecurrenceTimeouts;
}
/**
 * @stability stable
 */
export interface LogicAppTriggerRecurrenceSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#at_these_hours LogicAppTriggerRecurrence#at_these_hours}.
     *
     * @stability stable
     */
    readonly atTheseHours?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#at_these_minutes LogicAppTriggerRecurrence#at_these_minutes}.
     *
     * @stability stable
     */
    readonly atTheseMinutes?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#on_these_days LogicAppTriggerRecurrence#on_these_days}.
     *
     * @stability stable
     */
    readonly onTheseDays?: string[];
}
export declare function logicAppTriggerRecurrenceScheduleToTerraform(struct?: LogicAppTriggerRecurrenceScheduleOutputReference | LogicAppTriggerRecurrenceSchedule): any;
/**
 * @stability stable
 */
export declare class LogicAppTriggerRecurrenceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppTriggerRecurrenceSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppTriggerRecurrenceSchedule | undefined);
    private _atTheseHours?;
    /**
     * @stability stable
     */
    get atTheseHours(): number[];
    /**
     * @stability stable
     */
    set atTheseHours(value: number[]);
    /**
     * @stability stable
     */
    resetAtTheseHours(): void;
    /**
     * @stability stable
     */
    get atTheseHoursInput(): number[] | undefined;
    private _atTheseMinutes?;
    /**
     * @stability stable
     */
    get atTheseMinutes(): number[];
    /**
     * @stability stable
     */
    set atTheseMinutes(value: number[]);
    /**
     * @stability stable
     */
    resetAtTheseMinutes(): void;
    /**
     * @stability stable
     */
    get atTheseMinutesInput(): number[] | undefined;
    private _onTheseDays?;
    /**
     * @stability stable
     */
    get onTheseDays(): string[];
    /**
     * @stability stable
     */
    set onTheseDays(value: string[]);
    /**
     * @stability stable
     */
    resetOnTheseDays(): void;
    /**
     * @stability stable
     */
    get onTheseDaysInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppTriggerRecurrenceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#create LogicAppTriggerRecurrence#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#delete LogicAppTriggerRecurrence#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#read LogicAppTriggerRecurrence#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence#update LogicAppTriggerRecurrence#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppTriggerRecurrenceTimeoutsToTerraform(struct?: LogicAppTriggerRecurrenceTimeoutsOutputReference | LogicAppTriggerRecurrenceTimeouts): any;
/**
 * @stability stable
 */
export declare class LogicAppTriggerRecurrenceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppTriggerRecurrenceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppTriggerRecurrenceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence azurerm_logic_app_trigger_recurrence}.
 *
 * @stability stable
 */
export declare class LogicAppTriggerRecurrence extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_recurrence azurerm_logic_app_trigger_recurrence} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppTriggerRecurrenceConfig);
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
    private _logicAppId?;
    /**
     * @stability stable
     */
    get logicAppId(): string;
    /**
     * @stability stable
     */
    set logicAppId(value: string);
    /**
     * @stability stable
     */
    get logicAppIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _timeZone?;
    /**
     * @stability stable
     */
    get timeZone(): string;
    /**
     * @stability stable
     */
    set timeZone(value: string);
    /**
     * @stability stable
     */
    resetTimeZone(): void;
    /**
     * @stability stable
     */
    get timeZoneInput(): string | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): LogicAppTriggerRecurrenceScheduleOutputReference;
    /**
     * @stability stable
     */
    putSchedule(value: LogicAppTriggerRecurrenceSchedule): void;
    /**
     * @stability stable
     */
    resetSchedule(): void;
    /**
     * @stability stable
     */
    get scheduleInput(): LogicAppTriggerRecurrenceSchedule | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppTriggerRecurrenceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppTriggerRecurrenceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppTriggerRecurrenceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
