import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MachineLearningSynapseSparkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#description MachineLearningSynapseSpark#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#local_auth_enabled MachineLearningSynapseSpark#local_auth_enabled}.
     *
     * @stability stable
     */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#location MachineLearningSynapseSpark#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#machine_learning_workspace_id MachineLearningSynapseSpark#machine_learning_workspace_id}.
     *
     * @stability stable
     */
    readonly machineLearningWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#name MachineLearningSynapseSpark#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#synapse_spark_pool_id MachineLearningSynapseSpark#synapse_spark_pool_id}.
     *
     * @stability stable
     */
    readonly synapseSparkPoolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#tags MachineLearningSynapseSpark#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#identity MachineLearningSynapseSpark#identity}
     *
     * @stability stable
     */
    readonly identity?: MachineLearningSynapseSparkIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#timeouts MachineLearningSynapseSpark#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MachineLearningSynapseSparkTimeouts;
}
/**
 * @stability stable
 */
export interface MachineLearningSynapseSparkIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#identity_ids MachineLearningSynapseSpark#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#type MachineLearningSynapseSpark#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function machineLearningSynapseSparkIdentityToTerraform(struct?: MachineLearningSynapseSparkIdentityOutputReference | MachineLearningSynapseSparkIdentity): any;
/**
 * @stability stable
 */
export declare class MachineLearningSynapseSparkIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningSynapseSparkIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningSynapseSparkIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningSynapseSparkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#create MachineLearningSynapseSpark#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#delete MachineLearningSynapseSpark#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark#read MachineLearningSynapseSpark#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function machineLearningSynapseSparkTimeoutsToTerraform(struct?: MachineLearningSynapseSparkTimeoutsOutputReference | MachineLearningSynapseSparkTimeouts): any;
/**
 * @stability stable
 */
export declare class MachineLearningSynapseSparkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningSynapseSparkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningSynapseSparkTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark azurerm_machine_learning_synapse_spark}.
 *
 * @stability stable
 */
export declare class MachineLearningSynapseSpark extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_synapse_spark azurerm_machine_learning_synapse_spark} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MachineLearningSynapseSparkConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _localAuthEnabled?;
    /**
     * @stability stable
     */
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthEnabled(): void;
    /**
     * @stability stable
     */
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    /**
     * @stability stable
     */
    get machineLearningWorkspaceId(): string;
    /**
     * @stability stable
     */
    set machineLearningWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _synapseSparkPoolId?;
    /**
     * @stability stable
     */
    get synapseSparkPoolId(): string;
    /**
     * @stability stable
     */
    set synapseSparkPoolId(value: string);
    /**
     * @stability stable
     */
    get synapseSparkPoolIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MachineLearningSynapseSparkIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MachineLearningSynapseSparkIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): MachineLearningSynapseSparkIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MachineLearningSynapseSparkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MachineLearningSynapseSparkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MachineLearningSynapseSparkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
