import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MachineLearningWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#application_insights_id MachineLearningWorkspace#application_insights_id}.
     *
     * @stability stable
     */
    readonly applicationInsightsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#container_registry_id MachineLearningWorkspace#container_registry_id}.
     *
     * @stability stable
     */
    readonly containerRegistryId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#description MachineLearningWorkspace#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#friendly_name MachineLearningWorkspace#friendly_name}.
     *
     * @stability stable
     */
    readonly friendlyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#high_business_impact MachineLearningWorkspace#high_business_impact}.
     *
     * @stability stable
     */
    readonly highBusinessImpact?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#image_build_compute_name MachineLearningWorkspace#image_build_compute_name}.
     *
     * @stability stable
     */
    readonly imageBuildComputeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#key_vault_id MachineLearningWorkspace#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#location MachineLearningWorkspace#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#name MachineLearningWorkspace#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#public_network_access_enabled MachineLearningWorkspace#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#resource_group_name MachineLearningWorkspace#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#sku_name MachineLearningWorkspace#sku_name}.
     *
     * @stability stable
     */
    readonly skuName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#storage_account_id MachineLearningWorkspace#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#tags MachineLearningWorkspace#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#encryption MachineLearningWorkspace#encryption}
     *
     * @stability stable
     */
    readonly encryption?: MachineLearningWorkspaceEncryption;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#identity MachineLearningWorkspace#identity}
     *
     * @stability stable
     */
    readonly identity: MachineLearningWorkspaceIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#timeouts MachineLearningWorkspace#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MachineLearningWorkspaceTimeouts;
}
/**
 * @stability stable
 */
export interface MachineLearningWorkspaceEncryption {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#key_id MachineLearningWorkspace#key_id}.
     *
     * @stability stable
     */
    readonly keyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#key_vault_id MachineLearningWorkspace#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
}
export declare function machineLearningWorkspaceEncryptionToTerraform(struct?: MachineLearningWorkspaceEncryptionOutputReference | MachineLearningWorkspaceEncryption): any;
/**
 * @stability stable
 */
export declare class MachineLearningWorkspaceEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningWorkspaceEncryption | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningWorkspaceEncryption | undefined);
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    set keyId(value: string);
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningWorkspaceIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#type MachineLearningWorkspace#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function machineLearningWorkspaceIdentityToTerraform(struct?: MachineLearningWorkspaceIdentityOutputReference | MachineLearningWorkspaceIdentity): any;
/**
 * @stability stable
 */
export declare class MachineLearningWorkspaceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningWorkspaceIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningWorkspaceIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningWorkspaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#create MachineLearningWorkspace#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#delete MachineLearningWorkspace#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#read MachineLearningWorkspace#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace#update MachineLearningWorkspace#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function machineLearningWorkspaceTimeoutsToTerraform(struct?: MachineLearningWorkspaceTimeoutsOutputReference | MachineLearningWorkspaceTimeouts): any;
/**
 * @stability stable
 */
export declare class MachineLearningWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningWorkspaceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace azurerm_machine_learning_workspace}.
 *
 * @stability stable
 */
export declare class MachineLearningWorkspace extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_workspace azurerm_machine_learning_workspace} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MachineLearningWorkspaceConfig);
    private _applicationInsightsId?;
    /**
     * @stability stable
     */
    get applicationInsightsId(): string;
    /**
     * @stability stable
     */
    set applicationInsightsId(value: string);
    /**
     * @stability stable
     */
    get applicationInsightsIdInput(): string | undefined;
    private _containerRegistryId?;
    /**
     * @stability stable
     */
    get containerRegistryId(): string;
    /**
     * @stability stable
     */
    set containerRegistryId(value: string);
    /**
     * @stability stable
     */
    resetContainerRegistryId(): void;
    /**
     * @stability stable
     */
    get containerRegistryIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get discoveryUrl(): string;
    private _friendlyName?;
    /**
     * @stability stable
     */
    get friendlyName(): string;
    /**
     * @stability stable
     */
    set friendlyName(value: string);
    /**
     * @stability stable
     */
    resetFriendlyName(): void;
    /**
     * @stability stable
     */
    get friendlyNameInput(): string | undefined;
    private _highBusinessImpact?;
    /**
     * @stability stable
     */
    get highBusinessImpact(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set highBusinessImpact(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHighBusinessImpact(): void;
    /**
     * @stability stable
     */
    get highBusinessImpactInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageBuildComputeName?;
    /**
     * @stability stable
     */
    get imageBuildComputeName(): string;
    /**
     * @stability stable
     */
    set imageBuildComputeName(value: string);
    /**
     * @stability stable
     */
    resetImageBuildComputeName(): void;
    /**
     * @stability stable
     */
    get imageBuildComputeNameInput(): string | undefined;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    resetSkuName(): void;
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _encryption;
    /**
     * @stability stable
     */
    get encryption(): MachineLearningWorkspaceEncryptionOutputReference;
    /**
     * @stability stable
     */
    putEncryption(value: MachineLearningWorkspaceEncryption): void;
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): MachineLearningWorkspaceEncryption | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MachineLearningWorkspaceIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MachineLearningWorkspaceIdentity): void;
    /**
     * @stability stable
     */
    get identityInput(): MachineLearningWorkspaceIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MachineLearningWorkspaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MachineLearningWorkspaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MachineLearningWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
