import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ManagedApplicationDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#create_ui_definition ManagedApplicationDefinition#create_ui_definition}.
     *
     * @stability stable
     */
    readonly createUiDefinition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#description ManagedApplicationDefinition#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#display_name ManagedApplicationDefinition#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#location ManagedApplicationDefinition#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#lock_level ManagedApplicationDefinition#lock_level}.
     *
     * @stability stable
     */
    readonly lockLevel: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#main_template ManagedApplicationDefinition#main_template}.
     *
     * @stability stable
     */
    readonly mainTemplate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#name ManagedApplicationDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#package_enabled ManagedApplicationDefinition#package_enabled}.
     *
     * @stability stable
     */
    readonly packageEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#package_file_uri ManagedApplicationDefinition#package_file_uri}.
     *
     * @stability stable
     */
    readonly packageFileUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#resource_group_name ManagedApplicationDefinition#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#tags ManagedApplicationDefinition#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * authorization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#authorization ManagedApplicationDefinition#authorization}
     *
     * @stability stable
     */
    readonly authorization?: ManagedApplicationDefinitionAuthorization[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#timeouts ManagedApplicationDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ManagedApplicationDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface ManagedApplicationDefinitionAuthorization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#role_definition_id ManagedApplicationDefinition#role_definition_id}.
     *
     * @stability stable
     */
    readonly roleDefinitionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#service_principal_id ManagedApplicationDefinition#service_principal_id}.
     *
     * @stability stable
     */
    readonly servicePrincipalId: string;
}
export declare function managedApplicationDefinitionAuthorizationToTerraform(struct?: ManagedApplicationDefinitionAuthorization): any;
/**
 * @stability stable
 */
export interface ManagedApplicationDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#create ManagedApplicationDefinition#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#delete ManagedApplicationDefinition#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#read ManagedApplicationDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition#update ManagedApplicationDefinition#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function managedApplicationDefinitionTimeoutsToTerraform(struct?: ManagedApplicationDefinitionTimeoutsOutputReference | ManagedApplicationDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class ManagedApplicationDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagedApplicationDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagedApplicationDefinitionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition azurerm_managed_application_definition}.
 *
 * @stability stable
 */
export declare class ManagedApplicationDefinition extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application_definition azurerm_managed_application_definition} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ManagedApplicationDefinitionConfig);
    private _createUiDefinition?;
    /**
     * @stability stable
     */
    get createUiDefinition(): string;
    /**
     * @stability stable
     */
    set createUiDefinition(value: string);
    /**
     * @stability stable
     */
    resetCreateUiDefinition(): void;
    /**
     * @stability stable
     */
    get createUiDefinitionInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _lockLevel?;
    /**
     * @stability stable
     */
    get lockLevel(): string;
    /**
     * @stability stable
     */
    set lockLevel(value: string);
    /**
     * @stability stable
     */
    get lockLevelInput(): string | undefined;
    private _mainTemplate?;
    /**
     * @stability stable
     */
    get mainTemplate(): string;
    /**
     * @stability stable
     */
    set mainTemplate(value: string);
    /**
     * @stability stable
     */
    resetMainTemplate(): void;
    /**
     * @stability stable
     */
    get mainTemplateInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _packageEnabled?;
    /**
     * @stability stable
     */
    get packageEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set packageEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPackageEnabled(): void;
    /**
     * @stability stable
     */
    get packageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _packageFileUri?;
    /**
     * @stability stable
     */
    get packageFileUri(): string;
    /**
     * @stability stable
     */
    set packageFileUri(value: string);
    /**
     * @stability stable
     */
    resetPackageFileUri(): void;
    /**
     * @stability stable
     */
    get packageFileUriInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _authorization?;
    /**
     * @stability stable
     */
    get authorization(): ManagedApplicationDefinitionAuthorization[];
    /**
     * @stability stable
     */
    set authorization(value: ManagedApplicationDefinitionAuthorization[]);
    /**
     * @stability stable
     */
    resetAuthorization(): void;
    /**
     * @stability stable
     */
    get authorizationInput(): ManagedApplicationDefinitionAuthorization[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ManagedApplicationDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ManagedApplicationDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ManagedApplicationDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
