import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ManagedApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#application_definition_id ManagedApplication#application_definition_id}.
     *
     * @stability stable
     */
    readonly applicationDefinitionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#kind ManagedApplication#kind}.
     *
     * @stability stable
     */
    readonly kind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#location ManagedApplication#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#managed_resource_group_name ManagedApplication#managed_resource_group_name}.
     *
     * @stability stable
     */
    readonly managedResourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#name ManagedApplication#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#parameter_values ManagedApplication#parameter_values}.
     *
     * @stability stable
     */
    readonly parameterValues?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#parameters ManagedApplication#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#resource_group_name ManagedApplication#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#tags ManagedApplication#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#plan ManagedApplication#plan}
     *
     * @stability stable
     */
    readonly plan?: ManagedApplicationPlan;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#timeouts ManagedApplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ManagedApplicationTimeouts;
}
/**
 * @stability stable
 */
export interface ManagedApplicationPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#name ManagedApplication#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#product ManagedApplication#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#promotion_code ManagedApplication#promotion_code}.
     *
     * @stability stable
     */
    readonly promotionCode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#publisher ManagedApplication#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#version ManagedApplication#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function managedApplicationPlanToTerraform(struct?: ManagedApplicationPlanOutputReference | ManagedApplicationPlan): any;
/**
 * @stability stable
 */
export declare class ManagedApplicationPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagedApplicationPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagedApplicationPlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _promotionCode?;
    /**
     * @stability stable
     */
    get promotionCode(): string;
    /**
     * @stability stable
     */
    set promotionCode(value: string);
    /**
     * @stability stable
     */
    resetPromotionCode(): void;
    /**
     * @stability stable
     */
    get promotionCodeInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ManagedApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#create ManagedApplication#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#delete ManagedApplication#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#read ManagedApplication#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application#update ManagedApplication#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function managedApplicationTimeoutsToTerraform(struct?: ManagedApplicationTimeoutsOutputReference | ManagedApplicationTimeouts): any;
/**
 * @stability stable
 */
export declare class ManagedApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagedApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagedApplicationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application azurerm_managed_application}.
 *
 * @stability stable
 */
export declare class ManagedApplication extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/managed_application azurerm_managed_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ManagedApplicationConfig);
    private _applicationDefinitionId?;
    /**
     * @stability stable
     */
    get applicationDefinitionId(): string;
    /**
     * @stability stable
     */
    set applicationDefinitionId(value: string);
    /**
     * @stability stable
     */
    resetApplicationDefinitionId(): void;
    /**
     * @stability stable
     */
    get applicationDefinitionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _managedResourceGroupName?;
    /**
     * @stability stable
     */
    get managedResourceGroupName(): string;
    /**
     * @stability stable
     */
    set managedResourceGroupName(value: string);
    /**
     * @stability stable
     */
    get managedResourceGroupNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    outputs(key: string): string;
    private _parameterValues?;
    /**
     * @stability stable
     */
    get parameterValues(): string;
    /**
     * @stability stable
     */
    set parameterValues(value: string);
    /**
     * @stability stable
     */
    resetParameterValues(): void;
    /**
     * @stability stable
     */
    get parameterValuesInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): ManagedApplicationPlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: ManagedApplicationPlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): ManagedApplicationPlan | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ManagedApplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ManagedApplicationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ManagedApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
