import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ManagedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#create_option ManagedDisk#create_option}.
     *
     * @stability stable
     */
    readonly createOption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_access_id ManagedDisk#disk_access_id}.
     *
     * @stability stable
     */
    readonly diskAccessId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_encryption_set_id ManagedDisk#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_iops_read_only ManagedDisk#disk_iops_read_only}.
     *
     * @stability stable
     */
    readonly diskIopsReadOnly?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_iops_read_write ManagedDisk#disk_iops_read_write}.
     *
     * @stability stable
     */
    readonly diskIopsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_mbps_read_only ManagedDisk#disk_mbps_read_only}.
     *
     * @stability stable
     */
    readonly diskMbpsReadOnly?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_mbps_read_write ManagedDisk#disk_mbps_read_write}.
     *
     * @stability stable
     */
    readonly diskMbpsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_size_gb ManagedDisk#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#gallery_image_reference_id ManagedDisk#gallery_image_reference_id}.
     *
     * @stability stable
     */
    readonly galleryImageReferenceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#hyper_v_generation ManagedDisk#hyper_v_generation}.
     *
     * @stability stable
     */
    readonly hyperVGeneration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#image_reference_id ManagedDisk#image_reference_id}.
     *
     * @stability stable
     */
    readonly imageReferenceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#location ManagedDisk#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#logical_sector_size ManagedDisk#logical_sector_size}.
     *
     * @stability stable
     */
    readonly logicalSectorSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#max_shares ManagedDisk#max_shares}.
     *
     * @stability stable
     */
    readonly maxShares?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#name ManagedDisk#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#network_access_policy ManagedDisk#network_access_policy}.
     *
     * @stability stable
     */
    readonly networkAccessPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#on_demand_bursting_enabled ManagedDisk#on_demand_bursting_enabled}.
     *
     * @stability stable
     */
    readonly onDemandBurstingEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#os_type ManagedDisk#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#public_network_access_enabled ManagedDisk#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#resource_group_name ManagedDisk#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#source_resource_id ManagedDisk#source_resource_id}.
     *
     * @stability stable
     */
    readonly sourceResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#source_uri ManagedDisk#source_uri}.
     *
     * @stability stable
     */
    readonly sourceUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#storage_account_id ManagedDisk#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#storage_account_type ManagedDisk#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#tags ManagedDisk#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#tier ManagedDisk#tier}.
     *
     * @stability stable
     */
    readonly tier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#trusted_launch_enabled ManagedDisk#trusted_launch_enabled}.
     *
     * @stability stable
     */
    readonly trustedLaunchEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#zones ManagedDisk#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * encryption_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#encryption_settings ManagedDisk#encryption_settings}
     *
     * @stability stable
     */
    readonly encryptionSettings?: ManagedDiskEncryptionSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#timeouts ManagedDisk#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ManagedDiskTimeouts;
}
/**
 * @stability stable
 */
export interface ManagedDiskEncryptionSettingsDiskEncryptionKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#secret_url ManagedDisk#secret_url}.
     *
     * @stability stable
     */
    readonly secretUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#source_vault_id ManagedDisk#source_vault_id}.
     *
     * @stability stable
     */
    readonly sourceVaultId: string;
}
export declare function managedDiskEncryptionSettingsDiskEncryptionKeyToTerraform(struct?: ManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference | ManagedDiskEncryptionSettingsDiskEncryptionKey): any;
/**
 * @stability stable
 */
export declare class ManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagedDiskEncryptionSettingsDiskEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagedDiskEncryptionSettingsDiskEncryptionKey | undefined);
    private _secretUrl?;
    /**
     * @stability stable
     */
    get secretUrl(): string;
    /**
     * @stability stable
     */
    set secretUrl(value: string);
    /**
     * @stability stable
     */
    get secretUrlInput(): string | undefined;
    private _sourceVaultId?;
    /**
     * @stability stable
     */
    get sourceVaultId(): string;
    /**
     * @stability stable
     */
    set sourceVaultId(value: string);
    /**
     * @stability stable
     */
    get sourceVaultIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ManagedDiskEncryptionSettingsKeyEncryptionKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#key_url ManagedDisk#key_url}.
     *
     * @stability stable
     */
    readonly keyUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#source_vault_id ManagedDisk#source_vault_id}.
     *
     * @stability stable
     */
    readonly sourceVaultId: string;
}
export declare function managedDiskEncryptionSettingsKeyEncryptionKeyToTerraform(struct?: ManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference | ManagedDiskEncryptionSettingsKeyEncryptionKey): any;
/**
 * @stability stable
 */
export declare class ManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagedDiskEncryptionSettingsKeyEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagedDiskEncryptionSettingsKeyEncryptionKey | undefined);
    private _keyUrl?;
    /**
     * @stability stable
     */
    get keyUrl(): string;
    /**
     * @stability stable
     */
    set keyUrl(value: string);
    /**
     * @stability stable
     */
    get keyUrlInput(): string | undefined;
    private _sourceVaultId?;
    /**
     * @stability stable
     */
    get sourceVaultId(): string;
    /**
     * @stability stable
     */
    set sourceVaultId(value: string);
    /**
     * @stability stable
     */
    get sourceVaultIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ManagedDiskEncryptionSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#enabled ManagedDisk#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#disk_encryption_key ManagedDisk#disk_encryption_key}
     *
     * @stability stable
     */
    readonly diskEncryptionKey?: ManagedDiskEncryptionSettingsDiskEncryptionKey;
    /**
     * key_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#key_encryption_key ManagedDisk#key_encryption_key}
     *
     * @stability stable
     */
    readonly keyEncryptionKey?: ManagedDiskEncryptionSettingsKeyEncryptionKey;
}
export declare function managedDiskEncryptionSettingsToTerraform(struct?: ManagedDiskEncryptionSettingsOutputReference | ManagedDiskEncryptionSettings): any;
/**
 * @stability stable
 */
export declare class ManagedDiskEncryptionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagedDiskEncryptionSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagedDiskEncryptionSettings | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskEncryptionKey;
    /**
     * @stability stable
     */
    get diskEncryptionKey(): ManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putDiskEncryptionKey(value: ManagedDiskEncryptionSettingsDiskEncryptionKey): void;
    /**
     * @stability stable
     */
    resetDiskEncryptionKey(): void;
    /**
     * @stability stable
     */
    get diskEncryptionKeyInput(): ManagedDiskEncryptionSettingsDiskEncryptionKey | undefined;
    private _keyEncryptionKey;
    /**
     * @stability stable
     */
    get keyEncryptionKey(): ManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putKeyEncryptionKey(value: ManagedDiskEncryptionSettingsKeyEncryptionKey): void;
    /**
     * @stability stable
     */
    resetKeyEncryptionKey(): void;
    /**
     * @stability stable
     */
    get keyEncryptionKeyInput(): ManagedDiskEncryptionSettingsKeyEncryptionKey | undefined;
}
/**
 * @stability stable
 */
export interface ManagedDiskTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#create ManagedDisk#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#delete ManagedDisk#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#read ManagedDisk#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk#update ManagedDisk#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function managedDiskTimeoutsToTerraform(struct?: ManagedDiskTimeoutsOutputReference | ManagedDiskTimeouts): any;
/**
 * @stability stable
 */
export declare class ManagedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagedDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagedDiskTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk azurerm_managed_disk}.
 *
 * @stability stable
 */
export declare class ManagedDisk extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/managed_disk azurerm_managed_disk} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ManagedDiskConfig);
    private _createOption?;
    /**
     * @stability stable
     */
    get createOption(): string;
    /**
     * @stability stable
     */
    set createOption(value: string);
    /**
     * @stability stable
     */
    get createOptionInput(): string | undefined;
    private _diskAccessId?;
    /**
     * @stability stable
     */
    get diskAccessId(): string;
    /**
     * @stability stable
     */
    set diskAccessId(value: string);
    /**
     * @stability stable
     */
    resetDiskAccessId(): void;
    /**
     * @stability stable
     */
    get diskAccessIdInput(): string | undefined;
    private _diskEncryptionSetId?;
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    set diskEncryptionSetId(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionSetId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskIopsReadOnly?;
    /**
     * @stability stable
     */
    get diskIopsReadOnly(): number;
    /**
     * @stability stable
     */
    set diskIopsReadOnly(value: number);
    /**
     * @stability stable
     */
    resetDiskIopsReadOnly(): void;
    /**
     * @stability stable
     */
    get diskIopsReadOnlyInput(): number | undefined;
    private _diskIopsReadWrite?;
    /**
     * @stability stable
     */
    get diskIopsReadWrite(): number;
    /**
     * @stability stable
     */
    set diskIopsReadWrite(value: number);
    /**
     * @stability stable
     */
    resetDiskIopsReadWrite(): void;
    /**
     * @stability stable
     */
    get diskIopsReadWriteInput(): number | undefined;
    private _diskMbpsReadOnly?;
    /**
     * @stability stable
     */
    get diskMbpsReadOnly(): number;
    /**
     * @stability stable
     */
    set diskMbpsReadOnly(value: number);
    /**
     * @stability stable
     */
    resetDiskMbpsReadOnly(): void;
    /**
     * @stability stable
     */
    get diskMbpsReadOnlyInput(): number | undefined;
    private _diskMbpsReadWrite?;
    /**
     * @stability stable
     */
    get diskMbpsReadWrite(): number;
    /**
     * @stability stable
     */
    set diskMbpsReadWrite(value: number);
    /**
     * @stability stable
     */
    resetDiskMbpsReadWrite(): void;
    /**
     * @stability stable
     */
    get diskMbpsReadWriteInput(): number | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _galleryImageReferenceId?;
    /**
     * @stability stable
     */
    get galleryImageReferenceId(): string;
    /**
     * @stability stable
     */
    set galleryImageReferenceId(value: string);
    /**
     * @stability stable
     */
    resetGalleryImageReferenceId(): void;
    /**
     * @stability stable
     */
    get galleryImageReferenceIdInput(): string | undefined;
    private _hyperVGeneration?;
    /**
     * @stability stable
     */
    get hyperVGeneration(): string;
    /**
     * @stability stable
     */
    set hyperVGeneration(value: string);
    /**
     * @stability stable
     */
    resetHyperVGeneration(): void;
    /**
     * @stability stable
     */
    get hyperVGenerationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageReferenceId?;
    /**
     * @stability stable
     */
    get imageReferenceId(): string;
    /**
     * @stability stable
     */
    set imageReferenceId(value: string);
    /**
     * @stability stable
     */
    resetImageReferenceId(): void;
    /**
     * @stability stable
     */
    get imageReferenceIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _logicalSectorSize?;
    /**
     * @stability stable
     */
    get logicalSectorSize(): number;
    /**
     * @stability stable
     */
    set logicalSectorSize(value: number);
    /**
     * @stability stable
     */
    resetLogicalSectorSize(): void;
    /**
     * @stability stable
     */
    get logicalSectorSizeInput(): number | undefined;
    private _maxShares?;
    /**
     * @stability stable
     */
    get maxShares(): number;
    /**
     * @stability stable
     */
    set maxShares(value: number);
    /**
     * @stability stable
     */
    resetMaxShares(): void;
    /**
     * @stability stable
     */
    get maxSharesInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkAccessPolicy?;
    /**
     * @stability stable
     */
    get networkAccessPolicy(): string;
    /**
     * @stability stable
     */
    set networkAccessPolicy(value: string);
    /**
     * @stability stable
     */
    resetNetworkAccessPolicy(): void;
    /**
     * @stability stable
     */
    get networkAccessPolicyInput(): string | undefined;
    private _onDemandBurstingEnabled?;
    /**
     * @stability stable
     */
    get onDemandBurstingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onDemandBurstingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnDemandBurstingEnabled(): void;
    /**
     * @stability stable
     */
    get onDemandBurstingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceResourceId?;
    /**
     * @stability stable
     */
    get sourceResourceId(): string;
    /**
     * @stability stable
     */
    set sourceResourceId(value: string);
    /**
     * @stability stable
     */
    resetSourceResourceId(): void;
    /**
     * @stability stable
     */
    get sourceResourceIdInput(): string | undefined;
    private _sourceUri?;
    /**
     * @stability stable
     */
    get sourceUri(): string;
    /**
     * @stability stable
     */
    set sourceUri(value: string);
    /**
     * @stability stable
     */
    resetSourceUri(): void;
    /**
     * @stability stable
     */
    get sourceUriInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageAccountType?;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    set storageAccountType(value: string);
    /**
     * @stability stable
     */
    get storageAccountTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    resetTier(): void;
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _trustedLaunchEnabled?;
    /**
     * @stability stable
     */
    get trustedLaunchEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set trustedLaunchEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTrustedLaunchEnabled(): void;
    /**
     * @stability stable
     */
    get trustedLaunchEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _encryptionSettings;
    /**
     * @stability stable
     */
    get encryptionSettings(): ManagedDiskEncryptionSettingsOutputReference;
    /**
     * @stability stable
     */
    putEncryptionSettings(value: ManagedDiskEncryptionSettings): void;
    /**
     * @stability stable
     */
    resetEncryptionSettings(): void;
    /**
     * @stability stable
     */
    get encryptionSettingsInput(): ManagedDiskEncryptionSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ManagedDiskTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ManagedDiskTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ManagedDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
