import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ManagementGroupSubscriptionAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#management_group_id ManagementGroupSubscriptionAssociation#management_group_id}.
     *
     * @stability stable
     */
    readonly managementGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#subscription_id ManagementGroupSubscriptionAssociation#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#timeouts ManagementGroupSubscriptionAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ManagementGroupSubscriptionAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface ManagementGroupSubscriptionAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#create ManagementGroupSubscriptionAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#delete ManagementGroupSubscriptionAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#read ManagementGroupSubscriptionAssociation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function managementGroupSubscriptionAssociationTimeoutsToTerraform(struct?: ManagementGroupSubscriptionAssociationTimeoutsOutputReference | ManagementGroupSubscriptionAssociationTimeouts): any;
/**
 * @stability stable
 */
export declare class ManagementGroupSubscriptionAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ManagementGroupSubscriptionAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ManagementGroupSubscriptionAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association azurerm_management_group_subscription_association}.
 *
 * @stability stable
 */
export declare class ManagementGroupSubscriptionAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association azurerm_management_group_subscription_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ManagementGroupSubscriptionAssociationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _managementGroupId?;
    /**
     * @stability stable
     */
    get managementGroupId(): string;
    /**
     * @stability stable
     */
    set managementGroupId(value: string);
    /**
     * @stability stable
     */
    get managementGroupIdInput(): string | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ManagementGroupSubscriptionAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ManagementGroupSubscriptionAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ManagementGroupSubscriptionAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
