import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MariadbServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#administrator_login MariadbServer#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#administrator_login_password MariadbServer#administrator_login_password}.
     *
     * @stability stable
     */
    readonly administratorLoginPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#auto_grow_enabled MariadbServer#auto_grow_enabled}.
     *
     * @stability stable
     */
    readonly autoGrowEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#backup_retention_days MariadbServer#backup_retention_days}.
     *
     * @stability stable
     */
    readonly backupRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#create_mode MariadbServer#create_mode}.
     *
     * @stability stable
     */
    readonly createMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#creation_source_server_id MariadbServer#creation_source_server_id}.
     *
     * @stability stable
     */
    readonly creationSourceServerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#geo_redundant_backup_enabled MariadbServer#geo_redundant_backup_enabled}.
     *
     * @stability stable
     */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#location MariadbServer#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#name MariadbServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#public_network_access_enabled MariadbServer#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#resource_group_name MariadbServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#restore_point_in_time MariadbServer#restore_point_in_time}.
     *
     * @stability stable
     */
    readonly restorePointInTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#sku_name MariadbServer#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#ssl_enforcement MariadbServer#ssl_enforcement}.
     *
     * @stability stable
     */
    readonly sslEnforcement?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#ssl_enforcement_enabled MariadbServer#ssl_enforcement_enabled}.
     *
     * @stability stable
     */
    readonly sslEnforcementEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#storage_mb MariadbServer#storage_mb}.
     *
     * @stability stable
     */
    readonly storageMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#tags MariadbServer#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#version MariadbServer#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * storage_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#storage_profile MariadbServer#storage_profile}
     *
     * @stability stable
     */
    readonly storageProfile?: MariadbServerStorageProfile;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#timeouts MariadbServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MariadbServerTimeouts;
}
/**
 * @stability stable
 */
export interface MariadbServerStorageProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#auto_grow MariadbServer#auto_grow}.
     *
     * @stability stable
     */
    readonly autoGrow?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#backup_retention_days MariadbServer#backup_retention_days}.
     *
     * @stability stable
     */
    readonly backupRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#geo_redundant_backup MariadbServer#geo_redundant_backup}.
     *
     * @stability stable
     */
    readonly geoRedundantBackup?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#storage_mb MariadbServer#storage_mb}.
     *
     * @stability stable
     */
    readonly storageMb?: number;
}
export declare function mariadbServerStorageProfileToTerraform(struct?: MariadbServerStorageProfileOutputReference | MariadbServerStorageProfile): any;
/**
 * @stability stable
 */
export declare class MariadbServerStorageProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MariadbServerStorageProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MariadbServerStorageProfile | undefined);
    private _autoGrow?;
    /**
     * @stability stable
     */
    get autoGrow(): string;
    /**
     * @stability stable
     */
    set autoGrow(value: string);
    /**
     * @stability stable
     */
    resetAutoGrow(): void;
    /**
     * @stability stable
     */
    get autoGrowInput(): string | undefined;
    private _backupRetentionDays?;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    set backupRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetBackupRetentionDays(): void;
    /**
     * @stability stable
     */
    get backupRetentionDaysInput(): number | undefined;
    private _geoRedundantBackup?;
    /**
     * @stability stable
     */
    get geoRedundantBackup(): string;
    /**
     * @stability stable
     */
    set geoRedundantBackup(value: string);
    /**
     * @stability stable
     */
    resetGeoRedundantBackup(): void;
    /**
     * @stability stable
     */
    get geoRedundantBackupInput(): string | undefined;
    private _storageMb?;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    set storageMb(value: number);
    /**
     * @stability stable
     */
    resetStorageMb(): void;
    /**
     * @stability stable
     */
    get storageMbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MariadbServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#create MariadbServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#delete MariadbServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#read MariadbServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#update MariadbServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mariadbServerTimeoutsToTerraform(struct?: MariadbServerTimeoutsOutputReference | MariadbServerTimeouts): any;
/**
 * @stability stable
 */
export declare class MariadbServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MariadbServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MariadbServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server azurerm_mariadb_server}.
 *
 * @stability stable
 */
export declare class MariadbServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server azurerm_mariadb_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MariadbServerConfig);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLogin(): void;
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    /**
     * @stability stable
     */
    get administratorLoginPassword(): string;
    /**
     * @stability stable
     */
    set administratorLoginPassword(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLoginPassword(): void;
    /**
     * @stability stable
     */
    get administratorLoginPasswordInput(): string | undefined;
    private _autoGrowEnabled?;
    /**
     * @stability stable
     */
    get autoGrowEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoGrowEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoGrowEnabled(): void;
    /**
     * @stability stable
     */
    get autoGrowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _backupRetentionDays?;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    set backupRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetBackupRetentionDays(): void;
    /**
     * @stability stable
     */
    get backupRetentionDaysInput(): number | undefined;
    private _createMode?;
    /**
     * @stability stable
     */
    get createMode(): string;
    /**
     * @stability stable
     */
    set createMode(value: string);
    /**
     * @stability stable
     */
    resetCreateMode(): void;
    /**
     * @stability stable
     */
    get createModeInput(): string | undefined;
    private _creationSourceServerId?;
    /**
     * @stability stable
     */
    get creationSourceServerId(): string;
    /**
     * @stability stable
     */
    set creationSourceServerId(value: string);
    /**
     * @stability stable
     */
    resetCreationSourceServerId(): void;
    /**
     * @stability stable
     */
    get creationSourceServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGeoRedundantBackupEnabled(): void;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _restorePointInTime?;
    /**
     * @stability stable
     */
    get restorePointInTime(): string;
    /**
     * @stability stable
     */
    set restorePointInTime(value: string);
    /**
     * @stability stable
     */
    resetRestorePointInTime(): void;
    /**
     * @stability stable
     */
    get restorePointInTimeInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _sslEnforcement?;
    /**
     * @stability stable
     */
    get sslEnforcement(): string;
    /**
     * @stability stable
     */
    set sslEnforcement(value: string);
    /**
     * @stability stable
     */
    resetSslEnforcement(): void;
    /**
     * @stability stable
     */
    get sslEnforcementInput(): string | undefined;
    private _sslEnforcementEnabled?;
    /**
     * @stability stable
     */
    get sslEnforcementEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sslEnforcementEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSslEnforcementEnabled(): void;
    /**
     * @stability stable
     */
    get sslEnforcementEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageMb?;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    set storageMb(value: number);
    /**
     * @stability stable
     */
    resetStorageMb(): void;
    /**
     * @stability stable
     */
    get storageMbInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _storageProfile;
    /**
     * @stability stable
     */
    get storageProfile(): MariadbServerStorageProfileOutputReference;
    /**
     * @stability stable
     */
    putStorageProfile(value: MariadbServerStorageProfile): void;
    /**
     * @stability stable
     */
    resetStorageProfile(): void;
    /**
     * @stability stable
     */
    get storageProfileInput(): MariadbServerStorageProfile | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MariadbServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MariadbServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MariadbServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
