import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaAssetFilterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#asset_id MediaAssetFilter#asset_id}.
     *
     * @stability stable
     */
    readonly assetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#first_quality_bitrate MediaAssetFilter#first_quality_bitrate}.
     *
     * @stability stable
     */
    readonly firstQualityBitrate?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#name MediaAssetFilter#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * presentation_time_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#presentation_time_range MediaAssetFilter#presentation_time_range}
     *
     * @stability stable
     */
    readonly presentationTimeRange?: MediaAssetFilterPresentationTimeRange;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#timeouts MediaAssetFilter#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaAssetFilterTimeouts;
    /**
     * track_selection block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#track_selection MediaAssetFilter#track_selection}
     *
     * @stability stable
     */
    readonly trackSelection?: MediaAssetFilterTrackSelection[];
}
/**
 * @stability stable
 */
export interface MediaAssetFilterPresentationTimeRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#end_in_units MediaAssetFilter#end_in_units}.
     *
     * @stability stable
     */
    readonly endInUnits?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#force_end MediaAssetFilter#force_end}.
     *
     * @stability stable
     */
    readonly forceEnd?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#live_backoff_in_units MediaAssetFilter#live_backoff_in_units}.
     *
     * @stability stable
     */
    readonly liveBackoffInUnits?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#presentation_window_in_units MediaAssetFilter#presentation_window_in_units}.
     *
     * @stability stable
     */
    readonly presentationWindowInUnits?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#start_in_units MediaAssetFilter#start_in_units}.
     *
     * @stability stable
     */
    readonly startInUnits?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#unit_timescale_in_miliseconds MediaAssetFilter#unit_timescale_in_miliseconds}.
     *
     * @stability stable
     */
    readonly unitTimescaleInMiliseconds?: number;
}
export declare function mediaAssetFilterPresentationTimeRangeToTerraform(struct?: MediaAssetFilterPresentationTimeRangeOutputReference | MediaAssetFilterPresentationTimeRange): any;
/**
 * @stability stable
 */
export declare class MediaAssetFilterPresentationTimeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaAssetFilterPresentationTimeRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaAssetFilterPresentationTimeRange | undefined);
    private _endInUnits?;
    /**
     * @stability stable
     */
    get endInUnits(): number;
    /**
     * @stability stable
     */
    set endInUnits(value: number);
    /**
     * @stability stable
     */
    resetEndInUnits(): void;
    /**
     * @stability stable
     */
    get endInUnitsInput(): number | undefined;
    private _forceEnd?;
    /**
     * @stability stable
     */
    get forceEnd(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceEnd(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceEnd(): void;
    /**
     * @stability stable
     */
    get forceEndInput(): boolean | cdktf.IResolvable | undefined;
    private _liveBackoffInUnits?;
    /**
     * @stability stable
     */
    get liveBackoffInUnits(): number;
    /**
     * @stability stable
     */
    set liveBackoffInUnits(value: number);
    /**
     * @stability stable
     */
    resetLiveBackoffInUnits(): void;
    /**
     * @stability stable
     */
    get liveBackoffInUnitsInput(): number | undefined;
    private _presentationWindowInUnits?;
    /**
     * @stability stable
     */
    get presentationWindowInUnits(): number;
    /**
     * @stability stable
     */
    set presentationWindowInUnits(value: number);
    /**
     * @stability stable
     */
    resetPresentationWindowInUnits(): void;
    /**
     * @stability stable
     */
    get presentationWindowInUnitsInput(): number | undefined;
    private _startInUnits?;
    /**
     * @stability stable
     */
    get startInUnits(): number;
    /**
     * @stability stable
     */
    set startInUnits(value: number);
    /**
     * @stability stable
     */
    resetStartInUnits(): void;
    /**
     * @stability stable
     */
    get startInUnitsInput(): number | undefined;
    private _unitTimescaleInMiliseconds?;
    /**
     * @stability stable
     */
    get unitTimescaleInMiliseconds(): number;
    /**
     * @stability stable
     */
    set unitTimescaleInMiliseconds(value: number);
    /**
     * @stability stable
     */
    resetUnitTimescaleInMiliseconds(): void;
    /**
     * @stability stable
     */
    get unitTimescaleInMilisecondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MediaAssetFilterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#create MediaAssetFilter#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#delete MediaAssetFilter#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#read MediaAssetFilter#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#update MediaAssetFilter#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaAssetFilterTimeoutsToTerraform(struct?: MediaAssetFilterTimeoutsOutputReference | MediaAssetFilterTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaAssetFilterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaAssetFilterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaAssetFilterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaAssetFilterTrackSelectionCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#operation MediaAssetFilter#operation}.
     *
     * @stability stable
     */
    readonly operation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#property MediaAssetFilter#property}.
     *
     * @stability stable
     */
    readonly property?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#value MediaAssetFilter#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function mediaAssetFilterTrackSelectionConditionToTerraform(struct?: MediaAssetFilterTrackSelectionCondition): any;
/**
 * @stability stable
 */
export interface MediaAssetFilterTrackSelection {
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter#condition MediaAssetFilter#condition}
     *
     * @stability stable
     */
    readonly condition: MediaAssetFilterTrackSelectionCondition[];
}
export declare function mediaAssetFilterTrackSelectionToTerraform(struct?: MediaAssetFilterTrackSelection): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter azurerm_media_asset_filter}.
 *
 * @stability stable
 */
export declare class MediaAssetFilter extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset_filter azurerm_media_asset_filter} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaAssetFilterConfig);
    private _assetId?;
    /**
     * @stability stable
     */
    get assetId(): string;
    /**
     * @stability stable
     */
    set assetId(value: string);
    /**
     * @stability stable
     */
    get assetIdInput(): string | undefined;
    private _firstQualityBitrate?;
    /**
     * @stability stable
     */
    get firstQualityBitrate(): number;
    /**
     * @stability stable
     */
    set firstQualityBitrate(value: number);
    /**
     * @stability stable
     */
    resetFirstQualityBitrate(): void;
    /**
     * @stability stable
     */
    get firstQualityBitrateInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _presentationTimeRange;
    /**
     * @stability stable
     */
    get presentationTimeRange(): MediaAssetFilterPresentationTimeRangeOutputReference;
    /**
     * @stability stable
     */
    putPresentationTimeRange(value: MediaAssetFilterPresentationTimeRange): void;
    /**
     * @stability stable
     */
    resetPresentationTimeRange(): void;
    /**
     * @stability stable
     */
    get presentationTimeRangeInput(): MediaAssetFilterPresentationTimeRange | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaAssetFilterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaAssetFilterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaAssetFilterTimeouts | undefined;
    private _trackSelection?;
    /**
     * @stability stable
     */
    get trackSelection(): MediaAssetFilterTrackSelection[];
    /**
     * @stability stable
     */
    set trackSelection(value: MediaAssetFilterTrackSelection[]);
    /**
     * @stability stable
     */
    resetTrackSelection(): void;
    /**
     * @stability stable
     */
    get trackSelectionInput(): MediaAssetFilterTrackSelection[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
