import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#description MediaContentKeyPolicy#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#media_services_account_name MediaContentKeyPolicy#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#name MediaContentKeyPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#resource_group_name MediaContentKeyPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * policy_option block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#policy_option MediaContentKeyPolicy#policy_option}
     *
     * @stability stable
     */
    readonly policyOption: MediaContentKeyPolicyPolicyOption[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#timeouts MediaContentKeyPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaContentKeyPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#playback_duration_seconds MediaContentKeyPolicy#playback_duration_seconds}.
     *
     * @stability stable
     */
    readonly playbackDurationSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#storage_duration_seconds MediaContentKeyPolicy#storage_duration_seconds}.
     *
     * @stability stable
     */
    readonly storageDurationSeconds?: number;
}
export declare function mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct?: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference | MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration): any;
/**
 * @stability stable
 */
export declare class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration | undefined);
    private _playbackDurationSeconds?;
    /**
     * @stability stable
     */
    get playbackDurationSeconds(): number;
    /**
     * @stability stable
     */
    set playbackDurationSeconds(value: number);
    /**
     * @stability stable
     */
    resetPlaybackDurationSeconds(): void;
    /**
     * @stability stable
     */
    get playbackDurationSecondsInput(): number | undefined;
    private _storageDurationSeconds?;
    /**
     * @stability stable
     */
    get storageDurationSeconds(): number;
    /**
     * @stability stable
     */
    set storageDurationSeconds(value: number);
    /**
     * @stability stable
     */
    resetStorageDurationSeconds(): void;
    /**
     * @stability stable
     */
    get storageDurationSecondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyPolicyOptionFairplayConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#ask MediaContentKeyPolicy#ask}.
     *
     * @stability stable
     */
    readonly ask?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#pfx MediaContentKeyPolicy#pfx}.
     *
     * @stability stable
     */
    readonly pfx?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#pfx_password MediaContentKeyPolicy#pfx_password}.
     *
     * @stability stable
     */
    readonly pfxPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#rental_and_lease_key_type MediaContentKeyPolicy#rental_and_lease_key_type}.
     *
     * @stability stable
     */
    readonly rentalAndLeaseKeyType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#rental_duration_seconds MediaContentKeyPolicy#rental_duration_seconds}.
     *
     * @stability stable
     */
    readonly rentalDurationSeconds?: number;
    /**
     * offline_rental_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#offline_rental_configuration MediaContentKeyPolicy#offline_rental_configuration}
     *
     * @stability stable
     */
    readonly offlineRentalConfiguration?: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration;
}
export declare function mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct?: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference | MediaContentKeyPolicyPolicyOptionFairplayConfiguration): any;
/**
 * @stability stable
 */
export declare class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaContentKeyPolicyPolicyOptionFairplayConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaContentKeyPolicyPolicyOptionFairplayConfiguration | undefined);
    private _ask?;
    /**
     * @stability stable
     */
    get ask(): string;
    /**
     * @stability stable
     */
    set ask(value: string);
    /**
     * @stability stable
     */
    resetAsk(): void;
    /**
     * @stability stable
     */
    get askInput(): string | undefined;
    private _pfx?;
    /**
     * @stability stable
     */
    get pfx(): string;
    /**
     * @stability stable
     */
    set pfx(value: string);
    /**
     * @stability stable
     */
    resetPfx(): void;
    /**
     * @stability stable
     */
    get pfxInput(): string | undefined;
    private _pfxPassword?;
    /**
     * @stability stable
     */
    get pfxPassword(): string;
    /**
     * @stability stable
     */
    set pfxPassword(value: string);
    /**
     * @stability stable
     */
    resetPfxPassword(): void;
    /**
     * @stability stable
     */
    get pfxPasswordInput(): string | undefined;
    private _rentalAndLeaseKeyType?;
    /**
     * @stability stable
     */
    get rentalAndLeaseKeyType(): string;
    /**
     * @stability stable
     */
    set rentalAndLeaseKeyType(value: string);
    /**
     * @stability stable
     */
    resetRentalAndLeaseKeyType(): void;
    /**
     * @stability stable
     */
    get rentalAndLeaseKeyTypeInput(): string | undefined;
    private _rentalDurationSeconds?;
    /**
     * @stability stable
     */
    get rentalDurationSeconds(): number;
    /**
     * @stability stable
     */
    set rentalDurationSeconds(value: number);
    /**
     * @stability stable
     */
    resetRentalDurationSeconds(): void;
    /**
     * @stability stable
     */
    get rentalDurationSecondsInput(): number | undefined;
    private _offlineRentalConfiguration;
    /**
     * @stability stable
     */
    get offlineRentalConfiguration(): MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference;
    /**
     * @stability stable
     */
    putOfflineRentalConfiguration(value: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration): void;
    /**
     * @stability stable
     */
    resetOfflineRentalConfiguration(): void;
    /**
     * @stability stable
     */
    get offlineRentalConfigurationInput(): MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration | undefined;
}
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#agc_and_color_stripe_restriction MediaContentKeyPolicy#agc_and_color_stripe_restriction}.
     *
     * @stability stable
     */
    readonly agcAndColorStripeRestriction?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#allow_passing_video_content_to_unknown_output MediaContentKeyPolicy#allow_passing_video_content_to_unknown_output}.
     *
     * @stability stable
     */
    readonly allowPassingVideoContentToUnknownOutput?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#analog_video_opl MediaContentKeyPolicy#analog_video_opl}.
     *
     * @stability stable
     */
    readonly analogVideoOpl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#compressed_digital_audio_opl MediaContentKeyPolicy#compressed_digital_audio_opl}.
     *
     * @stability stable
     */
    readonly compressedDigitalAudioOpl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#digital_video_only_content_restriction MediaContentKeyPolicy#digital_video_only_content_restriction}.
     *
     * @stability stable
     */
    readonly digitalVideoOnlyContentRestriction?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#first_play_expiration MediaContentKeyPolicy#first_play_expiration}.
     *
     * @stability stable
     */
    readonly firstPlayExpiration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#image_constraint_for_analog_component_video_restriction MediaContentKeyPolicy#image_constraint_for_analog_component_video_restriction}.
     *
     * @stability stable
     */
    readonly imageConstraintForAnalogComponentVideoRestriction?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#image_constraint_for_analog_computer_monitor_restriction MediaContentKeyPolicy#image_constraint_for_analog_computer_monitor_restriction}.
     *
     * @stability stable
     */
    readonly imageConstraintForAnalogComputerMonitorRestriction?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#scms_restriction MediaContentKeyPolicy#scms_restriction}.
     *
     * @stability stable
     */
    readonly scmsRestriction?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#uncompressed_digital_audio_opl MediaContentKeyPolicy#uncompressed_digital_audio_opl}.
     *
     * @stability stable
     */
    readonly uncompressedDigitalAudioOpl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#uncompressed_digital_video_opl MediaContentKeyPolicy#uncompressed_digital_video_opl}.
     *
     * @stability stable
     */
    readonly uncompressedDigitalVideoOpl?: number;
}
export declare function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference | MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight): any;
/**
 * @stability stable
 */
export declare class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight | undefined);
    private _agcAndColorStripeRestriction?;
    /**
     * @stability stable
     */
    get agcAndColorStripeRestriction(): number;
    /**
     * @stability stable
     */
    set agcAndColorStripeRestriction(value: number);
    /**
     * @stability stable
     */
    resetAgcAndColorStripeRestriction(): void;
    /**
     * @stability stable
     */
    get agcAndColorStripeRestrictionInput(): number | undefined;
    private _allowPassingVideoContentToUnknownOutput?;
    /**
     * @stability stable
     */
    get allowPassingVideoContentToUnknownOutput(): string;
    /**
     * @stability stable
     */
    set allowPassingVideoContentToUnknownOutput(value: string);
    /**
     * @stability stable
     */
    resetAllowPassingVideoContentToUnknownOutput(): void;
    /**
     * @stability stable
     */
    get allowPassingVideoContentToUnknownOutputInput(): string | undefined;
    private _analogVideoOpl?;
    /**
     * @stability stable
     */
    get analogVideoOpl(): number;
    /**
     * @stability stable
     */
    set analogVideoOpl(value: number);
    /**
     * @stability stable
     */
    resetAnalogVideoOpl(): void;
    /**
     * @stability stable
     */
    get analogVideoOplInput(): number | undefined;
    private _compressedDigitalAudioOpl?;
    /**
     * @stability stable
     */
    get compressedDigitalAudioOpl(): number;
    /**
     * @stability stable
     */
    set compressedDigitalAudioOpl(value: number);
    /**
     * @stability stable
     */
    resetCompressedDigitalAudioOpl(): void;
    /**
     * @stability stable
     */
    get compressedDigitalAudioOplInput(): number | undefined;
    private _digitalVideoOnlyContentRestriction?;
    /**
     * @stability stable
     */
    get digitalVideoOnlyContentRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set digitalVideoOnlyContentRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDigitalVideoOnlyContentRestriction(): void;
    /**
     * @stability stable
     */
    get digitalVideoOnlyContentRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _firstPlayExpiration?;
    /**
     * @stability stable
     */
    get firstPlayExpiration(): string;
    /**
     * @stability stable
     */
    set firstPlayExpiration(value: string);
    /**
     * @stability stable
     */
    resetFirstPlayExpiration(): void;
    /**
     * @stability stable
     */
    get firstPlayExpirationInput(): string | undefined;
    private _imageConstraintForAnalogComponentVideoRestriction?;
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComponentVideoRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set imageConstraintForAnalogComponentVideoRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetImageConstraintForAnalogComponentVideoRestriction(): void;
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComponentVideoRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _imageConstraintForAnalogComputerMonitorRestriction?;
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComputerMonitorRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set imageConstraintForAnalogComputerMonitorRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetImageConstraintForAnalogComputerMonitorRestriction(): void;
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComputerMonitorRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _scmsRestriction?;
    /**
     * @stability stable
     */
    get scmsRestriction(): number;
    /**
     * @stability stable
     */
    set scmsRestriction(value: number);
    /**
     * @stability stable
     */
    resetScmsRestriction(): void;
    /**
     * @stability stable
     */
    get scmsRestrictionInput(): number | undefined;
    private _uncompressedDigitalAudioOpl?;
    /**
     * @stability stable
     */
    get uncompressedDigitalAudioOpl(): number;
    /**
     * @stability stable
     */
    set uncompressedDigitalAudioOpl(value: number);
    /**
     * @stability stable
     */
    resetUncompressedDigitalAudioOpl(): void;
    /**
     * @stability stable
     */
    get uncompressedDigitalAudioOplInput(): number | undefined;
    private _uncompressedDigitalVideoOpl?;
    /**
     * @stability stable
     */
    get uncompressedDigitalVideoOpl(): number;
    /**
     * @stability stable
     */
    set uncompressedDigitalVideoOpl(value: number);
    /**
     * @stability stable
     */
    resetUncompressedDigitalVideoOpl(): void;
    /**
     * @stability stable
     */
    get uncompressedDigitalVideoOplInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#allow_test_devices MediaContentKeyPolicy#allow_test_devices}.
     *
     * @stability stable
     */
    readonly allowTestDevices?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#begin_date MediaContentKeyPolicy#begin_date}.
     *
     * @stability stable
     */
    readonly beginDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#content_key_location_from_header_enabled MediaContentKeyPolicy#content_key_location_from_header_enabled}.
     *
     * @stability stable
     */
    readonly contentKeyLocationFromHeaderEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#content_key_location_from_key_id MediaContentKeyPolicy#content_key_location_from_key_id}.
     *
     * @stability stable
     */
    readonly contentKeyLocationFromKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#content_type MediaContentKeyPolicy#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#expiration_date MediaContentKeyPolicy#expiration_date}.
     *
     * @stability stable
     */
    readonly expirationDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#grace_period MediaContentKeyPolicy#grace_period}.
     *
     * @stability stable
     */
    readonly gracePeriod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#license_type MediaContentKeyPolicy#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#relative_begin_date MediaContentKeyPolicy#relative_begin_date}.
     *
     * @stability stable
     */
    readonly relativeBeginDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#relative_expiration_date MediaContentKeyPolicy#relative_expiration_date}.
     *
     * @stability stable
     */
    readonly relativeExpirationDate?: string;
    /**
     * play_right block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#play_right MediaContentKeyPolicy#play_right}
     *
     * @stability stable
     */
    readonly playRight?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight;
}
export declare function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform(struct?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense): any;
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#type MediaContentKeyPolicy#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#value MediaContentKeyPolicy#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform(struct?: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim): any;
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyPolicyOptionTokenRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#audience MediaContentKeyPolicy#audience}.
     *
     * @stability stable
     */
    readonly audience?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#issuer MediaContentKeyPolicy#issuer}.
     *
     * @stability stable
     */
    readonly issuer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#open_id_connect_discovery_document MediaContentKeyPolicy#open_id_connect_discovery_document}.
     *
     * @stability stable
     */
    readonly openIdConnectDiscoveryDocument?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_rsa_token_key_exponent MediaContentKeyPolicy#primary_rsa_token_key_exponent}.
     *
     * @stability stable
     */
    readonly primaryRsaTokenKeyExponent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_rsa_token_key_modulus MediaContentKeyPolicy#primary_rsa_token_key_modulus}.
     *
     * @stability stable
     */
    readonly primaryRsaTokenKeyModulus?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_symmetric_token_key MediaContentKeyPolicy#primary_symmetric_token_key}.
     *
     * @stability stable
     */
    readonly primarySymmetricTokenKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_x509_token_key_raw MediaContentKeyPolicy#primary_x509_token_key_raw}.
     *
     * @stability stable
     */
    readonly primaryX509TokenKeyRaw?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#token_type MediaContentKeyPolicy#token_type}.
     *
     * @stability stable
     */
    readonly tokenType?: string;
    /**
     * required_claim block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#required_claim MediaContentKeyPolicy#required_claim}
     *
     * @stability stable
     */
    readonly requiredClaim?: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[];
}
export declare function mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct?: MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference | MediaContentKeyPolicyPolicyOptionTokenRestriction): any;
/**
 * @stability stable
 */
export declare class MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaContentKeyPolicyPolicyOptionTokenRestriction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaContentKeyPolicyPolicyOptionTokenRestriction | undefined);
    private _audience?;
    /**
     * @stability stable
     */
    get audience(): string;
    /**
     * @stability stable
     */
    set audience(value: string);
    /**
     * @stability stable
     */
    resetAudience(): void;
    /**
     * @stability stable
     */
    get audienceInput(): string | undefined;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    resetIssuer(): void;
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _openIdConnectDiscoveryDocument?;
    /**
     * @stability stable
     */
    get openIdConnectDiscoveryDocument(): string;
    /**
     * @stability stable
     */
    set openIdConnectDiscoveryDocument(value: string);
    /**
     * @stability stable
     */
    resetOpenIdConnectDiscoveryDocument(): void;
    /**
     * @stability stable
     */
    get openIdConnectDiscoveryDocumentInput(): string | undefined;
    private _primaryRsaTokenKeyExponent?;
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyExponent(): string;
    /**
     * @stability stable
     */
    set primaryRsaTokenKeyExponent(value: string);
    /**
     * @stability stable
     */
    resetPrimaryRsaTokenKeyExponent(): void;
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyExponentInput(): string | undefined;
    private _primaryRsaTokenKeyModulus?;
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyModulus(): string;
    /**
     * @stability stable
     */
    set primaryRsaTokenKeyModulus(value: string);
    /**
     * @stability stable
     */
    resetPrimaryRsaTokenKeyModulus(): void;
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyModulusInput(): string | undefined;
    private _primarySymmetricTokenKey?;
    /**
     * @stability stable
     */
    get primarySymmetricTokenKey(): string;
    /**
     * @stability stable
     */
    set primarySymmetricTokenKey(value: string);
    /**
     * @stability stable
     */
    resetPrimarySymmetricTokenKey(): void;
    /**
     * @stability stable
     */
    get primarySymmetricTokenKeyInput(): string | undefined;
    private _primaryX509TokenKeyRaw?;
    /**
     * @stability stable
     */
    get primaryX509TokenKeyRaw(): string;
    /**
     * @stability stable
     */
    set primaryX509TokenKeyRaw(value: string);
    /**
     * @stability stable
     */
    resetPrimaryX509TokenKeyRaw(): void;
    /**
     * @stability stable
     */
    get primaryX509TokenKeyRawInput(): string | undefined;
    private _tokenType?;
    /**
     * @stability stable
     */
    get tokenType(): string;
    /**
     * @stability stable
     */
    set tokenType(value: string);
    /**
     * @stability stable
     */
    resetTokenType(): void;
    /**
     * @stability stable
     */
    get tokenTypeInput(): string | undefined;
    private _requiredClaim?;
    /**
     * @stability stable
     */
    get requiredClaim(): MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[];
    /**
     * @stability stable
     */
    set requiredClaim(value: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[]);
    /**
     * @stability stable
     */
    resetRequiredClaim(): void;
    /**
     * @stability stable
     */
    get requiredClaimInput(): MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[] | undefined;
}
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyPolicyOption {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#clear_key_configuration_enabled MediaContentKeyPolicy#clear_key_configuration_enabled}.
     *
     * @stability stable
     */
    readonly clearKeyConfigurationEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#name MediaContentKeyPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#open_restriction_enabled MediaContentKeyPolicy#open_restriction_enabled}.
     *
     * @stability stable
     */
    readonly openRestrictionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#widevine_configuration_template MediaContentKeyPolicy#widevine_configuration_template}.
     *
     * @stability stable
     */
    readonly widevineConfigurationTemplate?: string;
    /**
     * fairplay_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#fairplay_configuration MediaContentKeyPolicy#fairplay_configuration}
     *
     * @stability stable
     */
    readonly fairplayConfiguration?: MediaContentKeyPolicyPolicyOptionFairplayConfiguration;
    /**
     * playready_configuration_license block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#playready_configuration_license MediaContentKeyPolicy#playready_configuration_license}
     *
     * @stability stable
     */
    readonly playreadyConfigurationLicense?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense[];
    /**
     * token_restriction block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#token_restriction MediaContentKeyPolicy#token_restriction}
     *
     * @stability stable
     */
    readonly tokenRestriction?: MediaContentKeyPolicyPolicyOptionTokenRestriction;
}
export declare function mediaContentKeyPolicyPolicyOptionToTerraform(struct?: MediaContentKeyPolicyPolicyOption): any;
/**
 * @stability stable
 */
export interface MediaContentKeyPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#create MediaContentKeyPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#delete MediaContentKeyPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#read MediaContentKeyPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#update MediaContentKeyPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaContentKeyPolicyTimeoutsToTerraform(struct?: MediaContentKeyPolicyTimeoutsOutputReference | MediaContentKeyPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaContentKeyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaContentKeyPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaContentKeyPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy}.
 *
 * @stability stable
 */
export declare class MediaContentKeyPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaContentKeyPolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _policyOption?;
    /**
     * @stability stable
     */
    get policyOption(): MediaContentKeyPolicyPolicyOption[];
    /**
     * @stability stable
     */
    set policyOption(value: MediaContentKeyPolicyPolicyOption[]);
    /**
     * @stability stable
     */
    get policyOptionInput(): MediaContentKeyPolicyPolicyOption[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaContentKeyPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaContentKeyPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaContentKeyPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
