"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaContentKeyPolicy = exports.MediaContentKeyPolicyTimeoutsOutputReference = exports.mediaContentKeyPolicyTimeoutsToTerraform = exports.mediaContentKeyPolicyPolicyOptionToTerraform = exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        playback_duration_seconds: cdktf.numberToTerraform(struct.playbackDurationSeconds),
        storage_duration_seconds: cdktf.numberToTerraform(struct.storageDurationSeconds),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._playbackDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.playbackDurationSeconds = this._playbackDurationSeconds;
        }
        if (this._storageDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageDurationSeconds = this._storageDurationSeconds;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._playbackDurationSeconds = undefined;
            this._storageDurationSeconds = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._playbackDurationSeconds = value.playbackDurationSeconds;
            this._storageDurationSeconds = value.storageDurationSeconds;
        }
    }
    /**
     * @stability stable
     */
    get playbackDurationSeconds() {
        return this.getNumberAttribute('playback_duration_seconds');
    }
    /**
     * @stability stable
     */
    set playbackDurationSeconds(value) {
        this._playbackDurationSeconds = value;
    }
    /**
     * @stability stable
     */
    resetPlaybackDurationSeconds() {
        this._playbackDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get playbackDurationSecondsInput() {
        return this._playbackDurationSeconds;
    }
    /**
     * @stability stable
     */
    get storageDurationSeconds() {
        return this.getNumberAttribute('storage_duration_seconds');
    }
    /**
     * @stability stable
     */
    set storageDurationSeconds(value) {
        this._storageDurationSeconds = value;
    }
    /**
     * @stability stable
     */
    resetStorageDurationSeconds() {
        this._storageDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageDurationSecondsInput() {
        return this._storageDurationSeconds;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference", version: "0.4.143" };
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ask: cdktf.stringToTerraform(struct.ask),
        pfx: cdktf.stringToTerraform(struct.pfx),
        pfx_password: cdktf.stringToTerraform(struct.pfxPassword),
        rental_and_lease_key_type: cdktf.stringToTerraform(struct.rentalAndLeaseKeyType),
        rental_duration_seconds: cdktf.numberToTerraform(struct.rentalDurationSeconds),
        offline_rental_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct.offlineRentalConfiguration),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // offline_rental_configuration - computed: false, optional: true, required: false
        this._offlineRentalConfiguration = new MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference(this, "offline_rental_configuration", true);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        var _g, _h;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._ask !== undefined) {
            hasAnyValues = true;
            internalValueResult.ask = this._ask;
        }
        if (this._pfx !== undefined) {
            hasAnyValues = true;
            internalValueResult.pfx = this._pfx;
        }
        if (this._pfxPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.pfxPassword = this._pfxPassword;
        }
        if (this._rentalAndLeaseKeyType !== undefined) {
            hasAnyValues = true;
            internalValueResult.rentalAndLeaseKeyType = this._rentalAndLeaseKeyType;
        }
        if (this._rentalDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.rentalDurationSeconds = this._rentalDurationSeconds;
        }
        if (((_g = this._offlineRentalConfiguration) === null || _g === void 0 ? void 0 : _g.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.offlineRentalConfiguration = (_h = this._offlineRentalConfiguration) === null || _h === void 0 ? void 0 : _h.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._ask = undefined;
            this._pfx = undefined;
            this._pfxPassword = undefined;
            this._rentalAndLeaseKeyType = undefined;
            this._rentalDurationSeconds = undefined;
            this._offlineRentalConfiguration.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._ask = value.ask;
            this._pfx = value.pfx;
            this._pfxPassword = value.pfxPassword;
            this._rentalAndLeaseKeyType = value.rentalAndLeaseKeyType;
            this._rentalDurationSeconds = value.rentalDurationSeconds;
            this._offlineRentalConfiguration.internalValue = value.offlineRentalConfiguration;
        }
    }
    /**
     * @stability stable
     */
    get ask() {
        return this.getStringAttribute('ask');
    }
    /**
     * @stability stable
     */
    set ask(value) {
        this._ask = value;
    }
    /**
     * @stability stable
     */
    resetAsk() {
        this._ask = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get askInput() {
        return this._ask;
    }
    /**
     * @stability stable
     */
    get pfx() {
        return this.getStringAttribute('pfx');
    }
    /**
     * @stability stable
     */
    set pfx(value) {
        this._pfx = value;
    }
    /**
     * @stability stable
     */
    resetPfx() {
        this._pfx = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pfxInput() {
        return this._pfx;
    }
    /**
     * @stability stable
     */
    get pfxPassword() {
        return this.getStringAttribute('pfx_password');
    }
    /**
     * @stability stable
     */
    set pfxPassword(value) {
        this._pfxPassword = value;
    }
    /**
     * @stability stable
     */
    resetPfxPassword() {
        this._pfxPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pfxPasswordInput() {
        return this._pfxPassword;
    }
    /**
     * @stability stable
     */
    get rentalAndLeaseKeyType() {
        return this.getStringAttribute('rental_and_lease_key_type');
    }
    /**
     * @stability stable
     */
    set rentalAndLeaseKeyType(value) {
        this._rentalAndLeaseKeyType = value;
    }
    /**
     * @stability stable
     */
    resetRentalAndLeaseKeyType() {
        this._rentalAndLeaseKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get rentalAndLeaseKeyTypeInput() {
        return this._rentalAndLeaseKeyType;
    }
    /**
     * @stability stable
     */
    get rentalDurationSeconds() {
        return this.getNumberAttribute('rental_duration_seconds');
    }
    /**
     * @stability stable
     */
    set rentalDurationSeconds(value) {
        this._rentalDurationSeconds = value;
    }
    /**
     * @stability stable
     */
    resetRentalDurationSeconds() {
        this._rentalDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get rentalDurationSecondsInput() {
        return this._rentalDurationSeconds;
    }
    /**
     * @stability stable
     */
    get offlineRentalConfiguration() {
        return this._offlineRentalConfiguration;
    }
    /**
     * @stability stable
     */
    putOfflineRentalConfiguration(value) {
        this._offlineRentalConfiguration.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetOfflineRentalConfiguration() {
        this._offlineRentalConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get offlineRentalConfigurationInput() {
        return this._offlineRentalConfiguration.internalValue;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference", version: "0.4.143" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        agc_and_color_stripe_restriction: cdktf.numberToTerraform(struct.agcAndColorStripeRestriction),
        allow_passing_video_content_to_unknown_output: cdktf.stringToTerraform(struct.allowPassingVideoContentToUnknownOutput),
        analog_video_opl: cdktf.numberToTerraform(struct.analogVideoOpl),
        compressed_digital_audio_opl: cdktf.numberToTerraform(struct.compressedDigitalAudioOpl),
        digital_video_only_content_restriction: cdktf.booleanToTerraform(struct.digitalVideoOnlyContentRestriction),
        first_play_expiration: cdktf.stringToTerraform(struct.firstPlayExpiration),
        image_constraint_for_analog_component_video_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComponentVideoRestriction),
        image_constraint_for_analog_computer_monitor_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComputerMonitorRestriction),
        scms_restriction: cdktf.numberToTerraform(struct.scmsRestriction),
        uncompressed_digital_audio_opl: cdktf.numberToTerraform(struct.uncompressedDigitalAudioOpl),
        uncompressed_digital_video_opl: cdktf.numberToTerraform(struct.uncompressedDigitalVideoOpl),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._agcAndColorStripeRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.agcAndColorStripeRestriction = this._agcAndColorStripeRestriction;
        }
        if (this._allowPassingVideoContentToUnknownOutput !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowPassingVideoContentToUnknownOutput = this._allowPassingVideoContentToUnknownOutput;
        }
        if (this._analogVideoOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.analogVideoOpl = this._analogVideoOpl;
        }
        if (this._compressedDigitalAudioOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.compressedDigitalAudioOpl = this._compressedDigitalAudioOpl;
        }
        if (this._digitalVideoOnlyContentRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.digitalVideoOnlyContentRestriction = this._digitalVideoOnlyContentRestriction;
        }
        if (this._firstPlayExpiration !== undefined) {
            hasAnyValues = true;
            internalValueResult.firstPlayExpiration = this._firstPlayExpiration;
        }
        if (this._imageConstraintForAnalogComponentVideoRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComponentVideoRestriction = this._imageConstraintForAnalogComponentVideoRestriction;
        }
        if (this._imageConstraintForAnalogComputerMonitorRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComputerMonitorRestriction = this._imageConstraintForAnalogComputerMonitorRestriction;
        }
        if (this._scmsRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.scmsRestriction = this._scmsRestriction;
        }
        if (this._uncompressedDigitalAudioOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalAudioOpl = this._uncompressedDigitalAudioOpl;
        }
        if (this._uncompressedDigitalVideoOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalVideoOpl = this._uncompressedDigitalVideoOpl;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._agcAndColorStripeRestriction = undefined;
            this._allowPassingVideoContentToUnknownOutput = undefined;
            this._analogVideoOpl = undefined;
            this._compressedDigitalAudioOpl = undefined;
            this._digitalVideoOnlyContentRestriction = undefined;
            this._firstPlayExpiration = undefined;
            this._imageConstraintForAnalogComponentVideoRestriction = undefined;
            this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
            this._scmsRestriction = undefined;
            this._uncompressedDigitalAudioOpl = undefined;
            this._uncompressedDigitalVideoOpl = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._agcAndColorStripeRestriction = value.agcAndColorStripeRestriction;
            this._allowPassingVideoContentToUnknownOutput = value.allowPassingVideoContentToUnknownOutput;
            this._analogVideoOpl = value.analogVideoOpl;
            this._compressedDigitalAudioOpl = value.compressedDigitalAudioOpl;
            this._digitalVideoOnlyContentRestriction = value.digitalVideoOnlyContentRestriction;
            this._firstPlayExpiration = value.firstPlayExpiration;
            this._imageConstraintForAnalogComponentVideoRestriction = value.imageConstraintForAnalogComponentVideoRestriction;
            this._imageConstraintForAnalogComputerMonitorRestriction = value.imageConstraintForAnalogComputerMonitorRestriction;
            this._scmsRestriction = value.scmsRestriction;
            this._uncompressedDigitalAudioOpl = value.uncompressedDigitalAudioOpl;
            this._uncompressedDigitalVideoOpl = value.uncompressedDigitalVideoOpl;
        }
    }
    /**
     * @stability stable
     */
    get agcAndColorStripeRestriction() {
        return this.getNumberAttribute('agc_and_color_stripe_restriction');
    }
    /**
     * @stability stable
     */
    set agcAndColorStripeRestriction(value) {
        this._agcAndColorStripeRestriction = value;
    }
    /**
     * @stability stable
     */
    resetAgcAndColorStripeRestriction() {
        this._agcAndColorStripeRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get agcAndColorStripeRestrictionInput() {
        return this._agcAndColorStripeRestriction;
    }
    /**
     * @stability stable
     */
    get allowPassingVideoContentToUnknownOutput() {
        return this.getStringAttribute('allow_passing_video_content_to_unknown_output');
    }
    /**
     * @stability stable
     */
    set allowPassingVideoContentToUnknownOutput(value) {
        this._allowPassingVideoContentToUnknownOutput = value;
    }
    /**
     * @stability stable
     */
    resetAllowPassingVideoContentToUnknownOutput() {
        this._allowPassingVideoContentToUnknownOutput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get allowPassingVideoContentToUnknownOutputInput() {
        return this._allowPassingVideoContentToUnknownOutput;
    }
    /**
     * @stability stable
     */
    get analogVideoOpl() {
        return this.getNumberAttribute('analog_video_opl');
    }
    /**
     * @stability stable
     */
    set analogVideoOpl(value) {
        this._analogVideoOpl = value;
    }
    /**
     * @stability stable
     */
    resetAnalogVideoOpl() {
        this._analogVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get analogVideoOplInput() {
        return this._analogVideoOpl;
    }
    /**
     * @stability stable
     */
    get compressedDigitalAudioOpl() {
        return this.getNumberAttribute('compressed_digital_audio_opl');
    }
    /**
     * @stability stable
     */
    set compressedDigitalAudioOpl(value) {
        this._compressedDigitalAudioOpl = value;
    }
    /**
     * @stability stable
     */
    resetCompressedDigitalAudioOpl() {
        this._compressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get compressedDigitalAudioOplInput() {
        return this._compressedDigitalAudioOpl;
    }
    /**
     * @stability stable
     */
    get digitalVideoOnlyContentRestriction() {
        return this.getBooleanAttribute('digital_video_only_content_restriction');
    }
    /**
     * @stability stable
     */
    set digitalVideoOnlyContentRestriction(value) {
        this._digitalVideoOnlyContentRestriction = value;
    }
    /**
     * @stability stable
     */
    resetDigitalVideoOnlyContentRestriction() {
        this._digitalVideoOnlyContentRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get digitalVideoOnlyContentRestrictionInput() {
        return this._digitalVideoOnlyContentRestriction;
    }
    /**
     * @stability stable
     */
    get firstPlayExpiration() {
        return this.getStringAttribute('first_play_expiration');
    }
    /**
     * @stability stable
     */
    set firstPlayExpiration(value) {
        this._firstPlayExpiration = value;
    }
    /**
     * @stability stable
     */
    resetFirstPlayExpiration() {
        this._firstPlayExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get firstPlayExpirationInput() {
        return this._firstPlayExpiration;
    }
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComponentVideoRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_component_video_restriction');
    }
    /**
     * @stability stable
     */
    set imageConstraintForAnalogComponentVideoRestriction(value) {
        this._imageConstraintForAnalogComponentVideoRestriction = value;
    }
    /**
     * @stability stable
     */
    resetImageConstraintForAnalogComponentVideoRestriction() {
        this._imageConstraintForAnalogComponentVideoRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComponentVideoRestrictionInput() {
        return this._imageConstraintForAnalogComponentVideoRestriction;
    }
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComputerMonitorRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_computer_monitor_restriction');
    }
    /**
     * @stability stable
     */
    set imageConstraintForAnalogComputerMonitorRestriction(value) {
        this._imageConstraintForAnalogComputerMonitorRestriction = value;
    }
    /**
     * @stability stable
     */
    resetImageConstraintForAnalogComputerMonitorRestriction() {
        this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComputerMonitorRestrictionInput() {
        return this._imageConstraintForAnalogComputerMonitorRestriction;
    }
    /**
     * @stability stable
     */
    get scmsRestriction() {
        return this.getNumberAttribute('scms_restriction');
    }
    /**
     * @stability stable
     */
    set scmsRestriction(value) {
        this._scmsRestriction = value;
    }
    /**
     * @stability stable
     */
    resetScmsRestriction() {
        this._scmsRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get scmsRestrictionInput() {
        return this._scmsRestriction;
    }
    /**
     * @stability stable
     */
    get uncompressedDigitalAudioOpl() {
        return this.getNumberAttribute('uncompressed_digital_audio_opl');
    }
    /**
     * @stability stable
     */
    set uncompressedDigitalAudioOpl(value) {
        this._uncompressedDigitalAudioOpl = value;
    }
    /**
     * @stability stable
     */
    resetUncompressedDigitalAudioOpl() {
        this._uncompressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get uncompressedDigitalAudioOplInput() {
        return this._uncompressedDigitalAudioOpl;
    }
    /**
     * @stability stable
     */
    get uncompressedDigitalVideoOpl() {
        return this.getNumberAttribute('uncompressed_digital_video_opl');
    }
    /**
     * @stability stable
     */
    set uncompressedDigitalVideoOpl(value) {
        this._uncompressedDigitalVideoOpl = value;
    }
    /**
     * @stability stable
     */
    resetUncompressedDigitalVideoOpl() {
        this._uncompressedDigitalVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get uncompressedDigitalVideoOplInput() {
        return this._uncompressedDigitalVideoOpl;
    }
}
exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference", version: "0.4.143" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allow_test_devices: cdktf.booleanToTerraform(struct.allowTestDevices),
        begin_date: cdktf.stringToTerraform(struct.beginDate),
        content_key_location_from_header_enabled: cdktf.booleanToTerraform(struct.contentKeyLocationFromHeaderEnabled),
        content_key_location_from_key_id: cdktf.stringToTerraform(struct.contentKeyLocationFromKeyId),
        content_type: cdktf.stringToTerraform(struct.contentType),
        expiration_date: cdktf.stringToTerraform(struct.expirationDate),
        grace_period: cdktf.stringToTerraform(struct.gracePeriod),
        license_type: cdktf.stringToTerraform(struct.licenseType),
        relative_begin_date: cdktf.stringToTerraform(struct.relativeBeginDate),
        relative_expiration_date: cdktf.stringToTerraform(struct.relativeExpirationDate),
        play_right: mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct.playRight),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        type: cdktf.stringToTerraform(struct.type),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        audience: cdktf.stringToTerraform(struct.audience),
        issuer: cdktf.stringToTerraform(struct.issuer),
        open_id_connect_discovery_document: cdktf.stringToTerraform(struct.openIdConnectDiscoveryDocument),
        primary_rsa_token_key_exponent: cdktf.stringToTerraform(struct.primaryRsaTokenKeyExponent),
        primary_rsa_token_key_modulus: cdktf.stringToTerraform(struct.primaryRsaTokenKeyModulus),
        primary_symmetric_token_key: cdktf.stringToTerraform(struct.primarySymmetricTokenKey),
        primary_x509_token_key_raw: cdktf.stringToTerraform(struct.primaryX509TokenKeyRaw),
        token_type: cdktf.stringToTerraform(struct.tokenType),
        required_claim: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform)(struct.requiredClaim),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._audience !== undefined) {
            hasAnyValues = true;
            internalValueResult.audience = this._audience;
        }
        if (this._issuer !== undefined) {
            hasAnyValues = true;
            internalValueResult.issuer = this._issuer;
        }
        if (this._openIdConnectDiscoveryDocument !== undefined) {
            hasAnyValues = true;
            internalValueResult.openIdConnectDiscoveryDocument = this._openIdConnectDiscoveryDocument;
        }
        if (this._primaryRsaTokenKeyExponent !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyExponent = this._primaryRsaTokenKeyExponent;
        }
        if (this._primaryRsaTokenKeyModulus !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyModulus = this._primaryRsaTokenKeyModulus;
        }
        if (this._primarySymmetricTokenKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.primarySymmetricTokenKey = this._primarySymmetricTokenKey;
        }
        if (this._primaryX509TokenKeyRaw !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryX509TokenKeyRaw = this._primaryX509TokenKeyRaw;
        }
        if (this._tokenType !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        if (this._requiredClaim !== undefined) {
            hasAnyValues = true;
            internalValueResult.requiredClaim = this._requiredClaim;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._audience = undefined;
            this._issuer = undefined;
            this._openIdConnectDiscoveryDocument = undefined;
            this._primaryRsaTokenKeyExponent = undefined;
            this._primaryRsaTokenKeyModulus = undefined;
            this._primarySymmetricTokenKey = undefined;
            this._primaryX509TokenKeyRaw = undefined;
            this._tokenType = undefined;
            this._requiredClaim = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._audience = value.audience;
            this._issuer = value.issuer;
            this._openIdConnectDiscoveryDocument = value.openIdConnectDiscoveryDocument;
            this._primaryRsaTokenKeyExponent = value.primaryRsaTokenKeyExponent;
            this._primaryRsaTokenKeyModulus = value.primaryRsaTokenKeyModulus;
            this._primarySymmetricTokenKey = value.primarySymmetricTokenKey;
            this._primaryX509TokenKeyRaw = value.primaryX509TokenKeyRaw;
            this._tokenType = value.tokenType;
            this._requiredClaim = value.requiredClaim;
        }
    }
    /**
     * @stability stable
     */
    get audience() {
        return this.getStringAttribute('audience');
    }
    /**
     * @stability stable
     */
    set audience(value) {
        this._audience = value;
    }
    /**
     * @stability stable
     */
    resetAudience() {
        this._audience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get audienceInput() {
        return this._audience;
    }
    /**
     * @stability stable
     */
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    /**
     * @stability stable
     */
    set issuer(value) {
        this._issuer = value;
    }
    /**
     * @stability stable
     */
    resetIssuer() {
        this._issuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get issuerInput() {
        return this._issuer;
    }
    /**
     * @stability stable
     */
    get openIdConnectDiscoveryDocument() {
        return this.getStringAttribute('open_id_connect_discovery_document');
    }
    /**
     * @stability stable
     */
    set openIdConnectDiscoveryDocument(value) {
        this._openIdConnectDiscoveryDocument = value;
    }
    /**
     * @stability stable
     */
    resetOpenIdConnectDiscoveryDocument() {
        this._openIdConnectDiscoveryDocument = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get openIdConnectDiscoveryDocumentInput() {
        return this._openIdConnectDiscoveryDocument;
    }
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyExponent() {
        return this.getStringAttribute('primary_rsa_token_key_exponent');
    }
    /**
     * @stability stable
     */
    set primaryRsaTokenKeyExponent(value) {
        this._primaryRsaTokenKeyExponent = value;
    }
    /**
     * @stability stable
     */
    resetPrimaryRsaTokenKeyExponent() {
        this._primaryRsaTokenKeyExponent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyExponentInput() {
        return this._primaryRsaTokenKeyExponent;
    }
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyModulus() {
        return this.getStringAttribute('primary_rsa_token_key_modulus');
    }
    /**
     * @stability stable
     */
    set primaryRsaTokenKeyModulus(value) {
        this._primaryRsaTokenKeyModulus = value;
    }
    /**
     * @stability stable
     */
    resetPrimaryRsaTokenKeyModulus() {
        this._primaryRsaTokenKeyModulus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyModulusInput() {
        return this._primaryRsaTokenKeyModulus;
    }
    /**
     * @stability stable
     */
    get primarySymmetricTokenKey() {
        return this.getStringAttribute('primary_symmetric_token_key');
    }
    /**
     * @stability stable
     */
    set primarySymmetricTokenKey(value) {
        this._primarySymmetricTokenKey = value;
    }
    /**
     * @stability stable
     */
    resetPrimarySymmetricTokenKey() {
        this._primarySymmetricTokenKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primarySymmetricTokenKeyInput() {
        return this._primarySymmetricTokenKey;
    }
    /**
     * @stability stable
     */
    get primaryX509TokenKeyRaw() {
        return this.getStringAttribute('primary_x509_token_key_raw');
    }
    /**
     * @stability stable
     */
    set primaryX509TokenKeyRaw(value) {
        this._primaryX509TokenKeyRaw = value;
    }
    /**
     * @stability stable
     */
    resetPrimaryX509TokenKeyRaw() {
        this._primaryX509TokenKeyRaw = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primaryX509TokenKeyRawInput() {
        return this._primaryX509TokenKeyRaw;
    }
    /**
     * @stability stable
     */
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    /**
     * @stability stable
     */
    set tokenType(value) {
        this._tokenType = value;
    }
    /**
     * @stability stable
     */
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tokenTypeInput() {
        return this._tokenType;
    }
    /**
     * @stability stable
     */
    get requiredClaim() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('required_claim');
    }
    /**
     * @stability stable
     */
    set requiredClaim(value) {
        this._requiredClaim = value;
    }
    /**
     * @stability stable
     */
    resetRequiredClaim() {
        this._requiredClaim = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get requiredClaimInput() {
        return this._requiredClaim;
    }
}
exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference", version: "0.4.143" };
function mediaContentKeyPolicyPolicyOptionToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        clear_key_configuration_enabled: cdktf.booleanToTerraform(struct.clearKeyConfigurationEnabled),
        name: cdktf.stringToTerraform(struct.name),
        open_restriction_enabled: cdktf.booleanToTerraform(struct.openRestrictionEnabled),
        widevine_configuration_template: cdktf.stringToTerraform(struct.widevineConfigurationTemplate),
        fairplay_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct.fairplayConfiguration),
        playready_configuration_license: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform)(struct.playreadyConfigurationLicense),
        token_restriction: mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct.tokenRestriction),
    };
}
exports.mediaContentKeyPolicyPolicyOptionToTerraform = mediaContentKeyPolicyPolicyOptionToTerraform;
function mediaContentKeyPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mediaContentKeyPolicyTimeoutsToTerraform = mediaContentKeyPolicyTimeoutsToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    /**
     * @stability stable
     */
    get create() {
        return this.getStringAttribute('create');
    }
    /**
     * @stability stable
     */
    set create(value) {
        this._create = value;
    }
    /**
     * @stability stable
     */
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get createInput() {
        return this._create;
    }
    /**
     * @stability stable
     */
    get delete() {
        return this.getStringAttribute('delete');
    }
    /**
     * @stability stable
     */
    set delete(value) {
        this._delete = value;
    }
    /**
     * @stability stable
     */
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteInput() {
        return this._delete;
    }
    /**
     * @stability stable
     */
    get read() {
        return this.getStringAttribute('read');
    }
    /**
     * @stability stable
     */
    set read(value) {
        this._read = value;
    }
    /**
     * @stability stable
     */
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get readInput() {
        return this._read;
    }
    /**
     * @stability stable
     */
    get update() {
        return this.getStringAttribute('update');
    }
    /**
     * @stability stable
     */
    set update(value) {
        this._update = value;
    }
    /**
     * @stability stable
     */
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get updateInput() {
        return this._update;
    }
}
exports.MediaContentKeyPolicyTimeoutsOutputReference = MediaContentKeyPolicyTimeoutsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyTimeoutsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyTimeoutsOutputReference", version: "0.4.143" };
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy}.
 *
 * @stability stable
 */
class MediaContentKeyPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_media_content_key_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MediaContentKeyPolicyTimeoutsOutputReference(this, "timeouts", true);
        this._description = config.description;
        this._mediaServicesAccountName = config.mediaServicesAccountName;
        this._name = config.name;
        this._resourceGroupName = config.resourceGroupName;
        this._policyOption = config.policyOption;
        this._timeouts.internalValue = config.timeouts;
    }
    /**
     * @stability stable
     */
    get description() {
        return this.getStringAttribute('description');
    }
    /**
     * @stability stable
     */
    set description(value) {
        this._description = value;
    }
    /**
     * @stability stable
     */
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get mediaServicesAccountName() {
        return this.getStringAttribute('media_services_account_name');
    }
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value) {
        this._mediaServicesAccountName = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput() {
        return this._mediaServicesAccountName;
    }
    /**
     * @stability stable
     */
    get name() {
        return this.getStringAttribute('name');
    }
    /**
     * @stability stable
     */
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nameInput() {
        return this._name;
    }
    /**
     * @stability stable
     */
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    /**
     * @stability stable
     */
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    /**
     * @stability stable
     */
    get policyOption() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('policy_option');
    }
    /**
     * @stability stable
     */
    set policyOption(value) {
        this._policyOption = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get policyOptionInput() {
        return this._policyOption;
    }
    /**
     * @stability stable
     */
    get timeouts() {
        return this._timeouts;
    }
    /**
     * @stability stable
     */
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            description: cdktf.stringToTerraform(this._description),
            media_services_account_name: cdktf.stringToTerraform(this._mediaServicesAccountName),
            name: cdktf.stringToTerraform(this._name),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            policy_option: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionToTerraform)(this._policyOption),
            timeouts: mediaContentKeyPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MediaContentKeyPolicy = MediaContentKeyPolicy;
_f = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicy[_f] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicy", version: "0.4.143" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
MediaContentKeyPolicy.tfResourceType = "azurerm_media_content_key_policy";
//# sourceMappingURL=data:application/json;base64,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