import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaStreamingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#default_content_key_policy_name MediaStreamingPolicy#default_content_key_policy_name}.
     *
     * @stability stable
     */
    readonly defaultContentKeyPolicyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#media_services_account_name MediaStreamingPolicy#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#name MediaStreamingPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#resource_group_name MediaStreamingPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * common_encryption_cbcs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#common_encryption_cbcs MediaStreamingPolicy#common_encryption_cbcs}
     *
     * @stability stable
     */
    readonly commonEncryptionCbcs?: MediaStreamingPolicyCommonEncryptionCbcs;
    /**
     * common_encryption_cenc block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#common_encryption_cenc MediaStreamingPolicy#common_encryption_cenc}
     *
     * @stability stable
     */
    readonly commonEncryptionCenc?: MediaStreamingPolicyCommonEncryptionCenc;
    /**
     * no_encryption_enabled_protocols block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#no_encryption_enabled_protocols MediaStreamingPolicy#no_encryption_enabled_protocols}
     *
     * @stability stable
     */
    readonly noEncryptionEnabledProtocols?: MediaStreamingPolicyNoEncryptionEnabledProtocols;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#timeouts MediaStreamingPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaStreamingPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#label MediaStreamingPolicy#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}.
     *
     * @stability stable
     */
    readonly policyName?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined);
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _policyName?;
    /**
     * @stability stable
     */
    get policyName(): string;
    /**
     * @stability stable
     */
    set policyName(value: string);
    /**
     * @stability stable
     */
    resetPolicyName(): void;
    /**
     * @stability stable
     */
    get policyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#allow_persistent_license MediaStreamingPolicy#allow_persistent_license}.
     *
     * @stability stable
     */
    readonly allowPersistentLicense?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#custom_license_acquisition_url_template MediaStreamingPolicy#custom_license_acquisition_url_template}.
     *
     * @stability stable
     */
    readonly customLicenseAcquisitionUrlTemplate?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsDrmFairplayToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined);
    private _allowPersistentLicense?;
    /**
     * @stability stable
     */
    get allowPersistentLicense(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowPersistentLicense(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowPersistentLicense(): void;
    /**
     * @stability stable
     */
    get allowPersistentLicenseInput(): boolean | cdktf.IResolvable | undefined;
    private _customLicenseAcquisitionUrlTemplate?;
    /**
     * @stability stable
     */
    get customLicenseAcquisitionUrlTemplate(): string;
    /**
     * @stability stable
     */
    set customLicenseAcquisitionUrlTemplate(value: string);
    /**
     * @stability stable
     */
    resetCustomLicenseAcquisitionUrlTemplate(): void;
    /**
     * @stability stable
     */
    get customLicenseAcquisitionUrlTemplateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#dash MediaStreamingPolicy#dash}.
     *
     * @stability stable
     */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#download MediaStreamingPolicy#download}.
     *
     * @stability stable
     */
    readonly download?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#hls MediaStreamingPolicy#hls}.
     *
     * @stability stable
     */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}.
     *
     * @stability stable
     */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined);
    private _dash?;
    /**
     * @stability stable
     */
    get dash(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dash(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDash(): void;
    /**
     * @stability stable
     */
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    /**
     * @stability stable
     */
    get download(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set download(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDownload(): void;
    /**
     * @stability stable
     */
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    /**
     * @stability stable
     */
    get hls(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hls(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHls(): void;
    /**
     * @stability stable
     */
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    /**
     * @stability stable
     */
    get smoothStreaming(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSmoothStreaming(): void;
    /**
     * @stability stable
     */
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCbcs {
    /**
     * default_content_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#default_content_key MediaStreamingPolicy#default_content_key}
     *
     * @stability stable
     */
    readonly defaultContentKey?: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey;
    /**
     * drm_fairplay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#drm_fairplay MediaStreamingPolicy#drm_fairplay}
     *
     * @stability stable
     */
    readonly drmFairplay?: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay;
    /**
     * enabled_protocols block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#enabled_protocols MediaStreamingPolicy#enabled_protocols}
     *
     * @stability stable
     */
    readonly enabledProtocols?: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsOutputReference | MediaStreamingPolicyCommonEncryptionCbcs): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCbcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcs | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcs | undefined);
    private _defaultContentKey;
    /**
     * @stability stable
     */
    get defaultContentKey(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference;
    /**
     * @stability stable
     */
    putDefaultContentKey(value: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey): void;
    /**
     * @stability stable
     */
    resetDefaultContentKey(): void;
    /**
     * @stability stable
     */
    get defaultContentKeyInput(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined;
    private _drmFairplay;
    /**
     * @stability stable
     */
    get drmFairplay(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference;
    /**
     * @stability stable
     */
    putDrmFairplay(value: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay): void;
    /**
     * @stability stable
     */
    resetDrmFairplay(): void;
    /**
     * @stability stable
     */
    get drmFairplayInput(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined;
    private _enabledProtocols;
    /**
     * @stability stable
     */
    get enabledProtocols(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference;
    /**
     * @stability stable
     */
    putEnabledProtocols(value: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols): void;
    /**
     * @stability stable
     */
    resetEnabledProtocols(): void;
    /**
     * @stability stable
     */
    get enabledProtocolsInput(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCencDefaultContentKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#label MediaStreamingPolicy#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}.
     *
     * @stability stable
     */
    readonly policyName?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencDefaultContentKeyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCencDefaultContentKey): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined);
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _policyName?;
    /**
     * @stability stable
     */
    get policyName(): string;
    /**
     * @stability stable
     */
    set policyName(value: string);
    /**
     * @stability stable
     */
    resetPolicyName(): void;
    /**
     * @stability stable
     */
    get policyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCencDrmPlayready {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#custom_attributes MediaStreamingPolicy#custom_attributes}.
     *
     * @stability stable
     */
    readonly customAttributes?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#custom_license_acquisition_url_template MediaStreamingPolicy#custom_license_acquisition_url_template}.
     *
     * @stability stable
     */
    readonly customLicenseAcquisitionUrlTemplate?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencDrmPlayreadyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference | MediaStreamingPolicyCommonEncryptionCencDrmPlayready): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined);
    private _customAttributes?;
    /**
     * @stability stable
     */
    get customAttributes(): string;
    /**
     * @stability stable
     */
    set customAttributes(value: string);
    /**
     * @stability stable
     */
    resetCustomAttributes(): void;
    /**
     * @stability stable
     */
    get customAttributesInput(): string | undefined;
    private _customLicenseAcquisitionUrlTemplate?;
    /**
     * @stability stable
     */
    get customLicenseAcquisitionUrlTemplate(): string;
    /**
     * @stability stable
     */
    set customLicenseAcquisitionUrlTemplate(value: string);
    /**
     * @stability stable
     */
    resetCustomLicenseAcquisitionUrlTemplate(): void;
    /**
     * @stability stable
     */
    get customLicenseAcquisitionUrlTemplateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCencEnabledProtocols {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#dash MediaStreamingPolicy#dash}.
     *
     * @stability stable
     */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#download MediaStreamingPolicy#download}.
     *
     * @stability stable
     */
    readonly download?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#hls MediaStreamingPolicy#hls}.
     *
     * @stability stable
     */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}.
     *
     * @stability stable
     */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCencEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCencEnabledProtocols): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined);
    private _dash?;
    /**
     * @stability stable
     */
    get dash(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dash(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDash(): void;
    /**
     * @stability stable
     */
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    /**
     * @stability stable
     */
    get download(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set download(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDownload(): void;
    /**
     * @stability stable
     */
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    /**
     * @stability stable
     */
    get hls(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hls(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHls(): void;
    /**
     * @stability stable
     */
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    /**
     * @stability stable
     */
    get smoothStreaming(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSmoothStreaming(): void;
    /**
     * @stability stable
     */
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyCommonEncryptionCenc {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#drm_widevine_custom_license_acquisition_url_template MediaStreamingPolicy#drm_widevine_custom_license_acquisition_url_template}.
     *
     * @stability stable
     */
    readonly drmWidevineCustomLicenseAcquisitionUrlTemplate?: string;
    /**
     * default_content_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#default_content_key MediaStreamingPolicy#default_content_key}
     *
     * @stability stable
     */
    readonly defaultContentKey?: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey;
    /**
     * drm_playready block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#drm_playready MediaStreamingPolicy#drm_playready}
     *
     * @stability stable
     */
    readonly drmPlayready?: MediaStreamingPolicyCommonEncryptionCencDrmPlayready;
    /**
     * enabled_protocols block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#enabled_protocols MediaStreamingPolicy#enabled_protocols}
     *
     * @stability stable
     */
    readonly enabledProtocols?: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols;
}
export declare function mediaStreamingPolicyCommonEncryptionCencToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencOutputReference | MediaStreamingPolicyCommonEncryptionCenc): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyCommonEncryptionCencOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyCommonEncryptionCenc | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCenc | undefined);
    private _drmWidevineCustomLicenseAcquisitionUrlTemplate?;
    /**
     * @stability stable
     */
    get drmWidevineCustomLicenseAcquisitionUrlTemplate(): string;
    /**
     * @stability stable
     */
    set drmWidevineCustomLicenseAcquisitionUrlTemplate(value: string);
    /**
     * @stability stable
     */
    resetDrmWidevineCustomLicenseAcquisitionUrlTemplate(): void;
    /**
     * @stability stable
     */
    get drmWidevineCustomLicenseAcquisitionUrlTemplateInput(): string | undefined;
    private _defaultContentKey;
    /**
     * @stability stable
     */
    get defaultContentKey(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference;
    /**
     * @stability stable
     */
    putDefaultContentKey(value: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey): void;
    /**
     * @stability stable
     */
    resetDefaultContentKey(): void;
    /**
     * @stability stable
     */
    get defaultContentKeyInput(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined;
    private _drmPlayready;
    /**
     * @stability stable
     */
    get drmPlayready(): MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference;
    /**
     * @stability stable
     */
    putDrmPlayready(value: MediaStreamingPolicyCommonEncryptionCencDrmPlayready): void;
    /**
     * @stability stable
     */
    resetDrmPlayready(): void;
    /**
     * @stability stable
     */
    get drmPlayreadyInput(): MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined;
    private _enabledProtocols;
    /**
     * @stability stable
     */
    get enabledProtocols(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference;
    /**
     * @stability stable
     */
    putEnabledProtocols(value: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols): void;
    /**
     * @stability stable
     */
    resetEnabledProtocols(): void;
    /**
     * @stability stable
     */
    get enabledProtocolsInput(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyNoEncryptionEnabledProtocols {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#dash MediaStreamingPolicy#dash}.
     *
     * @stability stable
     */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#download MediaStreamingPolicy#download}.
     *
     * @stability stable
     */
    readonly download?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#hls MediaStreamingPolicy#hls}.
     *
     * @stability stable
     */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}.
     *
     * @stability stable
     */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyNoEncryptionEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference | MediaStreamingPolicyNoEncryptionEnabledProtocols): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined);
    private _dash?;
    /**
     * @stability stable
     */
    get dash(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dash(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDash(): void;
    /**
     * @stability stable
     */
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    /**
     * @stability stable
     */
    get download(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set download(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDownload(): void;
    /**
     * @stability stable
     */
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    /**
     * @stability stable
     */
    get hls(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hls(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHls(): void;
    /**
     * @stability stable
     */
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    /**
     * @stability stable
     */
    get smoothStreaming(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSmoothStreaming(): void;
    /**
     * @stability stable
     */
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#create MediaStreamingPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#delete MediaStreamingPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#read MediaStreamingPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function mediaStreamingPolicyTimeoutsToTerraform(struct?: MediaStreamingPolicyTimeoutsOutputReference | MediaStreamingPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaStreamingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy azurerm_media_streaming_policy}.
 *
 * @stability stable
 */
export declare class MediaStreamingPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy azurerm_media_streaming_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaStreamingPolicyConfig);
    private _defaultContentKeyPolicyName?;
    /**
     * @stability stable
     */
    get defaultContentKeyPolicyName(): string;
    /**
     * @stability stable
     */
    set defaultContentKeyPolicyName(value: string);
    /**
     * @stability stable
     */
    resetDefaultContentKeyPolicyName(): void;
    /**
     * @stability stable
     */
    get defaultContentKeyPolicyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _commonEncryptionCbcs;
    /**
     * @stability stable
     */
    get commonEncryptionCbcs(): MediaStreamingPolicyCommonEncryptionCbcsOutputReference;
    /**
     * @stability stable
     */
    putCommonEncryptionCbcs(value: MediaStreamingPolicyCommonEncryptionCbcs): void;
    /**
     * @stability stable
     */
    resetCommonEncryptionCbcs(): void;
    /**
     * @stability stable
     */
    get commonEncryptionCbcsInput(): MediaStreamingPolicyCommonEncryptionCbcs | undefined;
    private _commonEncryptionCenc;
    /**
     * @stability stable
     */
    get commonEncryptionCenc(): MediaStreamingPolicyCommonEncryptionCencOutputReference;
    /**
     * @stability stable
     */
    putCommonEncryptionCenc(value: MediaStreamingPolicyCommonEncryptionCenc): void;
    /**
     * @stability stable
     */
    resetCommonEncryptionCenc(): void;
    /**
     * @stability stable
     */
    get commonEncryptionCencInput(): MediaStreamingPolicyCommonEncryptionCenc | undefined;
    private _noEncryptionEnabledProtocols;
    /**
     * @stability stable
     */
    get noEncryptionEnabledProtocols(): MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference;
    /**
     * @stability stable
     */
    putNoEncryptionEnabledProtocols(value: MediaStreamingPolicyNoEncryptionEnabledProtocols): void;
    /**
     * @stability stable
     */
    resetNoEncryptionEnabledProtocols(): void;
    /**
     * @stability stable
     */
    get noEncryptionEnabledProtocolsInput(): MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaStreamingPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaStreamingPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaStreamingPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
