import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorLogProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#categories MonitorLogProfile#categories}.
     *
     * @stability stable
     */
    readonly categories: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#locations MonitorLogProfile#locations}.
     *
     * @stability stable
     */
    readonly locations: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#name MonitorLogProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#servicebus_rule_id MonitorLogProfile#servicebus_rule_id}.
     *
     * @stability stable
     */
    readonly servicebusRuleId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#storage_account_id MonitorLogProfile#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#retention_policy MonitorLogProfile#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy: MonitorLogProfileRetentionPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#timeouts MonitorLogProfile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorLogProfileTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorLogProfileRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#days MonitorLogProfile#days}.
     *
     * @stability stable
     */
    readonly days?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#enabled MonitorLogProfile#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function monitorLogProfileRetentionPolicyToTerraform(struct?: MonitorLogProfileRetentionPolicyOutputReference | MonitorLogProfileRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class MonitorLogProfileRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorLogProfileRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorLogProfileRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MonitorLogProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#create MonitorLogProfile#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#delete MonitorLogProfile#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#read MonitorLogProfile#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile#update MonitorLogProfile#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorLogProfileTimeoutsToTerraform(struct?: MonitorLogProfileTimeoutsOutputReference | MonitorLogProfileTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitorLogProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorLogProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorLogProfileTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile azurerm_monitor_log_profile}.
 *
 * @stability stable
 */
export declare class MonitorLogProfile extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_log_profile azurerm_monitor_log_profile} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorLogProfileConfig);
    private _categories?;
    /**
     * @stability stable
     */
    get categories(): string[];
    /**
     * @stability stable
     */
    set categories(value: string[]);
    /**
     * @stability stable
     */
    get categoriesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _locations?;
    /**
     * @stability stable
     */
    get locations(): string[];
    /**
     * @stability stable
     */
    set locations(value: string[]);
    /**
     * @stability stable
     */
    get locationsInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _servicebusRuleId?;
    /**
     * @stability stable
     */
    get servicebusRuleId(): string;
    /**
     * @stability stable
     */
    set servicebusRuleId(value: string);
    /**
     * @stability stable
     */
    resetServicebusRuleId(): void;
    /**
     * @stability stable
     */
    get servicebusRuleIdInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _retentionPolicy;
    /**
     * @stability stable
     */
    get retentionPolicy(): MonitorLogProfileRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetentionPolicy(value: MonitorLogProfileRetentionPolicy): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): MonitorLogProfileRetentionPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorLogProfileTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorLogProfileTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorLogProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
