import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_name}.
     *
     * @stability stable
     */
    readonly baselineName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#database_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#rule_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#rule_id}.
     *
     * @stability stable
     */
    readonly ruleId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#server_vulnerability_assessment_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#server_vulnerability_assessment_id}.
     *
     * @stability stable
     */
    readonly serverVulnerabilityAssessmentId: string;
    /**
     * baseline_result block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_result}
     *
     * @stability stable
     */
    readonly baselineResult: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#timeouts MssqlDatabaseVulnerabilityAssessmentRuleBaseline#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#result}.
     *
     * @stability stable
     */
    readonly result: string[];
}
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultToTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult): any;
/**
 * @stability stable
 */
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#create MssqlDatabaseVulnerabilityAssessmentRuleBaseline#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#delete MssqlDatabaseVulnerabilityAssessmentRuleBaseline#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#read MssqlDatabaseVulnerabilityAssessmentRuleBaseline#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#update MssqlDatabaseVulnerabilityAssessmentRuleBaseline#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsToTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference | MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts): any;
/**
 * @stability stable
 */
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline}.
 *
 * @stability stable
 */
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaseline extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig);
    private _baselineName?;
    /**
     * @stability stable
     */
    get baselineName(): string;
    /**
     * @stability stable
     */
    set baselineName(value: string);
    /**
     * @stability stable
     */
    resetBaselineName(): void;
    /**
     * @stability stable
     */
    get baselineNameInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ruleId?;
    /**
     * @stability stable
     */
    get ruleId(): string;
    /**
     * @stability stable
     */
    set ruleId(value: string);
    /**
     * @stability stable
     */
    get ruleIdInput(): string | undefined;
    private _serverVulnerabilityAssessmentId?;
    /**
     * @stability stable
     */
    get serverVulnerabilityAssessmentId(): string;
    /**
     * @stability stable
     */
    set serverVulnerabilityAssessmentId(value: string);
    /**
     * @stability stable
     */
    get serverVulnerabilityAssessmentIdInput(): string | undefined;
    private _baselineResult?;
    /**
     * @stability stable
     */
    get baselineResult(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[];
    /**
     * @stability stable
     */
    set baselineResult(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[]);
    /**
     * @stability stable
     */
    get baselineResultInput(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
