import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetappSnapshotPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#account_name NetappSnapshotPolicy#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#enabled NetappSnapshotPolicy#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#location NetappSnapshotPolicy#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#name NetappSnapshotPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#resource_group_name NetappSnapshotPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#tags NetappSnapshotPolicy#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * daily_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#daily_schedule NetappSnapshotPolicy#daily_schedule}
     *
     * @stability stable
     */
    readonly dailySchedule?: NetappSnapshotPolicyDailySchedule;
    /**
     * hourly_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#hourly_schedule NetappSnapshotPolicy#hourly_schedule}
     *
     * @stability stable
     */
    readonly hourlySchedule?: NetappSnapshotPolicyHourlySchedule;
    /**
     * monthly_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#monthly_schedule NetappSnapshotPolicy#monthly_schedule}
     *
     * @stability stable
     */
    readonly monthlySchedule?: NetappSnapshotPolicyMonthlySchedule;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#timeouts NetappSnapshotPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetappSnapshotPolicyTimeouts;
    /**
     * weekly_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#weekly_schedule NetappSnapshotPolicy#weekly_schedule}
     *
     * @stability stable
     */
    readonly weeklySchedule?: NetappSnapshotPolicyWeeklySchedule;
}
/**
 * @stability stable
 */
export interface NetappSnapshotPolicyDailySchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#hour NetappSnapshotPolicy#hour}.
     *
     * @stability stable
     */
    readonly hour: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}.
     *
     * @stability stable
     */
    readonly minute: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}.
     *
     * @stability stable
     */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyDailyScheduleToTerraform(struct?: NetappSnapshotPolicyDailyScheduleOutputReference | NetappSnapshotPolicyDailySchedule): any;
/**
 * @stability stable
 */
export declare class NetappSnapshotPolicyDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetappSnapshotPolicyDailySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetappSnapshotPolicyDailySchedule | undefined);
    private _hour?;
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    set hour(value: number);
    /**
     * @stability stable
     */
    get hourInput(): number | undefined;
    private _minute?;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    set minute(value: number);
    /**
     * @stability stable
     */
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
    /**
     * @stability stable
     */
    set snapshotsToKeep(value: number);
    /**
     * @stability stable
     */
    get snapshotsToKeepInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface NetappSnapshotPolicyHourlySchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}.
     *
     * @stability stable
     */
    readonly minute: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}.
     *
     * @stability stable
     */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyHourlyScheduleToTerraform(struct?: NetappSnapshotPolicyHourlyScheduleOutputReference | NetappSnapshotPolicyHourlySchedule): any;
/**
 * @stability stable
 */
export declare class NetappSnapshotPolicyHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetappSnapshotPolicyHourlySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetappSnapshotPolicyHourlySchedule | undefined);
    private _minute?;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    set minute(value: number);
    /**
     * @stability stable
     */
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
    /**
     * @stability stable
     */
    set snapshotsToKeep(value: number);
    /**
     * @stability stable
     */
    get snapshotsToKeepInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface NetappSnapshotPolicyMonthlySchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#days_of_month NetappSnapshotPolicy#days_of_month}.
     *
     * @stability stable
     */
    readonly daysOfMonth: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#hour NetappSnapshotPolicy#hour}.
     *
     * @stability stable
     */
    readonly hour: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}.
     *
     * @stability stable
     */
    readonly minute: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}.
     *
     * @stability stable
     */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyMonthlyScheduleToTerraform(struct?: NetappSnapshotPolicyMonthlyScheduleOutputReference | NetappSnapshotPolicyMonthlySchedule): any;
/**
 * @stability stable
 */
export declare class NetappSnapshotPolicyMonthlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetappSnapshotPolicyMonthlySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetappSnapshotPolicyMonthlySchedule | undefined);
    private _daysOfMonth?;
    /**
     * @stability stable
     */
    get daysOfMonth(): number[];
    /**
     * @stability stable
     */
    set daysOfMonth(value: number[]);
    /**
     * @stability stable
     */
    get daysOfMonthInput(): number[] | undefined;
    private _hour?;
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    set hour(value: number);
    /**
     * @stability stable
     */
    get hourInput(): number | undefined;
    private _minute?;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    set minute(value: number);
    /**
     * @stability stable
     */
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
    /**
     * @stability stable
     */
    set snapshotsToKeep(value: number);
    /**
     * @stability stable
     */
    get snapshotsToKeepInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface NetappSnapshotPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#create NetappSnapshotPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#delete NetappSnapshotPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#read NetappSnapshotPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#update NetappSnapshotPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function netappSnapshotPolicyTimeoutsToTerraform(struct?: NetappSnapshotPolicyTimeoutsOutputReference | NetappSnapshotPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class NetappSnapshotPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetappSnapshotPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetappSnapshotPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetappSnapshotPolicyWeeklySchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#days_of_week NetappSnapshotPolicy#days_of_week}.
     *
     * @stability stable
     */
    readonly daysOfWeek: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#hour NetappSnapshotPolicy#hour}.
     *
     * @stability stable
     */
    readonly hour: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}.
     *
     * @stability stable
     */
    readonly minute: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}.
     *
     * @stability stable
     */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyWeeklyScheduleToTerraform(struct?: NetappSnapshotPolicyWeeklyScheduleOutputReference | NetappSnapshotPolicyWeeklySchedule): any;
/**
 * @stability stable
 */
export declare class NetappSnapshotPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetappSnapshotPolicyWeeklySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetappSnapshotPolicyWeeklySchedule | undefined);
    private _daysOfWeek?;
    /**
     * @stability stable
     */
    get daysOfWeek(): string[];
    /**
     * @stability stable
     */
    set daysOfWeek(value: string[]);
    /**
     * @stability stable
     */
    get daysOfWeekInput(): string[] | undefined;
    private _hour?;
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    set hour(value: number);
    /**
     * @stability stable
     */
    get hourInput(): number | undefined;
    private _minute?;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    set minute(value: number);
    /**
     * @stability stable
     */
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
    /**
     * @stability stable
     */
    set snapshotsToKeep(value: number);
    /**
     * @stability stable
     */
    get snapshotsToKeepInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy azurerm_netapp_snapshot_policy}.
 *
 * @stability stable
 */
export declare class NetappSnapshotPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/netapp_snapshot_policy azurerm_netapp_snapshot_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetappSnapshotPolicyConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _dailySchedule;
    /**
     * @stability stable
     */
    get dailySchedule(): NetappSnapshotPolicyDailyScheduleOutputReference;
    /**
     * @stability stable
     */
    putDailySchedule(value: NetappSnapshotPolicyDailySchedule): void;
    /**
     * @stability stable
     */
    resetDailySchedule(): void;
    /**
     * @stability stable
     */
    get dailyScheduleInput(): NetappSnapshotPolicyDailySchedule | undefined;
    private _hourlySchedule;
    /**
     * @stability stable
     */
    get hourlySchedule(): NetappSnapshotPolicyHourlyScheduleOutputReference;
    /**
     * @stability stable
     */
    putHourlySchedule(value: NetappSnapshotPolicyHourlySchedule): void;
    /**
     * @stability stable
     */
    resetHourlySchedule(): void;
    /**
     * @stability stable
     */
    get hourlyScheduleInput(): NetappSnapshotPolicyHourlySchedule | undefined;
    private _monthlySchedule;
    /**
     * @stability stable
     */
    get monthlySchedule(): NetappSnapshotPolicyMonthlyScheduleOutputReference;
    /**
     * @stability stable
     */
    putMonthlySchedule(value: NetappSnapshotPolicyMonthlySchedule): void;
    /**
     * @stability stable
     */
    resetMonthlySchedule(): void;
    /**
     * @stability stable
     */
    get monthlyScheduleInput(): NetappSnapshotPolicyMonthlySchedule | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetappSnapshotPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetappSnapshotPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetappSnapshotPolicyTimeouts | undefined;
    private _weeklySchedule;
    /**
     * @stability stable
     */
    get weeklySchedule(): NetappSnapshotPolicyWeeklyScheduleOutputReference;
    /**
     * @stability stable
     */
    putWeeklySchedule(value: NetappSnapshotPolicyWeeklySchedule): void;
    /**
     * @stability stable
     */
    resetWeeklySchedule(): void;
    /**
     * @stability stable
     */
    get weeklyScheduleInput(): NetappSnapshotPolicyWeeklySchedule | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
