import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkSecurityRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#access NetworkSecurityRule#access}.
     *
     * @stability stable
     */
    readonly access: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#description NetworkSecurityRule#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_address_prefix NetworkSecurityRule#destination_address_prefix}.
     *
     * @stability stable
     */
    readonly destinationAddressPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_address_prefixes NetworkSecurityRule#destination_address_prefixes}.
     *
     * @stability stable
     */
    readonly destinationAddressPrefixes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_application_security_group_ids NetworkSecurityRule#destination_application_security_group_ids}.
     *
     * @stability stable
     */
    readonly destinationApplicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_port_range NetworkSecurityRule#destination_port_range}.
     *
     * @stability stable
     */
    readonly destinationPortRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_port_ranges NetworkSecurityRule#destination_port_ranges}.
     *
     * @stability stable
     */
    readonly destinationPortRanges?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#direction NetworkSecurityRule#direction}.
     *
     * @stability stable
     */
    readonly direction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#name NetworkSecurityRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#network_security_group_name NetworkSecurityRule#network_security_group_name}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#priority NetworkSecurityRule#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#protocol NetworkSecurityRule#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#resource_group_name NetworkSecurityRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_address_prefix NetworkSecurityRule#source_address_prefix}.
     *
     * @stability stable
     */
    readonly sourceAddressPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_address_prefixes NetworkSecurityRule#source_address_prefixes}.
     *
     * @stability stable
     */
    readonly sourceAddressPrefixes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_application_security_group_ids NetworkSecurityRule#source_application_security_group_ids}.
     *
     * @stability stable
     */
    readonly sourceApplicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_port_range NetworkSecurityRule#source_port_range}.
     *
     * @stability stable
     */
    readonly sourcePortRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_port_ranges NetworkSecurityRule#source_port_ranges}.
     *
     * @stability stable
     */
    readonly sourcePortRanges?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#timeouts NetworkSecurityRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkSecurityRuleTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkSecurityRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#create NetworkSecurityRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#delete NetworkSecurityRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#read NetworkSecurityRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#update NetworkSecurityRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkSecurityRuleTimeoutsToTerraform(struct?: NetworkSecurityRuleTimeoutsOutputReference | NetworkSecurityRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkSecurityRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkSecurityRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkSecurityRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule azurerm_network_security_rule}.
 *
 * @stability stable
 */
export declare class NetworkSecurityRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule azurerm_network_security_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkSecurityRuleConfig);
    private _access?;
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    set access(value: string);
    /**
     * @stability stable
     */
    get accessInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _destinationAddressPrefix?;
    /**
     * @stability stable
     */
    get destinationAddressPrefix(): string;
    /**
     * @stability stable
     */
    set destinationAddressPrefix(value: string);
    /**
     * @stability stable
     */
    resetDestinationAddressPrefix(): void;
    /**
     * @stability stable
     */
    get destinationAddressPrefixInput(): string | undefined;
    private _destinationAddressPrefixes?;
    /**
     * @stability stable
     */
    get destinationAddressPrefixes(): string[];
    /**
     * @stability stable
     */
    set destinationAddressPrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetDestinationAddressPrefixes(): void;
    /**
     * @stability stable
     */
    get destinationAddressPrefixesInput(): string[] | undefined;
    private _destinationApplicationSecurityGroupIds?;
    /**
     * @stability stable
     */
    get destinationApplicationSecurityGroupIds(): string[];
    /**
     * @stability stable
     */
    set destinationApplicationSecurityGroupIds(value: string[]);
    /**
     * @stability stable
     */
    resetDestinationApplicationSecurityGroupIds(): void;
    /**
     * @stability stable
     */
    get destinationApplicationSecurityGroupIdsInput(): string[] | undefined;
    private _destinationPortRange?;
    /**
     * @stability stable
     */
    get destinationPortRange(): string;
    /**
     * @stability stable
     */
    set destinationPortRange(value: string);
    /**
     * @stability stable
     */
    resetDestinationPortRange(): void;
    /**
     * @stability stable
     */
    get destinationPortRangeInput(): string | undefined;
    private _destinationPortRanges?;
    /**
     * @stability stable
     */
    get destinationPortRanges(): string[];
    /**
     * @stability stable
     */
    set destinationPortRanges(value: string[]);
    /**
     * @stability stable
     */
    resetDestinationPortRanges(): void;
    /**
     * @stability stable
     */
    get destinationPortRangesInput(): string[] | undefined;
    private _direction?;
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    set direction(value: string);
    /**
     * @stability stable
     */
    get directionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkSecurityGroupName?;
    /**
     * @stability stable
     */
    get networkSecurityGroupName(): string;
    /**
     * @stability stable
     */
    set networkSecurityGroupName(value: string);
    /**
     * @stability stable
     */
    get networkSecurityGroupNameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceAddressPrefix?;
    /**
     * @stability stable
     */
    get sourceAddressPrefix(): string;
    /**
     * @stability stable
     */
    set sourceAddressPrefix(value: string);
    /**
     * @stability stable
     */
    resetSourceAddressPrefix(): void;
    /**
     * @stability stable
     */
    get sourceAddressPrefixInput(): string | undefined;
    private _sourceAddressPrefixes?;
    /**
     * @stability stable
     */
    get sourceAddressPrefixes(): string[];
    /**
     * @stability stable
     */
    set sourceAddressPrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetSourceAddressPrefixes(): void;
    /**
     * @stability stable
     */
    get sourceAddressPrefixesInput(): string[] | undefined;
    private _sourceApplicationSecurityGroupIds?;
    /**
     * @stability stable
     */
    get sourceApplicationSecurityGroupIds(): string[];
    /**
     * @stability stable
     */
    set sourceApplicationSecurityGroupIds(value: string[]);
    /**
     * @stability stable
     */
    resetSourceApplicationSecurityGroupIds(): void;
    /**
     * @stability stable
     */
    get sourceApplicationSecurityGroupIdsInput(): string[] | undefined;
    private _sourcePortRange?;
    /**
     * @stability stable
     */
    get sourcePortRange(): string;
    /**
     * @stability stable
     */
    set sourcePortRange(value: string);
    /**
     * @stability stable
     */
    resetSourcePortRange(): void;
    /**
     * @stability stable
     */
    get sourcePortRangeInput(): string | undefined;
    private _sourcePortRanges?;
    /**
     * @stability stable
     */
    get sourcePortRanges(): string[];
    /**
     * @stability stable
     */
    set sourcePortRanges(value: string[]);
    /**
     * @stability stable
     */
    resetSourcePortRanges(): void;
    /**
     * @stability stable
     */
    get sourcePortRangesInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkSecurityRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkSecurityRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkSecurityRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
