import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NotificationHubAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#listen NotificationHubAuthorizationRule#listen}.
     *
     * @stability stable
     */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#manage NotificationHubAuthorizationRule#manage}.
     *
     * @stability stable
     */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#name NotificationHubAuthorizationRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#namespace_name NotificationHubAuthorizationRule#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#notification_hub_name NotificationHubAuthorizationRule#notification_hub_name}.
     *
     * @stability stable
     */
    readonly notificationHubName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#resource_group_name NotificationHubAuthorizationRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#send NotificationHubAuthorizationRule#send}.
     *
     * @stability stable
     */
    readonly send?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#timeouts NotificationHubAuthorizationRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NotificationHubAuthorizationRuleTimeouts;
}
/**
 * @stability stable
 */
export interface NotificationHubAuthorizationRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#create NotificationHubAuthorizationRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#delete NotificationHubAuthorizationRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#read NotificationHubAuthorizationRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule#update NotificationHubAuthorizationRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function notificationHubAuthorizationRuleTimeoutsToTerraform(struct?: NotificationHubAuthorizationRuleTimeoutsOutputReference | NotificationHubAuthorizationRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class NotificationHubAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotificationHubAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotificationHubAuthorizationRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule azurerm_notification_hub_authorization_rule}.
 *
 * @stability stable
 */
export declare class NotificationHubAuthorizationRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub_authorization_rule azurerm_notification_hub_authorization_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NotificationHubAuthorizationRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _listen?;
    /**
     * @stability stable
     */
    get listen(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set listen(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetListen(): void;
    /**
     * @stability stable
     */
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    private _manage?;
    /**
     * @stability stable
     */
    get manage(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set manage(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManage(): void;
    /**
     * @stability stable
     */
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _notificationHubName?;
    /**
     * @stability stable
     */
    get notificationHubName(): string;
    /**
     * @stability stable
     */
    set notificationHubName(value: string);
    /**
     * @stability stable
     */
    get notificationHubNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    private _send?;
    /**
     * @stability stable
     */
    get send(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set send(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSend(): void;
    /**
     * @stability stable
     */
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NotificationHubAuthorizationRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NotificationHubAuthorizationRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NotificationHubAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
