import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#encryption_at_host_enabled OrchestratedVirtualMachineScaleSet#encryption_at_host_enabled}.
     *
     * @stability stable
     */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#eviction_policy OrchestratedVirtualMachineScaleSet#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#extensions_time_budget OrchestratedVirtualMachineScaleSet#extensions_time_budget}.
     *
     * @stability stable
     */
    readonly extensionsTimeBudget?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#instances OrchestratedVirtualMachineScaleSet#instances}.
     *
     * @stability stable
     */
    readonly instances?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#license_type OrchestratedVirtualMachineScaleSet#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#location OrchestratedVirtualMachineScaleSet#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#max_bid_price OrchestratedVirtualMachineScaleSet#max_bid_price}.
     *
     * @stability stable
     */
    readonly maxBidPrice?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#platform_fault_domain_count OrchestratedVirtualMachineScaleSet#platform_fault_domain_count}.
     *
     * @stability stable
     */
    readonly platformFaultDomainCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#priority OrchestratedVirtualMachineScaleSet#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#proximity_placement_group_id OrchestratedVirtualMachineScaleSet#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#resource_group_name OrchestratedVirtualMachineScaleSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#sku_name OrchestratedVirtualMachineScaleSet#sku_name}.
     *
     * @stability stable
     */
    readonly skuName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#source_image_id OrchestratedVirtualMachineScaleSet#source_image_id}.
     *
     * @stability stable
     */
    readonly sourceImageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#tags OrchestratedVirtualMachineScaleSet#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#zone_balance OrchestratedVirtualMachineScaleSet#zone_balance}.
     *
     * @stability stable
     */
    readonly zoneBalance?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#zones OrchestratedVirtualMachineScaleSet#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * automatic_instance_repair block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#automatic_instance_repair OrchestratedVirtualMachineScaleSet#automatic_instance_repair}
     *
     * @stability stable
     */
    readonly automaticInstanceRepair?: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair;
    /**
     * boot_diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#boot_diagnostics OrchestratedVirtualMachineScaleSet#boot_diagnostics}
     *
     * @stability stable
     */
    readonly bootDiagnostics?: OrchestratedVirtualMachineScaleSetBootDiagnostics;
    /**
     * data_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#data_disk OrchestratedVirtualMachineScaleSet#data_disk}
     *
     * @stability stable
     */
    readonly dataDisk?: OrchestratedVirtualMachineScaleSetDataDisk[];
    /**
     * extension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#extension OrchestratedVirtualMachineScaleSet#extension}
     *
     * @stability stable
     */
    readonly extension?: OrchestratedVirtualMachineScaleSetExtension[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#identity OrchestratedVirtualMachineScaleSet#identity}
     *
     * @stability stable
     */
    readonly identity?: OrchestratedVirtualMachineScaleSetIdentity;
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#network_interface OrchestratedVirtualMachineScaleSet#network_interface}
     *
     * @stability stable
     */
    readonly networkInterface?: OrchestratedVirtualMachineScaleSetNetworkInterface[];
    /**
     * os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#os_disk OrchestratedVirtualMachineScaleSet#os_disk}
     *
     * @stability stable
     */
    readonly osDisk?: OrchestratedVirtualMachineScaleSetOsDisk;
    /**
     * os_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#os_profile OrchestratedVirtualMachineScaleSet#os_profile}
     *
     * @stability stable
     */
    readonly osProfile?: OrchestratedVirtualMachineScaleSetOsProfile;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#plan OrchestratedVirtualMachineScaleSet#plan}
     *
     * @stability stable
     */
    readonly plan?: OrchestratedVirtualMachineScaleSetPlan;
    /**
     * source_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#source_image_reference OrchestratedVirtualMachineScaleSet#source_image_reference}
     *
     * @stability stable
     */
    readonly sourceImageReference?: OrchestratedVirtualMachineScaleSetSourceImageReference;
    /**
     * termination_notification block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#termination_notification OrchestratedVirtualMachineScaleSet#termination_notification}
     *
     * @stability stable
     */
    readonly terminationNotification?: OrchestratedVirtualMachineScaleSetTerminationNotification;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#timeouts OrchestratedVirtualMachineScaleSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OrchestratedVirtualMachineScaleSetTimeouts;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#enabled OrchestratedVirtualMachineScaleSet#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#grace_period OrchestratedVirtualMachineScaleSet#grace_period}.
     *
     * @stability stable
     */
    readonly gracePeriod?: string;
}
export declare function orchestratedVirtualMachineScaleSetAutomaticInstanceRepairToTerraform(struct?: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairOutputReference | OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    /**
     * @stability stable
     */
    get gracePeriod(): string;
    /**
     * @stability stable
     */
    set gracePeriod(value: string);
    /**
     * @stability stable
     */
    resetGracePeriod(): void;
    /**
     * @stability stable
     */
    get gracePeriodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetBootDiagnostics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#storage_account_uri OrchestratedVirtualMachineScaleSet#storage_account_uri}.
     *
     * @stability stable
     */
    readonly storageAccountUri?: string;
}
export declare function orchestratedVirtualMachineScaleSetBootDiagnosticsToTerraform(struct?: OrchestratedVirtualMachineScaleSetBootDiagnosticsOutputReference | OrchestratedVirtualMachineScaleSetBootDiagnostics): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetBootDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetBootDiagnostics | undefined);
    private _storageAccountUri?;
    /**
     * @stability stable
     */
    get storageAccountUri(): string;
    /**
     * @stability stable
     */
    set storageAccountUri(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountUri(): void;
    /**
     * @stability stable
     */
    get storageAccountUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetDataDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#caching OrchestratedVirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#create_option OrchestratedVirtualMachineScaleSet#create_option}.
     *
     * @stability stable
     */
    readonly createOption?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#disk_encryption_set_id OrchestratedVirtualMachineScaleSet#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#disk_iops_read_write OrchestratedVirtualMachineScaleSet#disk_iops_read_write}.
     *
     * @stability stable
     */
    readonly diskIopsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#disk_mbps_read_write OrchestratedVirtualMachineScaleSet#disk_mbps_read_write}.
     *
     * @stability stable
     */
    readonly diskMbpsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#disk_size_gb OrchestratedVirtualMachineScaleSet#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#lun OrchestratedVirtualMachineScaleSet#lun}.
     *
     * @stability stable
     */
    readonly lun: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#storage_account_type OrchestratedVirtualMachineScaleSet#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#write_accelerator_enabled OrchestratedVirtualMachineScaleSet#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetDataDiskToTerraform(struct?: OrchestratedVirtualMachineScaleSetDataDisk): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetExtension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#auto_upgrade_minor_version_enabled OrchestratedVirtualMachineScaleSet#auto_upgrade_minor_version_enabled}.
     *
     * @stability stable
     */
    readonly autoUpgradeMinorVersionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#extensions_to_provision_after_vm_creation OrchestratedVirtualMachineScaleSet#extensions_to_provision_after_vm_creation}.
     *
     * @stability stable
     */
    readonly extensionsToProvisionAfterVmCreation?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#force_extension_execution_on_change OrchestratedVirtualMachineScaleSet#force_extension_execution_on_change}.
     *
     * @stability stable
     */
    readonly forceExtensionExecutionOnChange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#protected_settings OrchestratedVirtualMachineScaleSet#protected_settings}.
     *
     * @stability stable
     */
    readonly protectedSettings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#publisher OrchestratedVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#settings OrchestratedVirtualMachineScaleSet#settings}.
     *
     * @stability stable
     */
    readonly settings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#type OrchestratedVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#type_handler_version OrchestratedVirtualMachineScaleSet#type_handler_version}.
     *
     * @stability stable
     */
    readonly typeHandlerVersion: string;
}
export declare function orchestratedVirtualMachineScaleSetExtensionToTerraform(struct?: OrchestratedVirtualMachineScaleSetExtension): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#identity_ids OrchestratedVirtualMachineScaleSet#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#type OrchestratedVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function orchestratedVirtualMachineScaleSetIdentityToTerraform(struct?: OrchestratedVirtualMachineScaleSetIdentityOutputReference | OrchestratedVirtualMachineScaleSetIdentity): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#tag OrchestratedVirtualMachineScaleSet#tag}.
     *
     * @stability stable
     */
    readonly tag: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#type OrchestratedVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#domain_name_label OrchestratedVirtualMachineScaleSet#domain_name_label}.
     *
     * @stability stable
     */
    readonly domainNameLabel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#idle_timeout_in_minutes OrchestratedVirtualMachineScaleSet#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#public_ip_prefix_id OrchestratedVirtualMachineScaleSet#public_ip_prefix_id}.
     *
     * @stability stable
     */
    readonly publicIpPrefixId?: string;
    /**
     * ip_tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#ip_tag OrchestratedVirtualMachineScaleSet#ip_tag}
     *
     * @stability stable
     */
    readonly ipTag?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[];
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#application_gateway_backend_address_pool_ids OrchestratedVirtualMachineScaleSet#application_gateway_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly applicationGatewayBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#application_security_group_ids OrchestratedVirtualMachineScaleSet#application_security_group_ids}.
     *
     * @stability stable
     */
    readonly applicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#load_balancer_backend_address_pool_ids OrchestratedVirtualMachineScaleSet#load_balancer_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#primary OrchestratedVirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#subnet_id OrchestratedVirtualMachineScaleSet#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#version OrchestratedVirtualMachineScaleSet#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * public_ip_address block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#public_ip_address OrchestratedVirtualMachineScaleSet#public_ip_address}
     *
     * @stability stable
     */
    readonly publicIpAddress?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[];
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetNetworkInterface {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#dns_servers OrchestratedVirtualMachineScaleSet#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#enable_accelerated_networking OrchestratedVirtualMachineScaleSet#enable_accelerated_networking}.
     *
     * @stability stable
     */
    readonly enableAcceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#enable_ip_forwarding OrchestratedVirtualMachineScaleSet#enable_ip_forwarding}.
     *
     * @stability stable
     */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#network_security_group_id OrchestratedVirtualMachineScaleSet#network_security_group_id}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#primary OrchestratedVirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#ip_configuration OrchestratedVirtualMachineScaleSet#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration[];
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterface): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#option OrchestratedVirtualMachineScaleSet#option}.
     *
     * @stability stable
     */
    readonly option: string;
}
export declare function orchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference | OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined);
    private _option?;
    /**
     * @stability stable
     */
    get option(): string;
    /**
     * @stability stable
     */
    set option(value: string);
    /**
     * @stability stable
     */
    get optionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#caching OrchestratedVirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#disk_encryption_set_id OrchestratedVirtualMachineScaleSet#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#disk_size_gb OrchestratedVirtualMachineScaleSet#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#storage_account_type OrchestratedVirtualMachineScaleSet#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#write_accelerator_enabled OrchestratedVirtualMachineScaleSet#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
     * diff_disk_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#diff_disk_settings OrchestratedVirtualMachineScaleSet#diff_disk_settings}
     *
     * @stability stable
     */
    readonly diffDiskSettings?: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings;
}
export declare function orchestratedVirtualMachineScaleSetOsDiskToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsDiskOutputReference | OrchestratedVirtualMachineScaleSetOsDisk): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsDisk | undefined);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    set diskEncryptionSetId(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionSetId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _storageAccountType?;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    set storageAccountType(value: string);
    /**
     * @stability stable
     */
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWriteAcceleratorEnabled(): void;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    /**
     * @stability stable
     */
    get diffDiskSettings(): OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference;
    /**
     * @stability stable
     */
    putDiffDiskSettings(value: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings): void;
    /**
     * @stability stable
     */
    resetDiffDiskSettings(): void;
    /**
     * @stability stable
     */
    get diffDiskSettingsInput(): OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#public_key OrchestratedVirtualMachineScaleSet#public_key}.
     *
     * @stability stable
     */
    readonly publicKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#username OrchestratedVirtualMachineScaleSet#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#url OrchestratedVirtualMachineScaleSet#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#key_vault_id OrchestratedVirtualMachineScaleSet#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#certificate OrchestratedVirtualMachineScaleSet#certificate}
     *
     * @stability stable
     */
    readonly certificate: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate[];
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#admin_password OrchestratedVirtualMachineScaleSet#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#admin_username OrchestratedVirtualMachineScaleSet#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#computer_name_prefix OrchestratedVirtualMachineScaleSet#computer_name_prefix}.
     *
     * @stability stable
     */
    readonly computerNamePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#disable_password_authentication OrchestratedVirtualMachineScaleSet#disable_password_authentication}.
     *
     * @stability stable
     */
    readonly disablePasswordAuthentication?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#provision_vm_agent OrchestratedVirtualMachineScaleSet#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * admin_ssh_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#admin_ssh_key OrchestratedVirtualMachineScaleSet#admin_ssh_key}
     *
     * @stability stable
     */
    readonly adminSshKey?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[];
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#secret OrchestratedVirtualMachineScaleSet#secret}
     *
     * @stability stable
     */
    readonly secret?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[];
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationOutputReference | OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration | undefined);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    resetAdminPassword(): void;
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    /**
     * @stability stable
     */
    get computerNamePrefix(): string;
    /**
     * @stability stable
     */
    set computerNamePrefix(value: string);
    /**
     * @stability stable
     */
    resetComputerNamePrefix(): void;
    /**
     * @stability stable
     */
    get computerNamePrefixInput(): string | undefined;
    private _disablePasswordAuthentication?;
    /**
     * @stability stable
     */
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisablePasswordAuthentication(): void;
    /**
     * @stability stable
     */
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _adminSshKey?;
    /**
     * @stability stable
     */
    get adminSshKey(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[];
    /**
     * @stability stable
     */
    set adminSshKey(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[]);
    /**
     * @stability stable
     */
    resetAdminSshKey(): void;
    /**
     * @stability stable
     */
    get adminSshKeyInput(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[] | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[];
    /**
     * @stability stable
     */
    set secret(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[]);
    /**
     * @stability stable
     */
    resetSecret(): void;
    /**
     * @stability stable
     */
    get secretInput(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[] | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#store OrchestratedVirtualMachineScaleSet#store}.
     *
     * @stability stable
     */
    readonly store: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#url OrchestratedVirtualMachineScaleSet#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#key_vault_id OrchestratedVirtualMachineScaleSet#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#certificate OrchestratedVirtualMachineScaleSet#certificate}
     *
     * @stability stable
     */
    readonly certificate: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate[];
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#certificate_url OrchestratedVirtualMachineScaleSet#certificate_url}.
     *
     * @stability stable
     */
    readonly certificateUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#protocol OrchestratedVirtualMachineScaleSet#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener): any;
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#admin_password OrchestratedVirtualMachineScaleSet#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#admin_username OrchestratedVirtualMachineScaleSet#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#computer_name_prefix OrchestratedVirtualMachineScaleSet#computer_name_prefix}.
     *
     * @stability stable
     */
    readonly computerNamePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#enable_automatic_updates OrchestratedVirtualMachineScaleSet#enable_automatic_updates}.
     *
     * @stability stable
     */
    readonly enableAutomaticUpdates?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#provision_vm_agent OrchestratedVirtualMachineScaleSet#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#timezone OrchestratedVirtualMachineScaleSet#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#secret OrchestratedVirtualMachineScaleSet#secret}
     *
     * @stability stable
     */
    readonly secret?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[];
    /**
     * winrm_listener block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#winrm_listener OrchestratedVirtualMachineScaleSet#winrm_listener}
     *
     * @stability stable
     */
    readonly winrmListener?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[];
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationOutputReference | OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration | undefined);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    /**
     * @stability stable
     */
    get computerNamePrefix(): string;
    /**
     * @stability stable
     */
    set computerNamePrefix(value: string);
    /**
     * @stability stable
     */
    resetComputerNamePrefix(): void;
    /**
     * @stability stable
     */
    get computerNamePrefixInput(): string | undefined;
    private _enableAutomaticUpdates?;
    /**
     * @stability stable
     */
    get enableAutomaticUpdates(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticUpdates(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutomaticUpdates(): void;
    /**
     * @stability stable
     */
    get enableAutomaticUpdatesInput(): boolean | cdktf.IResolvable | undefined;
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[];
    /**
     * @stability stable
     */
    set secret(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[]);
    /**
     * @stability stable
     */
    resetSecret(): void;
    /**
     * @stability stable
     */
    get secretInput(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[] | undefined;
    private _winrmListener?;
    /**
     * @stability stable
     */
    get winrmListener(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[];
    /**
     * @stability stable
     */
    set winrmListener(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[]);
    /**
     * @stability stable
     */
    resetWinrmListener(): void;
    /**
     * @stability stable
     */
    get winrmListenerInput(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[] | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetOsProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#custom_data OrchestratedVirtualMachineScaleSet#custom_data}.
     *
     * @stability stable
     */
    readonly customData?: string;
    /**
     * linux_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#linux_configuration OrchestratedVirtualMachineScaleSet#linux_configuration}
     *
     * @stability stable
     */
    readonly linuxConfiguration?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration;
    /**
     * windows_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#windows_configuration OrchestratedVirtualMachineScaleSet#windows_configuration}
     *
     * @stability stable
     */
    readonly windowsConfiguration?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileOutputReference | OrchestratedVirtualMachineScaleSetOsProfile): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfile | undefined);
    private _customData?;
    /**
     * @stability stable
     */
    get customData(): string;
    /**
     * @stability stable
     */
    set customData(value: string);
    /**
     * @stability stable
     */
    resetCustomData(): void;
    /**
     * @stability stable
     */
    get customDataInput(): string | undefined;
    private _linuxConfiguration;
    /**
     * @stability stable
     */
    get linuxConfiguration(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationOutputReference;
    /**
     * @stability stable
     */
    putLinuxConfiguration(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration): void;
    /**
     * @stability stable
     */
    resetLinuxConfiguration(): void;
    /**
     * @stability stable
     */
    get linuxConfigurationInput(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration | undefined;
    private _windowsConfiguration;
    /**
     * @stability stable
     */
    get windowsConfiguration(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationOutputReference;
    /**
     * @stability stable
     */
    putWindowsConfiguration(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration): void;
    /**
     * @stability stable
     */
    resetWindowsConfiguration(): void;
    /**
     * @stability stable
     */
    get windowsConfigurationInput(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#product OrchestratedVirtualMachineScaleSet#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#publisher OrchestratedVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function orchestratedVirtualMachineScaleSetPlanToTerraform(struct?: OrchestratedVirtualMachineScaleSetPlanOutputReference | OrchestratedVirtualMachineScaleSetPlan): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetPlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetSourceImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#offer OrchestratedVirtualMachineScaleSet#offer}.
     *
     * @stability stable
     */
    readonly offer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#publisher OrchestratedVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#sku OrchestratedVirtualMachineScaleSet#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#version OrchestratedVirtualMachineScaleSet#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function orchestratedVirtualMachineScaleSetSourceImageReferenceToTerraform(struct?: OrchestratedVirtualMachineScaleSetSourceImageReferenceOutputReference | OrchestratedVirtualMachineScaleSetSourceImageReference): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetSourceImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetSourceImageReference | undefined);
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetTerminationNotification {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#enabled OrchestratedVirtualMachineScaleSet#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#timeout OrchestratedVirtualMachineScaleSet#timeout}.
     *
     * @stability stable
     */
    readonly timeout?: string;
}
export declare function orchestratedVirtualMachineScaleSetTerminationNotificationToTerraform(struct?: OrchestratedVirtualMachineScaleSetTerminationNotificationOutputReference | OrchestratedVirtualMachineScaleSetTerminationNotification): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetTerminationNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetTerminationNotification | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetTerminationNotification | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): string;
    /**
     * @stability stable
     */
    set timeout(value: string);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrchestratedVirtualMachineScaleSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#create OrchestratedVirtualMachineScaleSet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#delete OrchestratedVirtualMachineScaleSet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#read OrchestratedVirtualMachineScaleSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set#update OrchestratedVirtualMachineScaleSet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function orchestratedVirtualMachineScaleSetTimeoutsToTerraform(struct?: OrchestratedVirtualMachineScaleSetTimeoutsOutputReference | OrchestratedVirtualMachineScaleSetTimeouts): any;
/**
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrchestratedVirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrchestratedVirtualMachineScaleSetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set azurerm_orchestrated_virtual_machine_scale_set}.
 *
 * @stability stable
 */
export declare class OrchestratedVirtualMachineScaleSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set azurerm_orchestrated_virtual_machine_scale_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrchestratedVirtualMachineScaleSetConfig);
    private _encryptionAtHostEnabled?;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionAtHostEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    private _extensionsTimeBudget?;
    /**
     * @stability stable
     */
    get extensionsTimeBudget(): string;
    /**
     * @stability stable
     */
    set extensionsTimeBudget(value: string);
    /**
     * @stability stable
     */
    resetExtensionsTimeBudget(): void;
    /**
     * @stability stable
     */
    get extensionsTimeBudgetInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): number;
    /**
     * @stability stable
     */
    set instances(value: number);
    /**
     * @stability stable
     */
    resetInstances(): void;
    /**
     * @stability stable
     */
    get instancesInput(): number | undefined;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    /**
     * @stability stable
     */
    get maxBidPrice(): number;
    /**
     * @stability stable
     */
    set maxBidPrice(value: number);
    /**
     * @stability stable
     */
    resetMaxBidPrice(): void;
    /**
     * @stability stable
     */
    get maxBidPriceInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _platformFaultDomainCount?;
    /**
     * @stability stable
     */
    get platformFaultDomainCount(): number;
    /**
     * @stability stable
     */
    set platformFaultDomainCount(value: number);
    /**
     * @stability stable
     */
    get platformFaultDomainCountInput(): number | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    resetSkuName(): void;
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _sourceImageId?;
    /**
     * @stability stable
     */
    get sourceImageId(): string;
    /**
     * @stability stable
     */
    set sourceImageId(value: string);
    /**
     * @stability stable
     */
    resetSourceImageId(): void;
    /**
     * @stability stable
     */
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get uniqueId(): string;
    private _zoneBalance?;
    /**
     * @stability stable
     */
    get zoneBalance(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneBalance(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneBalance(): void;
    /**
     * @stability stable
     */
    get zoneBalanceInput(): boolean | cdktf.IResolvable | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _automaticInstanceRepair;
    /**
     * @stability stable
     */
    get automaticInstanceRepair(): OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairOutputReference;
    /**
     * @stability stable
     */
    putAutomaticInstanceRepair(value: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair): void;
    /**
     * @stability stable
     */
    resetAutomaticInstanceRepair(): void;
    /**
     * @stability stable
     */
    get automaticInstanceRepairInput(): OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    private _bootDiagnostics;
    /**
     * @stability stable
     */
    get bootDiagnostics(): OrchestratedVirtualMachineScaleSetBootDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putBootDiagnostics(value: OrchestratedVirtualMachineScaleSetBootDiagnostics): void;
    /**
     * @stability stable
     */
    resetBootDiagnostics(): void;
    /**
     * @stability stable
     */
    get bootDiagnosticsInput(): OrchestratedVirtualMachineScaleSetBootDiagnostics | undefined;
    private _dataDisk?;
    /**
     * @stability stable
     */
    get dataDisk(): OrchestratedVirtualMachineScaleSetDataDisk[];
    /**
     * @stability stable
     */
    set dataDisk(value: OrchestratedVirtualMachineScaleSetDataDisk[]);
    /**
     * @stability stable
     */
    resetDataDisk(): void;
    /**
     * @stability stable
     */
    get dataDiskInput(): OrchestratedVirtualMachineScaleSetDataDisk[] | undefined;
    private _extension?;
    /**
     * @stability stable
     */
    get extension(): OrchestratedVirtualMachineScaleSetExtension[];
    /**
     * @stability stable
     */
    set extension(value: OrchestratedVirtualMachineScaleSetExtension[]);
    /**
     * @stability stable
     */
    resetExtension(): void;
    /**
     * @stability stable
     */
    get extensionInput(): OrchestratedVirtualMachineScaleSetExtension[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): OrchestratedVirtualMachineScaleSetIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: OrchestratedVirtualMachineScaleSetIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): OrchestratedVirtualMachineScaleSetIdentity | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): OrchestratedVirtualMachineScaleSetNetworkInterface[];
    /**
     * @stability stable
     */
    set networkInterface(value: OrchestratedVirtualMachineScaleSetNetworkInterface[]);
    /**
     * @stability stable
     */
    resetNetworkInterface(): void;
    /**
     * @stability stable
     */
    get networkInterfaceInput(): OrchestratedVirtualMachineScaleSetNetworkInterface[] | undefined;
    private _osDisk;
    /**
     * @stability stable
     */
    get osDisk(): OrchestratedVirtualMachineScaleSetOsDiskOutputReference;
    /**
     * @stability stable
     */
    putOsDisk(value: OrchestratedVirtualMachineScaleSetOsDisk): void;
    /**
     * @stability stable
     */
    resetOsDisk(): void;
    /**
     * @stability stable
     */
    get osDiskInput(): OrchestratedVirtualMachineScaleSetOsDisk | undefined;
    private _osProfile;
    /**
     * @stability stable
     */
    get osProfile(): OrchestratedVirtualMachineScaleSetOsProfileOutputReference;
    /**
     * @stability stable
     */
    putOsProfile(value: OrchestratedVirtualMachineScaleSetOsProfile): void;
    /**
     * @stability stable
     */
    resetOsProfile(): void;
    /**
     * @stability stable
     */
    get osProfileInput(): OrchestratedVirtualMachineScaleSetOsProfile | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): OrchestratedVirtualMachineScaleSetPlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: OrchestratedVirtualMachineScaleSetPlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): OrchestratedVirtualMachineScaleSetPlan | undefined;
    private _sourceImageReference;
    /**
     * @stability stable
     */
    get sourceImageReference(): OrchestratedVirtualMachineScaleSetSourceImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putSourceImageReference(value: OrchestratedVirtualMachineScaleSetSourceImageReference): void;
    /**
     * @stability stable
     */
    resetSourceImageReference(): void;
    /**
     * @stability stable
     */
    get sourceImageReferenceInput(): OrchestratedVirtualMachineScaleSetSourceImageReference | undefined;
    private _terminationNotification;
    /**
     * @stability stable
     */
    get terminationNotification(): OrchestratedVirtualMachineScaleSetTerminationNotificationOutputReference;
    /**
     * @stability stable
     */
    putTerminationNotification(value: OrchestratedVirtualMachineScaleSetTerminationNotification): void;
    /**
     * @stability stable
     */
    resetTerminationNotification(): void;
    /**
     * @stability stable
     */
    get terminationNotificationInput(): OrchestratedVirtualMachineScaleSetTerminationNotification | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): OrchestratedVirtualMachineScaleSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: OrchestratedVirtualMachineScaleSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OrchestratedVirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
