import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PacketCaptureConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#maximum_bytes_per_packet PacketCapture#maximum_bytes_per_packet}.
     *
     * @stability stable
     */
    readonly maximumBytesPerPacket?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#maximum_bytes_per_session PacketCapture#maximum_bytes_per_session}.
     *
     * @stability stable
     */
    readonly maximumBytesPerSession?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#maximum_capture_duration PacketCapture#maximum_capture_duration}.
     *
     * @stability stable
     */
    readonly maximumCaptureDuration?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#name PacketCapture#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#network_watcher_name PacketCapture#network_watcher_name}.
     *
     * @stability stable
     */
    readonly networkWatcherName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#resource_group_name PacketCapture#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#target_resource_id PacketCapture#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#filter PacketCapture#filter}
     *
     * @stability stable
     */
    readonly filter?: PacketCaptureFilter[];
    /**
     * storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#storage_location PacketCapture#storage_location}
     *
     * @stability stable
     */
    readonly storageLocation: PacketCaptureStorageLocation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#timeouts PacketCapture#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PacketCaptureTimeouts;
}
/**
 * @stability stable
 */
export interface PacketCaptureFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#local_ip_address PacketCapture#local_ip_address}.
     *
     * @stability stable
     */
    readonly localIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#local_port PacketCapture#local_port}.
     *
     * @stability stable
     */
    readonly localPort?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#protocol PacketCapture#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#remote_ip_address PacketCapture#remote_ip_address}.
     *
     * @stability stable
     */
    readonly remoteIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#remote_port PacketCapture#remote_port}.
     *
     * @stability stable
     */
    readonly remotePort?: string;
}
export declare function packetCaptureFilterToTerraform(struct?: PacketCaptureFilter): any;
/**
 * @stability stable
 */
export interface PacketCaptureStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#file_path PacketCapture#file_path}.
     *
     * @stability stable
     */
    readonly filePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#storage_account_id PacketCapture#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
}
export declare function packetCaptureStorageLocationToTerraform(struct?: PacketCaptureStorageLocationOutputReference | PacketCaptureStorageLocation): any;
/**
 * @stability stable
 */
export declare class PacketCaptureStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PacketCaptureStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PacketCaptureStorageLocation | undefined);
    private _filePath?;
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    set filePath(value: string);
    /**
     * @stability stable
     */
    resetFilePath(): void;
    /**
     * @stability stable
     */
    get filePathInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PacketCaptureTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#create PacketCapture#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#delete PacketCapture#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#read PacketCapture#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#update PacketCapture#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function packetCaptureTimeoutsToTerraform(struct?: PacketCaptureTimeoutsOutputReference | PacketCaptureTimeouts): any;
/**
 * @stability stable
 */
export declare class PacketCaptureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PacketCaptureTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PacketCaptureTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture azurerm_packet_capture}.
 *
 * @stability stable
 */
export declare class PacketCapture extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture azurerm_packet_capture} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PacketCaptureConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _maximumBytesPerPacket?;
    /**
     * @stability stable
     */
    get maximumBytesPerPacket(): number;
    /**
     * @stability stable
     */
    set maximumBytesPerPacket(value: number);
    /**
     * @stability stable
     */
    resetMaximumBytesPerPacket(): void;
    /**
     * @stability stable
     */
    get maximumBytesPerPacketInput(): number | undefined;
    private _maximumBytesPerSession?;
    /**
     * @stability stable
     */
    get maximumBytesPerSession(): number;
    /**
     * @stability stable
     */
    set maximumBytesPerSession(value: number);
    /**
     * @stability stable
     */
    resetMaximumBytesPerSession(): void;
    /**
     * @stability stable
     */
    get maximumBytesPerSessionInput(): number | undefined;
    private _maximumCaptureDuration?;
    /**
     * @stability stable
     */
    get maximumCaptureDuration(): number;
    /**
     * @stability stable
     */
    set maximumCaptureDuration(value: number);
    /**
     * @stability stable
     */
    resetMaximumCaptureDuration(): void;
    /**
     * @stability stable
     */
    get maximumCaptureDurationInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkWatcherName?;
    /**
     * @stability stable
     */
    get networkWatcherName(): string;
    /**
     * @stability stable
     */
    set networkWatcherName(value: string);
    /**
     * @stability stable
     */
    get networkWatcherNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): PacketCaptureFilter[];
    /**
     * @stability stable
     */
    set filter(value: PacketCaptureFilter[]);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): PacketCaptureFilter[] | undefined;
    private _storageLocation;
    /**
     * @stability stable
     */
    get storageLocation(): PacketCaptureStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putStorageLocation(value: PacketCaptureStorageLocation): void;
    /**
     * @stability stable
     */
    get storageLocationInput(): PacketCaptureStorageLocation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PacketCaptureTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PacketCaptureTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PacketCaptureTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
