import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicyRemediationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#location_filters PolicyRemediation#location_filters}.
     *
     * @stability stable
     */
    readonly locationFilters?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#name PolicyRemediation#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#policy_assignment_id PolicyRemediation#policy_assignment_id}.
     *
     * @stability stable
     */
    readonly policyAssignmentId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#policy_definition_reference_id PolicyRemediation#policy_definition_reference_id}.
     *
     * @stability stable
     */
    readonly policyDefinitionReferenceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#resource_discovery_mode PolicyRemediation#resource_discovery_mode}.
     *
     * @stability stable
     */
    readonly resourceDiscoveryMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#scope PolicyRemediation#scope}.
     *
     * @stability stable
     */
    readonly scope: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#timeouts PolicyRemediation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PolicyRemediationTimeouts;
}
/**
 * @stability stable
 */
export interface PolicyRemediationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#create PolicyRemediation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#delete PolicyRemediation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#read PolicyRemediation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#update PolicyRemediation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function policyRemediationTimeoutsToTerraform(struct?: PolicyRemediationTimeoutsOutputReference | PolicyRemediationTimeouts): any;
/**
 * @stability stable
 */
export declare class PolicyRemediationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PolicyRemediationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PolicyRemediationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation azurerm_policy_remediation}.
 *
 * @stability stable
 */
export declare class PolicyRemediation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation azurerm_policy_remediation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicyRemediationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _locationFilters?;
    /**
     * @stability stable
     */
    get locationFilters(): string[];
    /**
     * @stability stable
     */
    set locationFilters(value: string[]);
    /**
     * @stability stable
     */
    resetLocationFilters(): void;
    /**
     * @stability stable
     */
    get locationFiltersInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _policyAssignmentId?;
    /**
     * @stability stable
     */
    get policyAssignmentId(): string;
    /**
     * @stability stable
     */
    set policyAssignmentId(value: string);
    /**
     * @stability stable
     */
    get policyAssignmentIdInput(): string | undefined;
    private _policyDefinitionReferenceId?;
    /**
     * @stability stable
     */
    get policyDefinitionReferenceId(): string;
    /**
     * @stability stable
     */
    set policyDefinitionReferenceId(value: string);
    /**
     * @stability stable
     */
    resetPolicyDefinitionReferenceId(): void;
    /**
     * @stability stable
     */
    get policyDefinitionReferenceIdInput(): string | undefined;
    private _resourceDiscoveryMode?;
    /**
     * @stability stable
     */
    get resourceDiscoveryMode(): string;
    /**
     * @stability stable
     */
    set resourceDiscoveryMode(value: string);
    /**
     * @stability stable
     */
    resetResourceDiscoveryMode(): void;
    /**
     * @stability stable
     */
    get resourceDiscoveryModeInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PolicyRemediationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PolicyRemediationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PolicyRemediationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
