import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicySetDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#description PolicySetDefinition#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#display_name PolicySetDefinition#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#management_group_id PolicySetDefinition#management_group_id}.
     *
     * @stability stable
     */
    readonly managementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#management_group_name PolicySetDefinition#management_group_name}.
     *
     * @stability stable
     */
    readonly managementGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#metadata PolicySetDefinition#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#name PolicySetDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#parameters PolicySetDefinition#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definitions PolicySetDefinition#policy_definitions}.
     *
     * @stability stable
     */
    readonly policyDefinitions?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_type PolicySetDefinition#policy_type}.
     *
     * @stability stable
     */
    readonly policyType: string;
    /**
     * policy_definition_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definition_group PolicySetDefinition#policy_definition_group}
     *
     * @stability stable
     */
    readonly policyDefinitionGroup?: PolicySetDefinitionPolicyDefinitionGroup[];
    /**
     * policy_definition_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definition_reference PolicySetDefinition#policy_definition_reference}
     *
     * @stability stable
     */
    readonly policyDefinitionReference?: PolicySetDefinitionPolicyDefinitionReference[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#timeouts PolicySetDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PolicySetDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface PolicySetDefinitionPolicyDefinitionGroup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#additional_metadata_resource_id PolicySetDefinition#additional_metadata_resource_id}.
     *
     * @stability stable
     */
    readonly additionalMetadataResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#category PolicySetDefinition#category}.
     *
     * @stability stable
     */
    readonly category?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#description PolicySetDefinition#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#display_name PolicySetDefinition#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#name PolicySetDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function policySetDefinitionPolicyDefinitionGroupToTerraform(struct?: PolicySetDefinitionPolicyDefinitionGroup): any;
/**
 * @stability stable
 */
export interface PolicySetDefinitionPolicyDefinitionReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#parameter_values PolicySetDefinition#parameter_values}.
     *
     * @stability stable
     */
    readonly parameterValues?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#parameters PolicySetDefinition#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definition_id PolicySetDefinition#policy_definition_id}.
     *
     * @stability stable
     */
    readonly policyDefinitionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_group_names PolicySetDefinition#policy_group_names}.
     *
     * @stability stable
     */
    readonly policyGroupNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#reference_id PolicySetDefinition#reference_id}.
     *
     * @stability stable
     */
    readonly referenceId?: string;
}
export declare function policySetDefinitionPolicyDefinitionReferenceToTerraform(struct?: PolicySetDefinitionPolicyDefinitionReference): any;
/**
 * @stability stable
 */
export interface PolicySetDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#create PolicySetDefinition#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#delete PolicySetDefinition#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#read PolicySetDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#update PolicySetDefinition#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function policySetDefinitionTimeoutsToTerraform(struct?: PolicySetDefinitionTimeoutsOutputReference | PolicySetDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class PolicySetDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PolicySetDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PolicySetDefinitionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition azurerm_policy_set_definition}.
 *
 * @stability stable
 */
export declare class PolicySetDefinition extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition azurerm_policy_set_definition} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicySetDefinitionConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _managementGroupId?;
    /**
     * @stability stable
     */
    get managementGroupId(): string;
    /**
     * @stability stable
     */
    set managementGroupId(value: string);
    /**
     * @stability stable
     */
    resetManagementGroupId(): void;
    /**
     * @stability stable
     */
    get managementGroupIdInput(): string | undefined;
    private _managementGroupName?;
    /**
     * @stability stable
     */
    get managementGroupName(): string;
    /**
     * @stability stable
     */
    set managementGroupName(value: string);
    /**
     * @stability stable
     */
    resetManagementGroupName(): void;
    /**
     * @stability stable
     */
    get managementGroupNameInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    set metadata(value: string);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): string;
    /**
     * @stability stable
     */
    set parameters(value: string);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): string | undefined;
    private _policyDefinitions?;
    /**
     * @stability stable
     */
    get policyDefinitions(): string;
    /**
     * @stability stable
     */
    set policyDefinitions(value: string);
    /**
     * @stability stable
     */
    resetPolicyDefinitions(): void;
    /**
     * @stability stable
     */
    get policyDefinitionsInput(): string | undefined;
    private _policyType?;
    /**
     * @stability stable
     */
    get policyType(): string;
    /**
     * @stability stable
     */
    set policyType(value: string);
    /**
     * @stability stable
     */
    get policyTypeInput(): string | undefined;
    private _policyDefinitionGroup?;
    /**
     * @stability stable
     */
    get policyDefinitionGroup(): PolicySetDefinitionPolicyDefinitionGroup[];
    /**
     * @stability stable
     */
    set policyDefinitionGroup(value: PolicySetDefinitionPolicyDefinitionGroup[]);
    /**
     * @stability stable
     */
    resetPolicyDefinitionGroup(): void;
    /**
     * @stability stable
     */
    get policyDefinitionGroupInput(): PolicySetDefinitionPolicyDefinitionGroup[] | undefined;
    private _policyDefinitionReference?;
    /**
     * @stability stable
     */
    get policyDefinitionReference(): PolicySetDefinitionPolicyDefinitionReference[];
    /**
     * @stability stable
     */
    set policyDefinitionReference(value: PolicySetDefinitionPolicyDefinitionReference[]);
    /**
     * @stability stable
     */
    resetPolicyDefinitionReference(): void;
    /**
     * @stability stable
     */
    get policyDefinitionReferenceInput(): PolicySetDefinitionPolicyDefinitionReference[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PolicySetDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PolicySetDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PolicySetDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
