import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RedisCacheConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#capacity RedisCache#capacity}.
     *
     * @stability stable
     */
    readonly capacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#enable_non_ssl_port RedisCache#enable_non_ssl_port}.
     *
     * @stability stable
     */
    readonly enableNonSslPort?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#family RedisCache#family}.
     *
     * @stability stable
     */
    readonly family: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#location RedisCache#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#minimum_tls_version RedisCache#minimum_tls_version}.
     *
     * @stability stable
     */
    readonly minimumTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#name RedisCache#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#private_static_ip_address RedisCache#private_static_ip_address}.
     *
     * @stability stable
     */
    readonly privateStaticIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#public_network_access_enabled RedisCache#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#redis_version RedisCache#redis_version}.
     *
     * @stability stable
     */
    readonly redisVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#replicas_per_master RedisCache#replicas_per_master}.
     *
     * @stability stable
     */
    readonly replicasPerMaster?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#replicas_per_primary RedisCache#replicas_per_primary}.
     *
     * @stability stable
     */
    readonly replicasPerPrimary?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#resource_group_name RedisCache#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#shard_count RedisCache#shard_count}.
     *
     * @stability stable
     */
    readonly shardCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#sku_name RedisCache#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#subnet_id RedisCache#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#tags RedisCache#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#tenant_settings RedisCache#tenant_settings}.
     *
     * @stability stable
     */
    readonly tenantSettings?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#zones RedisCache#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * patch_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#patch_schedule RedisCache#patch_schedule}
     *
     * @stability stable
     */
    readonly patchSchedule?: RedisCachePatchSchedule[];
    /**
     * redis_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#redis_configuration RedisCache#redis_configuration}
     *
     * @stability stable
     */
    readonly redisConfiguration?: RedisCacheRedisConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#timeouts RedisCache#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RedisCacheTimeouts;
}
/**
 * @stability stable
 */
export interface RedisCachePatchSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#day_of_week RedisCache#day_of_week}.
     *
     * @stability stable
     */
    readonly dayOfWeek: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#maintenance_window RedisCache#maintenance_window}.
     *
     * @stability stable
     */
    readonly maintenanceWindow?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#start_hour_utc RedisCache#start_hour_utc}.
     *
     * @stability stable
     */
    readonly startHourUtc?: number;
}
export declare function redisCachePatchScheduleToTerraform(struct?: RedisCachePatchSchedule): any;
/**
 * @stability stable
 */
export interface RedisCacheRedisConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#aof_backup_enabled RedisCache#aof_backup_enabled}.
     *
     * @stability stable
     */
    readonly aofBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#aof_storage_connection_string_0 RedisCache#aof_storage_connection_string_0}.
     *
     * @stability stable
     */
    readonly aofStorageConnectionString0?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#aof_storage_connection_string_1 RedisCache#aof_storage_connection_string_1}.
     *
     * @stability stable
     */
    readonly aofStorageConnectionString1?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#enable_authentication RedisCache#enable_authentication}.
     *
     * @stability stable
     */
    readonly enableAuthentication?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#maxfragmentationmemory_reserved RedisCache#maxfragmentationmemory_reserved}.
     *
     * @stability stable
     */
    readonly maxfragmentationmemoryReserved?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#maxmemory_delta RedisCache#maxmemory_delta}.
     *
     * @stability stable
     */
    readonly maxmemoryDelta?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#maxmemory_policy RedisCache#maxmemory_policy}.
     *
     * @stability stable
     */
    readonly maxmemoryPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#maxmemory_reserved RedisCache#maxmemory_reserved}.
     *
     * @stability stable
     */
    readonly maxmemoryReserved?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#notify_keyspace_events RedisCache#notify_keyspace_events}.
     *
     * @stability stable
     */
    readonly notifyKeyspaceEvents?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#rdb_backup_enabled RedisCache#rdb_backup_enabled}.
     *
     * @stability stable
     */
    readonly rdbBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#rdb_backup_frequency RedisCache#rdb_backup_frequency}.
     *
     * @stability stable
     */
    readonly rdbBackupFrequency?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#rdb_backup_max_snapshot_count RedisCache#rdb_backup_max_snapshot_count}.
     *
     * @stability stable
     */
    readonly rdbBackupMaxSnapshotCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#rdb_storage_connection_string RedisCache#rdb_storage_connection_string}.
     *
     * @stability stable
     */
    readonly rdbStorageConnectionString?: string;
}
export declare function redisCacheRedisConfigurationToTerraform(struct?: RedisCacheRedisConfigurationOutputReference | RedisCacheRedisConfiguration): any;
/**
 * @stability stable
 */
export declare class RedisCacheRedisConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RedisCacheRedisConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RedisCacheRedisConfiguration | undefined);
    private _aofBackupEnabled?;
    /**
     * @stability stable
     */
    get aofBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set aofBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAofBackupEnabled(): void;
    /**
     * @stability stable
     */
    get aofBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _aofStorageConnectionString0?;
    /**
     * @stability stable
     */
    get aofStorageConnectionString0(): string;
    /**
     * @stability stable
     */
    set aofStorageConnectionString0(value: string);
    /**
     * @stability stable
     */
    resetAofStorageConnectionString0(): void;
    /**
     * @stability stable
     */
    get aofStorageConnectionString0Input(): string | undefined;
    private _aofStorageConnectionString1?;
    /**
     * @stability stable
     */
    get aofStorageConnectionString1(): string;
    /**
     * @stability stable
     */
    set aofStorageConnectionString1(value: string);
    /**
     * @stability stable
     */
    resetAofStorageConnectionString1(): void;
    /**
     * @stability stable
     */
    get aofStorageConnectionString1Input(): string | undefined;
    private _enableAuthentication?;
    /**
     * @stability stable
     */
    get enableAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAuthentication(): void;
    /**
     * @stability stable
     */
    get enableAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _maxfragmentationmemoryReserved?;
    /**
     * @stability stable
     */
    get maxfragmentationmemoryReserved(): number;
    /**
     * @stability stable
     */
    set maxfragmentationmemoryReserved(value: number);
    /**
     * @stability stable
     */
    resetMaxfragmentationmemoryReserved(): void;
    /**
     * @stability stable
     */
    get maxfragmentationmemoryReservedInput(): number | undefined;
    private _maxmemoryDelta?;
    /**
     * @stability stable
     */
    get maxmemoryDelta(): number;
    /**
     * @stability stable
     */
    set maxmemoryDelta(value: number);
    /**
     * @stability stable
     */
    resetMaxmemoryDelta(): void;
    /**
     * @stability stable
     */
    get maxmemoryDeltaInput(): number | undefined;
    private _maxmemoryPolicy?;
    /**
     * @stability stable
     */
    get maxmemoryPolicy(): string;
    /**
     * @stability stable
     */
    set maxmemoryPolicy(value: string);
    /**
     * @stability stable
     */
    resetMaxmemoryPolicy(): void;
    /**
     * @stability stable
     */
    get maxmemoryPolicyInput(): string | undefined;
    private _maxmemoryReserved?;
    /**
     * @stability stable
     */
    get maxmemoryReserved(): number;
    /**
     * @stability stable
     */
    set maxmemoryReserved(value: number);
    /**
     * @stability stable
     */
    resetMaxmemoryReserved(): void;
    /**
     * @stability stable
     */
    get maxmemoryReservedInput(): number | undefined;
    private _notifyKeyspaceEvents?;
    /**
     * @stability stable
     */
    get notifyKeyspaceEvents(): string;
    /**
     * @stability stable
     */
    set notifyKeyspaceEvents(value: string);
    /**
     * @stability stable
     */
    resetNotifyKeyspaceEvents(): void;
    /**
     * @stability stable
     */
    get notifyKeyspaceEventsInput(): string | undefined;
    private _rdbBackupEnabled?;
    /**
     * @stability stable
     */
    get rdbBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rdbBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRdbBackupEnabled(): void;
    /**
     * @stability stable
     */
    get rdbBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rdbBackupFrequency?;
    /**
     * @stability stable
     */
    get rdbBackupFrequency(): number;
    /**
     * @stability stable
     */
    set rdbBackupFrequency(value: number);
    /**
     * @stability stable
     */
    resetRdbBackupFrequency(): void;
    /**
     * @stability stable
     */
    get rdbBackupFrequencyInput(): number | undefined;
    private _rdbBackupMaxSnapshotCount?;
    /**
     * @stability stable
     */
    get rdbBackupMaxSnapshotCount(): number;
    /**
     * @stability stable
     */
    set rdbBackupMaxSnapshotCount(value: number);
    /**
     * @stability stable
     */
    resetRdbBackupMaxSnapshotCount(): void;
    /**
     * @stability stable
     */
    get rdbBackupMaxSnapshotCountInput(): number | undefined;
    private _rdbStorageConnectionString?;
    /**
     * @stability stable
     */
    get rdbStorageConnectionString(): string;
    /**
     * @stability stable
     */
    set rdbStorageConnectionString(value: string);
    /**
     * @stability stable
     */
    resetRdbStorageConnectionString(): void;
    /**
     * @stability stable
     */
    get rdbStorageConnectionStringInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RedisCacheTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#create RedisCache#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#delete RedisCache#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#read RedisCache#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache#update RedisCache#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function redisCacheTimeoutsToTerraform(struct?: RedisCacheTimeoutsOutputReference | RedisCacheTimeouts): any;
/**
 * @stability stable
 */
export declare class RedisCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RedisCacheTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RedisCacheTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache azurerm_redis_cache}.
 *
 * @stability stable
 */
export declare class RedisCache extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/redis_cache azurerm_redis_cache} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RedisCacheConfig);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _enableNonSslPort?;
    /**
     * @stability stable
     */
    get enableNonSslPort(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableNonSslPort(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableNonSslPort(): void;
    /**
     * @stability stable
     */
    get enableNonSslPortInput(): boolean | cdktf.IResolvable | undefined;
    private _family?;
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    set family(value: string);
    /**
     * @stability stable
     */
    get familyInput(): string | undefined;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _minimumTlsVersion?;
    /**
     * @stability stable
     */
    get minimumTlsVersion(): string;
    /**
     * @stability stable
     */
    set minimumTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinimumTlsVersion(): void;
    /**
     * @stability stable
     */
    get minimumTlsVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    private _privateStaticIpAddress?;
    /**
     * @stability stable
     */
    get privateStaticIpAddress(): string;
    /**
     * @stability stable
     */
    set privateStaticIpAddress(value: string);
    /**
     * @stability stable
     */
    resetPrivateStaticIpAddress(): void;
    /**
     * @stability stable
     */
    get privateStaticIpAddressInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _redisVersion?;
    /**
     * @stability stable
     */
    get redisVersion(): string;
    /**
     * @stability stable
     */
    set redisVersion(value: string);
    /**
     * @stability stable
     */
    resetRedisVersion(): void;
    /**
     * @stability stable
     */
    get redisVersionInput(): string | undefined;
    private _replicasPerMaster?;
    /**
     * @stability stable
     */
    get replicasPerMaster(): number;
    /**
     * @stability stable
     */
    set replicasPerMaster(value: number);
    /**
     * @stability stable
     */
    resetReplicasPerMaster(): void;
    /**
     * @stability stable
     */
    get replicasPerMasterInput(): number | undefined;
    private _replicasPerPrimary?;
    /**
     * @stability stable
     */
    get replicasPerPrimary(): number;
    /**
     * @stability stable
     */
    set replicasPerPrimary(value: number);
    /**
     * @stability stable
     */
    resetReplicasPerPrimary(): void;
    /**
     * @stability stable
     */
    get replicasPerPrimaryInput(): number | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    private _shardCount?;
    /**
     * @stability stable
     */
    get shardCount(): number;
    /**
     * @stability stable
     */
    set shardCount(value: number);
    /**
     * @stability stable
     */
    resetShardCount(): void;
    /**
     * @stability stable
     */
    get shardCountInput(): number | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sslPort(): number;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tenantSettings?;
    /**
     * @stability stable
     */
    get tenantSettings(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tenantSettings(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTenantSettings(): void;
    /**
     * @stability stable
     */
    get tenantSettingsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _patchSchedule?;
    /**
     * @stability stable
     */
    get patchSchedule(): RedisCachePatchSchedule[];
    /**
     * @stability stable
     */
    set patchSchedule(value: RedisCachePatchSchedule[]);
    /**
     * @stability stable
     */
    resetPatchSchedule(): void;
    /**
     * @stability stable
     */
    get patchScheduleInput(): RedisCachePatchSchedule[] | undefined;
    private _redisConfiguration;
    /**
     * @stability stable
     */
    get redisConfiguration(): RedisCacheRedisConfigurationOutputReference;
    /**
     * @stability stable
     */
    putRedisConfiguration(value: RedisCacheRedisConfiguration): void;
    /**
     * @stability stable
     */
    resetRedisConfiguration(): void;
    /**
     * @stability stable
     */
    get redisConfigurationInput(): RedisCacheRedisConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RedisCacheTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RedisCacheTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RedisCacheTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
