import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#condition RoleAssignment#condition}.
     *
     * @stability stable
     */
    readonly condition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#condition_version RoleAssignment#condition_version}.
     *
     * @stability stable
     */
    readonly conditionVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#delegated_managed_identity_resource_id RoleAssignment#delegated_managed_identity_resource_id}.
     *
     * @stability stable
     */
    readonly delegatedManagedIdentityResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#description RoleAssignment#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#name RoleAssignment#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#principal_id RoleAssignment#principal_id}.
     *
     * @stability stable
     */
    readonly principalId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#role_definition_id RoleAssignment#role_definition_id}.
     *
     * @stability stable
     */
    readonly roleDefinitionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#role_definition_name RoleAssignment#role_definition_name}.
     *
     * @stability stable
     */
    readonly roleDefinitionName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#scope RoleAssignment#scope}.
     *
     * @stability stable
     */
    readonly scope: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#skip_service_principal_aad_check RoleAssignment#skip_service_principal_aad_check}.
     *
     * @stability stable
     */
    readonly skipServicePrincipalAadCheck?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#timeouts RoleAssignment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RoleAssignmentTimeouts;
}
/**
 * @stability stable
 */
export interface RoleAssignmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#create RoleAssignment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#delete RoleAssignment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#read RoleAssignment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment#update RoleAssignment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function roleAssignmentTimeoutsToTerraform(struct?: RoleAssignmentTimeoutsOutputReference | RoleAssignmentTimeouts): any;
/**
 * @stability stable
 */
export declare class RoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RoleAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RoleAssignmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment azurerm_role_assignment}.
 *
 * @stability stable
 */
export declare class RoleAssignment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/role_assignment azurerm_role_assignment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RoleAssignmentConfig);
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): string;
    /**
     * @stability stable
     */
    set condition(value: string);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): string | undefined;
    private _conditionVersion?;
    /**
     * @stability stable
     */
    get conditionVersion(): string;
    /**
     * @stability stable
     */
    set conditionVersion(value: string);
    /**
     * @stability stable
     */
    resetConditionVersion(): void;
    /**
     * @stability stable
     */
    get conditionVersionInput(): string | undefined;
    private _delegatedManagedIdentityResourceId?;
    /**
     * @stability stable
     */
    get delegatedManagedIdentityResourceId(): string;
    /**
     * @stability stable
     */
    set delegatedManagedIdentityResourceId(value: string);
    /**
     * @stability stable
     */
    resetDelegatedManagedIdentityResourceId(): void;
    /**
     * @stability stable
     */
    get delegatedManagedIdentityResourceIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _principalId?;
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    set principalId(value: string);
    /**
     * @stability stable
     */
    get principalIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get principalType(): string;
    private _roleDefinitionId?;
    /**
     * @stability stable
     */
    get roleDefinitionId(): string;
    /**
     * @stability stable
     */
    set roleDefinitionId(value: string);
    /**
     * @stability stable
     */
    resetRoleDefinitionId(): void;
    /**
     * @stability stable
     */
    get roleDefinitionIdInput(): string | undefined;
    private _roleDefinitionName?;
    /**
     * @stability stable
     */
    get roleDefinitionName(): string;
    /**
     * @stability stable
     */
    set roleDefinitionName(value: string);
    /**
     * @stability stable
     */
    resetRoleDefinitionName(): void;
    /**
     * @stability stable
     */
    get roleDefinitionNameInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _skipServicePrincipalAadCheck?;
    /**
     * @stability stable
     */
    get skipServicePrincipalAadCheck(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipServicePrincipalAadCheck(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipServicePrincipalAadCheck(): void;
    /**
     * @stability stable
     */
    get skipServicePrincipalAadCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RoleAssignmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RoleAssignmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RoleAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
