import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceFabricMeshApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#location ServiceFabricMeshApplication#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#name ServiceFabricMeshApplication#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#resource_group_name ServiceFabricMeshApplication#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#tags ServiceFabricMeshApplication#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#service ServiceFabricMeshApplication#service}
     *
     * @stability stable
     */
    readonly service: ServiceFabricMeshApplicationService[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#timeouts ServiceFabricMeshApplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceFabricMeshApplicationTimeouts;
}
/**
 * @stability stable
 */
export interface ServiceFabricMeshApplicationServiceCodePackageResourcesLimits {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#cpu ServiceFabricMeshApplication#cpu}.
     *
     * @stability stable
     */
    readonly cpu: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#memory ServiceFabricMeshApplication#memory}.
     *
     * @stability stable
     */
    readonly memory: number;
}
export declare function serviceFabricMeshApplicationServiceCodePackageResourcesLimitsToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackageResourcesLimitsOutputReference | ServiceFabricMeshApplicationServiceCodePackageResourcesLimits): any;
/**
 * @stability stable
 */
export declare class ServiceFabricMeshApplicationServiceCodePackageResourcesLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricMeshApplicationServiceCodePackageResourcesLimits | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricMeshApplicationServiceCodePackageResourcesLimits | undefined);
    private _cpu?;
    /**
     * @stability stable
     */
    get cpu(): number;
    /**
     * @stability stable
     */
    set cpu(value: number);
    /**
     * @stability stable
     */
    get cpuInput(): number | undefined;
    private _memory?;
    /**
     * @stability stable
     */
    get memory(): number;
    /**
     * @stability stable
     */
    set memory(value: number);
    /**
     * @stability stable
     */
    get memoryInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricMeshApplicationServiceCodePackageResourcesRequests {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#cpu ServiceFabricMeshApplication#cpu}.
     *
     * @stability stable
     */
    readonly cpu: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#memory ServiceFabricMeshApplication#memory}.
     *
     * @stability stable
     */
    readonly memory: number;
}
export declare function serviceFabricMeshApplicationServiceCodePackageResourcesRequestsToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackageResourcesRequestsOutputReference | ServiceFabricMeshApplicationServiceCodePackageResourcesRequests): any;
/**
 * @stability stable
 */
export declare class ServiceFabricMeshApplicationServiceCodePackageResourcesRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricMeshApplicationServiceCodePackageResourcesRequests | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricMeshApplicationServiceCodePackageResourcesRequests | undefined);
    private _cpu?;
    /**
     * @stability stable
     */
    get cpu(): number;
    /**
     * @stability stable
     */
    set cpu(value: number);
    /**
     * @stability stable
     */
    get cpuInput(): number | undefined;
    private _memory?;
    /**
     * @stability stable
     */
    get memory(): number;
    /**
     * @stability stable
     */
    set memory(value: number);
    /**
     * @stability stable
     */
    get memoryInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricMeshApplicationServiceCodePackageResources {
    /**
     * limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#limits ServiceFabricMeshApplication#limits}
     *
     * @stability stable
     */
    readonly limits?: ServiceFabricMeshApplicationServiceCodePackageResourcesLimits;
    /**
     * requests block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#requests ServiceFabricMeshApplication#requests}
     *
     * @stability stable
     */
    readonly requests: ServiceFabricMeshApplicationServiceCodePackageResourcesRequests;
}
export declare function serviceFabricMeshApplicationServiceCodePackageResourcesToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackageResourcesOutputReference | ServiceFabricMeshApplicationServiceCodePackageResources): any;
/**
 * @stability stable
 */
export declare class ServiceFabricMeshApplicationServiceCodePackageResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricMeshApplicationServiceCodePackageResources | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricMeshApplicationServiceCodePackageResources | undefined);
    private _limits;
    /**
     * @stability stable
     */
    get limits(): ServiceFabricMeshApplicationServiceCodePackageResourcesLimitsOutputReference;
    /**
     * @stability stable
     */
    putLimits(value: ServiceFabricMeshApplicationServiceCodePackageResourcesLimits): void;
    /**
     * @stability stable
     */
    resetLimits(): void;
    /**
     * @stability stable
     */
    get limitsInput(): ServiceFabricMeshApplicationServiceCodePackageResourcesLimits | undefined;
    private _requests;
    /**
     * @stability stable
     */
    get requests(): ServiceFabricMeshApplicationServiceCodePackageResourcesRequestsOutputReference;
    /**
     * @stability stable
     */
    putRequests(value: ServiceFabricMeshApplicationServiceCodePackageResourcesRequests): void;
    /**
     * @stability stable
     */
    get requestsInput(): ServiceFabricMeshApplicationServiceCodePackageResourcesRequests | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricMeshApplicationServiceCodePackage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#image_name ServiceFabricMeshApplication#image_name}.
     *
     * @stability stable
     */
    readonly imageName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#name ServiceFabricMeshApplication#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#resources ServiceFabricMeshApplication#resources}
     *
     * @stability stable
     */
    readonly resources: ServiceFabricMeshApplicationServiceCodePackageResources;
}
export declare function serviceFabricMeshApplicationServiceCodePackageToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackage): any;
/**
 * @stability stable
 */
export interface ServiceFabricMeshApplicationService {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#name ServiceFabricMeshApplication#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#os_type ServiceFabricMeshApplication#os_type}.
     *
     * @stability stable
     */
    readonly osType: string;
    /**
     * code_package block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#code_package ServiceFabricMeshApplication#code_package}
     *
     * @stability stable
     */
    readonly codePackage: ServiceFabricMeshApplicationServiceCodePackage[];
}
export declare function serviceFabricMeshApplicationServiceToTerraform(struct?: ServiceFabricMeshApplicationService): any;
/**
 * @stability stable
 */
export interface ServiceFabricMeshApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#create ServiceFabricMeshApplication#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#delete ServiceFabricMeshApplication#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#read ServiceFabricMeshApplication#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#update ServiceFabricMeshApplication#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function serviceFabricMeshApplicationTimeoutsToTerraform(struct?: ServiceFabricMeshApplicationTimeoutsOutputReference | ServiceFabricMeshApplicationTimeouts): any;
/**
 * @stability stable
 */
export declare class ServiceFabricMeshApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricMeshApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricMeshApplicationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application azurerm_service_fabric_mesh_application}.
 *
 * @stability stable
 */
export declare class ServiceFabricMeshApplication extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application azurerm_service_fabric_mesh_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceFabricMeshApplicationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): ServiceFabricMeshApplicationService[];
    /**
     * @stability stable
     */
    set service(value: ServiceFabricMeshApplicationService[]);
    /**
     * @stability stable
     */
    get serviceInput(): ServiceFabricMeshApplicationService[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServiceFabricMeshApplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServiceFabricMeshApplicationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceFabricMeshApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
