import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicebusNamespaceNetworkRuleSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#default_action ServicebusNamespaceNetworkRuleSet#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#ip_rules ServicebusNamespaceNetworkRuleSet#ip_rules}.
     *
     * @stability stable
     */
    readonly ipRules?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#namespace_id ServicebusNamespaceNetworkRuleSet#namespace_id}.
     *
     * @stability stable
     */
    readonly namespaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#namespace_name ServicebusNamespaceNetworkRuleSet#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#public_network_access_enabled ServicebusNamespaceNetworkRuleSet#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#resource_group_name ServicebusNamespaceNetworkRuleSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#trusted_services_allowed ServicebusNamespaceNetworkRuleSet#trusted_services_allowed}.
     *
     * @stability stable
     */
    readonly trustedServicesAllowed?: boolean | cdktf.IResolvable;
    /**
     * network_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#network_rules ServicebusNamespaceNetworkRuleSet#network_rules}
     *
     * @stability stable
     */
    readonly networkRules?: ServicebusNamespaceNetworkRuleSetNetworkRules[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#timeouts ServicebusNamespaceNetworkRuleSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicebusNamespaceNetworkRuleSetTimeouts;
}
/**
 * @stability stable
 */
export interface ServicebusNamespaceNetworkRuleSetNetworkRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#ignore_missing_vnet_service_endpoint ServicebusNamespaceNetworkRuleSet#ignore_missing_vnet_service_endpoint}.
     *
     * @stability stable
     */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#subnet_id ServicebusNamespaceNetworkRuleSet#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function servicebusNamespaceNetworkRuleSetNetworkRulesToTerraform(struct?: ServicebusNamespaceNetworkRuleSetNetworkRules): any;
/**
 * @stability stable
 */
export interface ServicebusNamespaceNetworkRuleSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#create ServicebusNamespaceNetworkRuleSet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#delete ServicebusNamespaceNetworkRuleSet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#read ServicebusNamespaceNetworkRuleSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set#update ServicebusNamespaceNetworkRuleSet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicebusNamespaceNetworkRuleSetTimeoutsToTerraform(struct?: ServicebusNamespaceNetworkRuleSetTimeoutsOutputReference | ServicebusNamespaceNetworkRuleSetTimeouts): any;
/**
 * @stability stable
 */
export declare class ServicebusNamespaceNetworkRuleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusNamespaceNetworkRuleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusNamespaceNetworkRuleSetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set azurerm_servicebus_namespace_network_rule_set}.
 *
 * @stability stable
 */
export declare class ServicebusNamespaceNetworkRuleSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_network_rule_set azurerm_servicebus_namespace_network_rule_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: ServicebusNamespaceNetworkRuleSetConfig);
    private _defaultAction?;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    set defaultAction(value: string);
    /**
     * @stability stable
     */
    resetDefaultAction(): void;
    /**
     * @stability stable
     */
    get defaultActionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipRules?;
    /**
     * @stability stable
     */
    get ipRules(): string[];
    /**
     * @stability stable
     */
    set ipRules(value: string[]);
    /**
     * @stability stable
     */
    resetIpRules(): void;
    /**
     * @stability stable
     */
    get ipRulesInput(): string[] | undefined;
    private _namespaceId?;
    /**
     * @stability stable
     */
    get namespaceId(): string;
    /**
     * @stability stable
     */
    set namespaceId(value: string);
    /**
     * @stability stable
     */
    resetNamespaceId(): void;
    /**
     * @stability stable
     */
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    resetNamespaceName(): void;
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetResourceGroupName(): void;
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _trustedServicesAllowed?;
    /**
     * @stability stable
     */
    get trustedServicesAllowed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set trustedServicesAllowed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTrustedServicesAllowed(): void;
    /**
     * @stability stable
     */
    get trustedServicesAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _networkRules?;
    /**
     * @stability stable
     */
    get networkRules(): ServicebusNamespaceNetworkRuleSetNetworkRules[];
    /**
     * @stability stable
     */
    set networkRules(value: ServicebusNamespaceNetworkRuleSetNetworkRules[]);
    /**
     * @stability stable
     */
    resetNetworkRules(): void;
    /**
     * @stability stable
     */
    get networkRulesInput(): ServicebusNamespaceNetworkRuleSetNetworkRules[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicebusNamespaceNetworkRuleSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicebusNamespaceNetworkRuleSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicebusNamespaceNetworkRuleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
