import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicebusQueueConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#auto_delete_on_idle ServicebusQueue#auto_delete_on_idle}.
     *
     * @stability stable
     */
    readonly autoDeleteOnIdle?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#dead_lettering_on_message_expiration ServicebusQueue#dead_lettering_on_message_expiration}.
     *
     * @stability stable
     */
    readonly deadLetteringOnMessageExpiration?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#default_message_ttl ServicebusQueue#default_message_ttl}.
     *
     * @stability stable
     */
    readonly defaultMessageTtl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#duplicate_detection_history_time_window ServicebusQueue#duplicate_detection_history_time_window}.
     *
     * @stability stable
     */
    readonly duplicateDetectionHistoryTimeWindow?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#enable_batched_operations ServicebusQueue#enable_batched_operations}.
     *
     * @stability stable
     */
    readonly enableBatchedOperations?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#enable_express ServicebusQueue#enable_express}.
     *
     * @stability stable
     */
    readonly enableExpress?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#enable_partitioning ServicebusQueue#enable_partitioning}.
     *
     * @stability stable
     */
    readonly enablePartitioning?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#forward_dead_lettered_messages_to ServicebusQueue#forward_dead_lettered_messages_to}.
     *
     * @stability stable
     */
    readonly forwardDeadLetteredMessagesTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#forward_to ServicebusQueue#forward_to}.
     *
     * @stability stable
     */
    readonly forwardTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#lock_duration ServicebusQueue#lock_duration}.
     *
     * @stability stable
     */
    readonly lockDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#max_delivery_count ServicebusQueue#max_delivery_count}.
     *
     * @stability stable
     */
    readonly maxDeliveryCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#max_message_size_in_kilobytes ServicebusQueue#max_message_size_in_kilobytes}.
     *
     * @stability stable
     */
    readonly maxMessageSizeInKilobytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#max_size_in_megabytes ServicebusQueue#max_size_in_megabytes}.
     *
     * @stability stable
     */
    readonly maxSizeInMegabytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#name ServicebusQueue#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#namespace_id ServicebusQueue#namespace_id}.
     *
     * @stability stable
     */
    readonly namespaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#namespace_name ServicebusQueue#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#requires_duplicate_detection ServicebusQueue#requires_duplicate_detection}.
     *
     * @stability stable
     */
    readonly requiresDuplicateDetection?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#requires_session ServicebusQueue#requires_session}.
     *
     * @stability stable
     */
    readonly requiresSession?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#resource_group_name ServicebusQueue#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#status ServicebusQueue#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#timeouts ServicebusQueue#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicebusQueueTimeouts;
}
/**
 * @stability stable
 */
export interface ServicebusQueueTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#create ServicebusQueue#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#delete ServicebusQueue#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#read ServicebusQueue#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#update ServicebusQueue#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicebusQueueTimeoutsToTerraform(struct?: ServicebusQueueTimeoutsOutputReference | ServicebusQueueTimeouts): any;
/**
 * @stability stable
 */
export declare class ServicebusQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusQueueTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusQueueTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue azurerm_servicebus_queue}.
 *
 * @stability stable
 */
export declare class ServicebusQueue extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue azurerm_servicebus_queue} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicebusQueueConfig);
    private _autoDeleteOnIdle?;
    /**
     * @stability stable
     */
    get autoDeleteOnIdle(): string;
    /**
     * @stability stable
     */
    set autoDeleteOnIdle(value: string);
    /**
     * @stability stable
     */
    resetAutoDeleteOnIdle(): void;
    /**
     * @stability stable
     */
    get autoDeleteOnIdleInput(): string | undefined;
    private _deadLetteringOnMessageExpiration?;
    /**
     * @stability stable
     */
    get deadLetteringOnMessageExpiration(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deadLetteringOnMessageExpiration(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeadLetteringOnMessageExpiration(): void;
    /**
     * @stability stable
     */
    get deadLetteringOnMessageExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultMessageTtl?;
    /**
     * @stability stable
     */
    get defaultMessageTtl(): string;
    /**
     * @stability stable
     */
    set defaultMessageTtl(value: string);
    /**
     * @stability stable
     */
    resetDefaultMessageTtl(): void;
    /**
     * @stability stable
     */
    get defaultMessageTtlInput(): string | undefined;
    private _duplicateDetectionHistoryTimeWindow?;
    /**
     * @stability stable
     */
    get duplicateDetectionHistoryTimeWindow(): string;
    /**
     * @stability stable
     */
    set duplicateDetectionHistoryTimeWindow(value: string);
    /**
     * @stability stable
     */
    resetDuplicateDetectionHistoryTimeWindow(): void;
    /**
     * @stability stable
     */
    get duplicateDetectionHistoryTimeWindowInput(): string | undefined;
    private _enableBatchedOperations?;
    /**
     * @stability stable
     */
    get enableBatchedOperations(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBatchedOperations(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBatchedOperations(): void;
    /**
     * @stability stable
     */
    get enableBatchedOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableExpress?;
    /**
     * @stability stable
     */
    get enableExpress(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableExpress(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableExpress(): void;
    /**
     * @stability stable
     */
    get enableExpressInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePartitioning?;
    /**
     * @stability stable
     */
    get enablePartitioning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePartitioning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnablePartitioning(): void;
    /**
     * @stability stable
     */
    get enablePartitioningInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardDeadLetteredMessagesTo?;
    /**
     * @stability stable
     */
    get forwardDeadLetteredMessagesTo(): string;
    /**
     * @stability stable
     */
    set forwardDeadLetteredMessagesTo(value: string);
    /**
     * @stability stable
     */
    resetForwardDeadLetteredMessagesTo(): void;
    /**
     * @stability stable
     */
    get forwardDeadLetteredMessagesToInput(): string | undefined;
    private _forwardTo?;
    /**
     * @stability stable
     */
    get forwardTo(): string;
    /**
     * @stability stable
     */
    set forwardTo(value: string);
    /**
     * @stability stable
     */
    resetForwardTo(): void;
    /**
     * @stability stable
     */
    get forwardToInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _lockDuration?;
    /**
     * @stability stable
     */
    get lockDuration(): string;
    /**
     * @stability stable
     */
    set lockDuration(value: string);
    /**
     * @stability stable
     */
    resetLockDuration(): void;
    /**
     * @stability stable
     */
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    /**
     * @stability stable
     */
    get maxDeliveryCount(): number;
    /**
     * @stability stable
     */
    set maxDeliveryCount(value: number);
    /**
     * @stability stable
     */
    resetMaxDeliveryCount(): void;
    /**
     * @stability stable
     */
    get maxDeliveryCountInput(): number | undefined;
    private _maxMessageSizeInKilobytes?;
    /**
     * @stability stable
     */
    get maxMessageSizeInKilobytes(): number;
    /**
     * @stability stable
     */
    set maxMessageSizeInKilobytes(value: number);
    /**
     * @stability stable
     */
    resetMaxMessageSizeInKilobytes(): void;
    /**
     * @stability stable
     */
    get maxMessageSizeInKilobytesInput(): number | undefined;
    private _maxSizeInMegabytes?;
    /**
     * @stability stable
     */
    get maxSizeInMegabytes(): number;
    /**
     * @stability stable
     */
    set maxSizeInMegabytes(value: number);
    /**
     * @stability stable
     */
    resetMaxSizeInMegabytes(): void;
    /**
     * @stability stable
     */
    get maxSizeInMegabytesInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceId?;
    /**
     * @stability stable
     */
    get namespaceId(): string;
    /**
     * @stability stable
     */
    set namespaceId(value: string);
    /**
     * @stability stable
     */
    resetNamespaceId(): void;
    /**
     * @stability stable
     */
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    resetNamespaceName(): void;
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _requiresDuplicateDetection?;
    /**
     * @stability stable
     */
    get requiresDuplicateDetection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requiresDuplicateDetection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequiresDuplicateDetection(): void;
    /**
     * @stability stable
     */
    get requiresDuplicateDetectionInput(): boolean | cdktf.IResolvable | undefined;
    private _requiresSession?;
    /**
     * @stability stable
     */
    get requiresSession(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requiresSession(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequiresSession(): void;
    /**
     * @stability stable
     */
    get requiresSessionInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetResourceGroupName(): void;
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicebusQueueTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicebusQueueTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicebusQueueTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
