import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SharedImageVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#exclude_from_latest SharedImageVersion#exclude_from_latest}.
     *
     * @stability stable
     */
    readonly excludeFromLatest?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#gallery_name SharedImageVersion#gallery_name}.
     *
     * @stability stable
     */
    readonly galleryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#image_name SharedImageVersion#image_name}.
     *
     * @stability stable
     */
    readonly imageName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#location SharedImageVersion#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#managed_image_id SharedImageVersion#managed_image_id}.
     *
     * @stability stable
     */
    readonly managedImageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#name SharedImageVersion#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#os_disk_snapshot_id SharedImageVersion#os_disk_snapshot_id}.
     *
     * @stability stable
     */
    readonly osDiskSnapshotId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#resource_group_name SharedImageVersion#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#tags SharedImageVersion#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * target_region block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#target_region SharedImageVersion#target_region}
     *
     * @stability stable
     */
    readonly targetRegion: SharedImageVersionTargetRegion[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#timeouts SharedImageVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SharedImageVersionTimeouts;
}
/**
 * @stability stable
 */
export interface SharedImageVersionTargetRegion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#name SharedImageVersion#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#regional_replica_count SharedImageVersion#regional_replica_count}.
     *
     * @stability stable
     */
    readonly regionalReplicaCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#storage_account_type SharedImageVersion#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType?: string;
}
export declare function sharedImageVersionTargetRegionToTerraform(struct?: SharedImageVersionTargetRegion): any;
/**
 * @stability stable
 */
export interface SharedImageVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#create SharedImageVersion#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#delete SharedImageVersion#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#read SharedImageVersion#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version#update SharedImageVersion#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sharedImageVersionTimeoutsToTerraform(struct?: SharedImageVersionTimeoutsOutputReference | SharedImageVersionTimeouts): any;
/**
 * @stability stable
 */
export declare class SharedImageVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SharedImageVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SharedImageVersionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version azurerm_shared_image_version}.
 *
 * @stability stable
 */
export declare class SharedImageVersion extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image_version azurerm_shared_image_version} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SharedImageVersionConfig);
    private _excludeFromLatest?;
    /**
     * @stability stable
     */
    get excludeFromLatest(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set excludeFromLatest(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExcludeFromLatest(): void;
    /**
     * @stability stable
     */
    get excludeFromLatestInput(): boolean | cdktf.IResolvable | undefined;
    private _galleryName?;
    /**
     * @stability stable
     */
    get galleryName(): string;
    /**
     * @stability stable
     */
    set galleryName(value: string);
    /**
     * @stability stable
     */
    get galleryNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageName?;
    /**
     * @stability stable
     */
    get imageName(): string;
    /**
     * @stability stable
     */
    set imageName(value: string);
    /**
     * @stability stable
     */
    get imageNameInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _managedImageId?;
    /**
     * @stability stable
     */
    get managedImageId(): string;
    /**
     * @stability stable
     */
    set managedImageId(value: string);
    /**
     * @stability stable
     */
    resetManagedImageId(): void;
    /**
     * @stability stable
     */
    get managedImageIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osDiskSnapshotId?;
    /**
     * @stability stable
     */
    get osDiskSnapshotId(): string;
    /**
     * @stability stable
     */
    set osDiskSnapshotId(value: string);
    /**
     * @stability stable
     */
    resetOsDiskSnapshotId(): void;
    /**
     * @stability stable
     */
    get osDiskSnapshotIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _targetRegion?;
    /**
     * @stability stable
     */
    get targetRegion(): SharedImageVersionTargetRegion[];
    /**
     * @stability stable
     */
    set targetRegion(value: SharedImageVersionTargetRegion[]);
    /**
     * @stability stable
     */
    get targetRegionInput(): SharedImageVersionTargetRegion[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SharedImageVersionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SharedImageVersionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SharedImageVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
