import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SignalrServiceNetworkAclConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#default_action SignalrServiceNetworkAcl#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#signalr_service_id SignalrServiceNetworkAcl#signalr_service_id}.
     *
     * @stability stable
     */
    readonly signalrServiceId: string;
    /**
     * private_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#private_endpoint SignalrServiceNetworkAcl#private_endpoint}
     *
     * @stability stable
     */
    readonly privateEndpoint?: SignalrServiceNetworkAclPrivateEndpoint[];
    /**
     * public_network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#public_network SignalrServiceNetworkAcl#public_network}
     *
     * @stability stable
     */
    readonly publicNetwork: SignalrServiceNetworkAclPublicNetwork;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#timeouts SignalrServiceNetworkAcl#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SignalrServiceNetworkAclTimeouts;
}
/**
 * @stability stable
 */
export interface SignalrServiceNetworkAclPrivateEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#allowed_request_types SignalrServiceNetworkAcl#allowed_request_types}.
     *
     * @stability stable
     */
    readonly allowedRequestTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#denied_request_types SignalrServiceNetworkAcl#denied_request_types}.
     *
     * @stability stable
     */
    readonly deniedRequestTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#id SignalrServiceNetworkAcl#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
export declare function signalrServiceNetworkAclPrivateEndpointToTerraform(struct?: SignalrServiceNetworkAclPrivateEndpoint): any;
/**
 * @stability stable
 */
export interface SignalrServiceNetworkAclPublicNetwork {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#allowed_request_types SignalrServiceNetworkAcl#allowed_request_types}.
     *
     * @stability stable
     */
    readonly allowedRequestTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#denied_request_types SignalrServiceNetworkAcl#denied_request_types}.
     *
     * @stability stable
     */
    readonly deniedRequestTypes?: string[];
}
export declare function signalrServiceNetworkAclPublicNetworkToTerraform(struct?: SignalrServiceNetworkAclPublicNetworkOutputReference | SignalrServiceNetworkAclPublicNetwork): any;
/**
 * @stability stable
 */
export declare class SignalrServiceNetworkAclPublicNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SignalrServiceNetworkAclPublicNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SignalrServiceNetworkAclPublicNetwork | undefined);
    private _allowedRequestTypes?;
    /**
     * @stability stable
     */
    get allowedRequestTypes(): string[];
    /**
     * @stability stable
     */
    set allowedRequestTypes(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedRequestTypes(): void;
    /**
     * @stability stable
     */
    get allowedRequestTypesInput(): string[] | undefined;
    private _deniedRequestTypes?;
    /**
     * @stability stable
     */
    get deniedRequestTypes(): string[];
    /**
     * @stability stable
     */
    set deniedRequestTypes(value: string[]);
    /**
     * @stability stable
     */
    resetDeniedRequestTypes(): void;
    /**
     * @stability stable
     */
    get deniedRequestTypesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface SignalrServiceNetworkAclTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#create SignalrServiceNetworkAcl#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#delete SignalrServiceNetworkAcl#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#read SignalrServiceNetworkAcl#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl#update SignalrServiceNetworkAcl#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function signalrServiceNetworkAclTimeoutsToTerraform(struct?: SignalrServiceNetworkAclTimeoutsOutputReference | SignalrServiceNetworkAclTimeouts): any;
/**
 * @stability stable
 */
export declare class SignalrServiceNetworkAclTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SignalrServiceNetworkAclTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SignalrServiceNetworkAclTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl azurerm_signalr_service_network_acl}.
 *
 * @stability stable
 */
export declare class SignalrServiceNetworkAcl extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service_network_acl azurerm_signalr_service_network_acl} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SignalrServiceNetworkAclConfig);
    private _defaultAction?;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    set defaultAction(value: string);
    /**
     * @stability stable
     */
    get defaultActionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _signalrServiceId?;
    /**
     * @stability stable
     */
    get signalrServiceId(): string;
    /**
     * @stability stable
     */
    set signalrServiceId(value: string);
    /**
     * @stability stable
     */
    get signalrServiceIdInput(): string | undefined;
    private _privateEndpoint?;
    /**
     * @stability stable
     */
    get privateEndpoint(): SignalrServiceNetworkAclPrivateEndpoint[];
    /**
     * @stability stable
     */
    set privateEndpoint(value: SignalrServiceNetworkAclPrivateEndpoint[]);
    /**
     * @stability stable
     */
    resetPrivateEndpoint(): void;
    /**
     * @stability stable
     */
    get privateEndpointInput(): SignalrServiceNetworkAclPrivateEndpoint[] | undefined;
    private _publicNetwork;
    /**
     * @stability stable
     */
    get publicNetwork(): SignalrServiceNetworkAclPublicNetworkOutputReference;
    /**
     * @stability stable
     */
    putPublicNetwork(value: SignalrServiceNetworkAclPublicNetwork): void;
    /**
     * @stability stable
     */
    get publicNetworkInput(): SignalrServiceNetworkAclPublicNetwork | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SignalrServiceNetworkAclTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SignalrServiceNetworkAclTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SignalrServiceNetworkAclTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
