import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SiteRecoveryNetworkMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#name SiteRecoveryNetworkMapping#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#recovery_vault_name SiteRecoveryNetworkMapping#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#resource_group_name SiteRecoveryNetworkMapping#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#source_network_id SiteRecoveryNetworkMapping#source_network_id}.
     *
     * @stability stable
     */
    readonly sourceNetworkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#source_recovery_fabric_name SiteRecoveryNetworkMapping#source_recovery_fabric_name}.
     *
     * @stability stable
     */
    readonly sourceRecoveryFabricName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#target_network_id SiteRecoveryNetworkMapping#target_network_id}.
     *
     * @stability stable
     */
    readonly targetNetworkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#target_recovery_fabric_name SiteRecoveryNetworkMapping#target_recovery_fabric_name}.
     *
     * @stability stable
     */
    readonly targetRecoveryFabricName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#timeouts SiteRecoveryNetworkMapping#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SiteRecoveryNetworkMappingTimeouts;
}
/**
 * @stability stable
 */
export interface SiteRecoveryNetworkMappingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#create SiteRecoveryNetworkMapping#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#delete SiteRecoveryNetworkMapping#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#read SiteRecoveryNetworkMapping#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping#update SiteRecoveryNetworkMapping#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function siteRecoveryNetworkMappingTimeoutsToTerraform(struct?: SiteRecoveryNetworkMappingTimeoutsOutputReference | SiteRecoveryNetworkMappingTimeouts): any;
/**
 * @stability stable
 */
export declare class SiteRecoveryNetworkMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SiteRecoveryNetworkMappingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SiteRecoveryNetworkMappingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping azurerm_site_recovery_network_mapping}.
 *
 * @stability stable
 */
export declare class SiteRecoveryNetworkMapping extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_network_mapping azurerm_site_recovery_network_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SiteRecoveryNetworkMappingConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceNetworkId?;
    /**
     * @stability stable
     */
    get sourceNetworkId(): string;
    /**
     * @stability stable
     */
    set sourceNetworkId(value: string);
    /**
     * @stability stable
     */
    get sourceNetworkIdInput(): string | undefined;
    private _sourceRecoveryFabricName?;
    /**
     * @stability stable
     */
    get sourceRecoveryFabricName(): string;
    /**
     * @stability stable
     */
    set sourceRecoveryFabricName(value: string);
    /**
     * @stability stable
     */
    get sourceRecoveryFabricNameInput(): string | undefined;
    private _targetNetworkId?;
    /**
     * @stability stable
     */
    get targetNetworkId(): string;
    /**
     * @stability stable
     */
    set targetNetworkId(value: string);
    /**
     * @stability stable
     */
    get targetNetworkIdInput(): string | undefined;
    private _targetRecoveryFabricName?;
    /**
     * @stability stable
     */
    get targetRecoveryFabricName(): string;
    /**
     * @stability stable
     */
    set targetRecoveryFabricName(value: string);
    /**
     * @stability stable
     */
    get targetRecoveryFabricNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SiteRecoveryNetworkMappingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SiteRecoveryNetworkMappingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SiteRecoveryNetworkMappingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
