import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpringCloudAppRedisAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#name SpringCloudAppRedisAssociation#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#redis_access_key SpringCloudAppRedisAssociation#redis_access_key}.
     *
     * @stability stable
     */
    readonly redisAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#redis_cache_id SpringCloudAppRedisAssociation#redis_cache_id}.
     *
     * @stability stable
     */
    readonly redisCacheId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#spring_cloud_app_id SpringCloudAppRedisAssociation#spring_cloud_app_id}.
     *
     * @stability stable
     */
    readonly springCloudAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#ssl_enabled SpringCloudAppRedisAssociation#ssl_enabled}.
     *
     * @stability stable
     */
    readonly sslEnabled?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#timeouts SpringCloudAppRedisAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpringCloudAppRedisAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface SpringCloudAppRedisAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#create SpringCloudAppRedisAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#delete SpringCloudAppRedisAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#read SpringCloudAppRedisAssociation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#update SpringCloudAppRedisAssociation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function springCloudAppRedisAssociationTimeoutsToTerraform(struct?: SpringCloudAppRedisAssociationTimeoutsOutputReference | SpringCloudAppRedisAssociationTimeouts): any;
/**
 * @stability stable
 */
export declare class SpringCloudAppRedisAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudAppRedisAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudAppRedisAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association azurerm_spring_cloud_app_redis_association}.
 *
 * @stability stable
 */
export declare class SpringCloudAppRedisAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association azurerm_spring_cloud_app_redis_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpringCloudAppRedisAssociationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _redisAccessKey?;
    /**
     * @stability stable
     */
    get redisAccessKey(): string;
    /**
     * @stability stable
     */
    set redisAccessKey(value: string);
    /**
     * @stability stable
     */
    get redisAccessKeyInput(): string | undefined;
    private _redisCacheId?;
    /**
     * @stability stable
     */
    get redisCacheId(): string;
    /**
     * @stability stable
     */
    set redisCacheId(value: string);
    /**
     * @stability stable
     */
    get redisCacheIdInput(): string | undefined;
    private _springCloudAppId?;
    /**
     * @stability stable
     */
    get springCloudAppId(): string;
    /**
     * @stability stable
     */
    set springCloudAppId(value: string);
    /**
     * @stability stable
     */
    get springCloudAppIdInput(): string | undefined;
    private _sslEnabled?;
    /**
     * @stability stable
     */
    get sslEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sslEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSslEnabled(): void;
    /**
     * @stability stable
     */
    get sslEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SpringCloudAppRedisAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SpringCloudAppRedisAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpringCloudAppRedisAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
