import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpringCloudCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#certificate_content SpringCloudCertificate#certificate_content}.
     *
     * @stability stable
     */
    readonly certificateContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#key_vault_certificate_id SpringCloudCertificate#key_vault_certificate_id}.
     *
     * @stability stable
     */
    readonly keyVaultCertificateId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#name SpringCloudCertificate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#resource_group_name SpringCloudCertificate#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#service_name SpringCloudCertificate#service_name}.
     *
     * @stability stable
     */
    readonly serviceName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#timeouts SpringCloudCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpringCloudCertificateTimeouts;
}
/**
 * @stability stable
 */
export interface SpringCloudCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#create SpringCloudCertificate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#delete SpringCloudCertificate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#read SpringCloudCertificate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function springCloudCertificateTimeoutsToTerraform(struct?: SpringCloudCertificateTimeoutsOutputReference | SpringCloudCertificateTimeouts): any;
/**
 * @stability stable
 */
export declare class SpringCloudCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudCertificateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate azurerm_spring_cloud_certificate}.
 *
 * @stability stable
 */
export declare class SpringCloudCertificate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate azurerm_spring_cloud_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpringCloudCertificateConfig);
    private _certificateContent?;
    /**
     * @stability stable
     */
    get certificateContent(): string;
    /**
     * @stability stable
     */
    set certificateContent(value: string);
    /**
     * @stability stable
     */
    resetCertificateContent(): void;
    /**
     * @stability stable
     */
    get certificateContentInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultCertificateId?;
    /**
     * @stability stable
     */
    get keyVaultCertificateId(): string;
    /**
     * @stability stable
     */
    set keyVaultCertificateId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultCertificateId(): void;
    /**
     * @stability stable
     */
    get keyVaultCertificateIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SpringCloudCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SpringCloudCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpringCloudCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
