import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlManagedInstanceFailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#location SqlManagedInstanceFailoverGroup#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#managed_instance_name SqlManagedInstanceFailoverGroup#managed_instance_name}.
     *
     * @stability stable
     */
    readonly managedInstanceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#name SqlManagedInstanceFailoverGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#partner_managed_instance_id SqlManagedInstanceFailoverGroup#partner_managed_instance_id}.
     *
     * @stability stable
     */
    readonly partnerManagedInstanceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#readonly_endpoint_failover_policy_enabled SqlManagedInstanceFailoverGroup#readonly_endpoint_failover_policy_enabled}.
     *
     * @stability stable
     */
    readonly readonlyEndpointFailoverPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#resource_group_name SqlManagedInstanceFailoverGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * read_write_endpoint_failover_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#read_write_endpoint_failover_policy SqlManagedInstanceFailoverGroup#read_write_endpoint_failover_policy}
     *
     * @stability stable
     */
    readonly readWriteEndpointFailoverPolicy: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#timeouts SqlManagedInstanceFailoverGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlManagedInstanceFailoverGroupTimeouts;
}
/**
 * @stability stable
 */
export declare class SqlManagedInstanceFailoverGroupPartnerRegion extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get role(): string;
}
/**
 * @stability stable
 */
export interface SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#grace_minutes SqlManagedInstanceFailoverGroup#grace_minutes}.
     *
     * @stability stable
     */
    readonly graceMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#mode SqlManagedInstanceFailoverGroup#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
}
export declare function sqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyToTerraform(struct?: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference | SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy): any;
/**
 * @stability stable
 */
export declare class SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined);
    private _graceMinutes?;
    /**
     * @stability stable
     */
    get graceMinutes(): number;
    /**
     * @stability stable
     */
    set graceMinutes(value: number);
    /**
     * @stability stable
     */
    resetGraceMinutes(): void;
    /**
     * @stability stable
     */
    get graceMinutesInput(): number | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlManagedInstanceFailoverGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#create SqlManagedInstanceFailoverGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#delete SqlManagedInstanceFailoverGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#read SqlManagedInstanceFailoverGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group#update SqlManagedInstanceFailoverGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sqlManagedInstanceFailoverGroupTimeoutsToTerraform(struct?: SqlManagedInstanceFailoverGroupTimeoutsOutputReference | SqlManagedInstanceFailoverGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class SqlManagedInstanceFailoverGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlManagedInstanceFailoverGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlManagedInstanceFailoverGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group azurerm_sql_managed_instance_failover_group}.
 *
 * @stability stable
 */
export declare class SqlManagedInstanceFailoverGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_failover_group azurerm_sql_managed_instance_failover_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlManagedInstanceFailoverGroupConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _managedInstanceName?;
    /**
     * @stability stable
     */
    get managedInstanceName(): string;
    /**
     * @stability stable
     */
    set managedInstanceName(value: string);
    /**
     * @stability stable
     */
    get managedInstanceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _partnerManagedInstanceId?;
    /**
     * @stability stable
     */
    get partnerManagedInstanceId(): string;
    /**
     * @stability stable
     */
    set partnerManagedInstanceId(value: string);
    /**
     * @stability stable
     */
    get partnerManagedInstanceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    partnerRegion(index: string): SqlManagedInstanceFailoverGroupPartnerRegion;
    private _readonlyEndpointFailoverPolicyEnabled?;
    /**
     * @stability stable
     */
    get readonlyEndpointFailoverPolicyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set readonlyEndpointFailoverPolicyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReadonlyEndpointFailoverPolicyEnabled(): void;
    /**
     * @stability stable
     */
    get readonlyEndpointFailoverPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get role(): string;
    private _readWriteEndpointFailoverPolicy;
    /**
     * @stability stable
     */
    get readWriteEndpointFailoverPolicy(): SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference;
    /**
     * @stability stable
     */
    putReadWriteEndpointFailoverPolicy(value: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy): void;
    /**
     * @stability stable
     */
    get readWriteEndpointFailoverPolicyInput(): SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlManagedInstanceFailoverGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlManagedInstanceFailoverGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlManagedInstanceFailoverGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
