import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#access_tier StorageAccount#access_tier}.
     *
     * @stability stable
     */
    readonly accessTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#account_kind StorageAccount#account_kind}.
     *
     * @stability stable
     */
    readonly accountKind?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#account_replication_type StorageAccount#account_replication_type}.
     *
     * @stability stable
     */
    readonly accountReplicationType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#account_tier StorageAccount#account_tier}.
     *
     * @stability stable
     */
    readonly accountTier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allow_blob_public_access StorageAccount#allow_blob_public_access}.
     *
     * @stability stable
     */
    readonly allowBlobPublicAccess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#enable_https_traffic_only StorageAccount#enable_https_traffic_only}.
     *
     * @stability stable
     */
    readonly enableHttpsTrafficOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#infrastructure_encryption_enabled StorageAccount#infrastructure_encryption_enabled}.
     *
     * @stability stable
     */
    readonly infrastructureEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#is_hns_enabled StorageAccount#is_hns_enabled}.
     *
     * @stability stable
     */
    readonly isHnsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#large_file_share_enabled StorageAccount#large_file_share_enabled}.
     *
     * @stability stable
     */
    readonly largeFileShareEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#location StorageAccount#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#min_tls_version StorageAccount#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#name StorageAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#nfsv3_enabled StorageAccount#nfsv3_enabled}.
     *
     * @stability stable
     */
    readonly nfsv3Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#queue_encryption_key_type StorageAccount#queue_encryption_key_type}.
     *
     * @stability stable
     */
    readonly queueEncryptionKeyType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#resource_group_name StorageAccount#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#shared_access_key_enabled StorageAccount#shared_access_key_enabled}.
     *
     * @stability stable
     */
    readonly sharedAccessKeyEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#table_encryption_key_type StorageAccount#table_encryption_key_type}.
     *
     * @stability stable
     */
    readonly tableEncryptionKeyType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#tags StorageAccount#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * azure_files_authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#azure_files_authentication StorageAccount#azure_files_authentication}
     *
     * @stability stable
     */
    readonly azureFilesAuthentication?: StorageAccountAzureFilesAuthentication;
    /**
     * blob_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#blob_properties StorageAccount#blob_properties}
     *
     * @stability stable
     */
    readonly blobProperties?: StorageAccountBlobProperties;
    /**
     * custom_domain block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#custom_domain StorageAccount#custom_domain}
     *
     * @stability stable
     */
    readonly customDomain?: StorageAccountCustomDomain;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#identity StorageAccount#identity}
     *
     * @stability stable
     */
    readonly identity?: StorageAccountIdentity;
    /**
     * network_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#network_rules StorageAccount#network_rules}
     *
     * @stability stable
     */
    readonly networkRules?: StorageAccountNetworkRules;
    /**
     * queue_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#queue_properties StorageAccount#queue_properties}
     *
     * @stability stable
     */
    readonly queueProperties?: StorageAccountQueueProperties;
    /**
     * routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#routing StorageAccount#routing}
     *
     * @stability stable
     */
    readonly routing?: StorageAccountRouting;
    /**
     * share_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#share_properties StorageAccount#share_properties}
     *
     * @stability stable
     */
    readonly shareProperties?: StorageAccountShareProperties;
    /**
     * static_website block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#static_website StorageAccount#static_website}
     *
     * @stability stable
     */
    readonly staticWebsite?: StorageAccountStaticWebsite;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#timeouts StorageAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageAccountTimeouts;
}
/**
 * @stability stable
 */
export interface StorageAccountAzureFilesAuthenticationActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#domain_guid StorageAccount#domain_guid}.
     *
     * @stability stable
     */
    readonly domainGuid: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#domain_name StorageAccount#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#domain_sid StorageAccount#domain_sid}.
     *
     * @stability stable
     */
    readonly domainSid: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#forest_name StorageAccount#forest_name}.
     *
     * @stability stable
     */
    readonly forestName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#netbios_domain_name StorageAccount#netbios_domain_name}.
     *
     * @stability stable
     */
    readonly netbiosDomainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#storage_sid StorageAccount#storage_sid}.
     *
     * @stability stable
     */
    readonly storageSid: string;
}
export declare function storageAccountAzureFilesAuthenticationActiveDirectoryToTerraform(struct?: StorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference | StorageAccountAzureFilesAuthenticationActiveDirectory): any;
/**
 * @stability stable
 */
export declare class StorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountAzureFilesAuthenticationActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountAzureFilesAuthenticationActiveDirectory | undefined);
    private _domainGuid?;
    /**
     * @stability stable
     */
    get domainGuid(): string;
    /**
     * @stability stable
     */
    set domainGuid(value: string);
    /**
     * @stability stable
     */
    get domainGuidInput(): string | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _domainSid?;
    /**
     * @stability stable
     */
    get domainSid(): string;
    /**
     * @stability stable
     */
    set domainSid(value: string);
    /**
     * @stability stable
     */
    get domainSidInput(): string | undefined;
    private _forestName?;
    /**
     * @stability stable
     */
    get forestName(): string;
    /**
     * @stability stable
     */
    set forestName(value: string);
    /**
     * @stability stable
     */
    get forestNameInput(): string | undefined;
    private _netbiosDomainName?;
    /**
     * @stability stable
     */
    get netbiosDomainName(): string;
    /**
     * @stability stable
     */
    set netbiosDomainName(value: string);
    /**
     * @stability stable
     */
    get netbiosDomainNameInput(): string | undefined;
    private _storageSid?;
    /**
     * @stability stable
     */
    get storageSid(): string;
    /**
     * @stability stable
     */
    set storageSid(value: string);
    /**
     * @stability stable
     */
    get storageSidInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountAzureFilesAuthentication {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#directory_type StorageAccount#directory_type}.
     *
     * @stability stable
     */
    readonly directoryType: string;
    /**
     * active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#active_directory StorageAccount#active_directory}
     *
     * @stability stable
     */
    readonly activeDirectory?: StorageAccountAzureFilesAuthenticationActiveDirectory;
}
export declare function storageAccountAzureFilesAuthenticationToTerraform(struct?: StorageAccountAzureFilesAuthenticationOutputReference | StorageAccountAzureFilesAuthentication): any;
/**
 * @stability stable
 */
export declare class StorageAccountAzureFilesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountAzureFilesAuthentication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountAzureFilesAuthentication | undefined);
    private _directoryType?;
    /**
     * @stability stable
     */
    get directoryType(): string;
    /**
     * @stability stable
     */
    set directoryType(value: string);
    /**
     * @stability stable
     */
    get directoryTypeInput(): string | undefined;
    private _activeDirectory;
    /**
     * @stability stable
     */
    get activeDirectory(): StorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putActiveDirectory(value: StorageAccountAzureFilesAuthenticationActiveDirectory): void;
    /**
     * @stability stable
     */
    resetActiveDirectory(): void;
    /**
     * @stability stable
     */
    get activeDirectoryInput(): StorageAccountAzureFilesAuthenticationActiveDirectory | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountBlobPropertiesContainerDeleteRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#days StorageAccount#days}.
     *
     * @stability stable
     */
    readonly days?: number;
}
export declare function storageAccountBlobPropertiesContainerDeleteRetentionPolicyToTerraform(struct?: StorageAccountBlobPropertiesContainerDeleteRetentionPolicyOutputReference | StorageAccountBlobPropertiesContainerDeleteRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class StorageAccountBlobPropertiesContainerDeleteRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountBlobPropertiesContainerDeleteRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountBlobPropertiesContainerDeleteRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountBlobPropertiesCorsRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_headers StorageAccount#allowed_headers}.
     *
     * @stability stable
     */
    readonly allowedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_methods StorageAccount#allowed_methods}.
     *
     * @stability stable
     */
    readonly allowedMethods: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_origins StorageAccount#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#exposed_headers StorageAccount#exposed_headers}.
     *
     * @stability stable
     */
    readonly exposedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#max_age_in_seconds StorageAccount#max_age_in_seconds}.
     *
     * @stability stable
     */
    readonly maxAgeInSeconds: number;
}
export declare function storageAccountBlobPropertiesCorsRuleToTerraform(struct?: StorageAccountBlobPropertiesCorsRule): any;
/**
 * @stability stable
 */
export interface StorageAccountBlobPropertiesDeleteRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#days StorageAccount#days}.
     *
     * @stability stable
     */
    readonly days?: number;
}
export declare function storageAccountBlobPropertiesDeleteRetentionPolicyToTerraform(struct?: StorageAccountBlobPropertiesDeleteRetentionPolicyOutputReference | StorageAccountBlobPropertiesDeleteRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class StorageAccountBlobPropertiesDeleteRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountBlobPropertiesDeleteRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountBlobPropertiesDeleteRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountBlobProperties {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#change_feed_enabled StorageAccount#change_feed_enabled}.
     *
     * @stability stable
     */
    readonly changeFeedEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#default_service_version StorageAccount#default_service_version}.
     *
     * @stability stable
     */
    readonly defaultServiceVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#last_access_time_enabled StorageAccount#last_access_time_enabled}.
     *
     * @stability stable
     */
    readonly lastAccessTimeEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#versioning_enabled StorageAccount#versioning_enabled}.
     *
     * @stability stable
     */
    readonly versioningEnabled?: boolean | cdktf.IResolvable;
    /**
     * container_delete_retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#container_delete_retention_policy StorageAccount#container_delete_retention_policy}
     *
     * @stability stable
     */
    readonly containerDeleteRetentionPolicy?: StorageAccountBlobPropertiesContainerDeleteRetentionPolicy;
    /**
     * cors_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#cors_rule StorageAccount#cors_rule}
     *
     * @stability stable
     */
    readonly corsRule?: StorageAccountBlobPropertiesCorsRule[];
    /**
     * delete_retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#delete_retention_policy StorageAccount#delete_retention_policy}
     *
     * @stability stable
     */
    readonly deleteRetentionPolicy?: StorageAccountBlobPropertiesDeleteRetentionPolicy;
}
export declare function storageAccountBlobPropertiesToTerraform(struct?: StorageAccountBlobPropertiesOutputReference | StorageAccountBlobProperties): any;
/**
 * @stability stable
 */
export declare class StorageAccountBlobPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountBlobProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountBlobProperties | undefined);
    private _changeFeedEnabled?;
    /**
     * @stability stable
     */
    get changeFeedEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set changeFeedEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetChangeFeedEnabled(): void;
    /**
     * @stability stable
     */
    get changeFeedEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultServiceVersion?;
    /**
     * @stability stable
     */
    get defaultServiceVersion(): string;
    /**
     * @stability stable
     */
    set defaultServiceVersion(value: string);
    /**
     * @stability stable
     */
    resetDefaultServiceVersion(): void;
    /**
     * @stability stable
     */
    get defaultServiceVersionInput(): string | undefined;
    private _lastAccessTimeEnabled?;
    /**
     * @stability stable
     */
    get lastAccessTimeEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set lastAccessTimeEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLastAccessTimeEnabled(): void;
    /**
     * @stability stable
     */
    get lastAccessTimeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _versioningEnabled?;
    /**
     * @stability stable
     */
    get versioningEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set versioningEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVersioningEnabled(): void;
    /**
     * @stability stable
     */
    get versioningEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _containerDeleteRetentionPolicy;
    /**
     * @stability stable
     */
    get containerDeleteRetentionPolicy(): StorageAccountBlobPropertiesContainerDeleteRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putContainerDeleteRetentionPolicy(value: StorageAccountBlobPropertiesContainerDeleteRetentionPolicy): void;
    /**
     * @stability stable
     */
    resetContainerDeleteRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get containerDeleteRetentionPolicyInput(): StorageAccountBlobPropertiesContainerDeleteRetentionPolicy | undefined;
    private _corsRule?;
    /**
     * @stability stable
     */
    get corsRule(): StorageAccountBlobPropertiesCorsRule[];
    /**
     * @stability stable
     */
    set corsRule(value: StorageAccountBlobPropertiesCorsRule[]);
    /**
     * @stability stable
     */
    resetCorsRule(): void;
    /**
     * @stability stable
     */
    get corsRuleInput(): StorageAccountBlobPropertiesCorsRule[] | undefined;
    private _deleteRetentionPolicy;
    /**
     * @stability stable
     */
    get deleteRetentionPolicy(): StorageAccountBlobPropertiesDeleteRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putDeleteRetentionPolicy(value: StorageAccountBlobPropertiesDeleteRetentionPolicy): void;
    /**
     * @stability stable
     */
    resetDeleteRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get deleteRetentionPolicyInput(): StorageAccountBlobPropertiesDeleteRetentionPolicy | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountCustomDomain {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#name StorageAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#use_subdomain StorageAccount#use_subdomain}.
     *
     * @stability stable
     */
    readonly useSubdomain?: boolean | cdktf.IResolvable;
}
export declare function storageAccountCustomDomainToTerraform(struct?: StorageAccountCustomDomainOutputReference | StorageAccountCustomDomain): any;
/**
 * @stability stable
 */
export declare class StorageAccountCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountCustomDomain | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountCustomDomain | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _useSubdomain?;
    /**
     * @stability stable
     */
    get useSubdomain(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useSubdomain(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseSubdomain(): void;
    /**
     * @stability stable
     */
    get useSubdomainInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#identity_ids StorageAccount#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#type StorageAccount#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function storageAccountIdentityToTerraform(struct?: StorageAccountIdentityOutputReference | StorageAccountIdentity): any;
/**
 * @stability stable
 */
export declare class StorageAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountNetworkRulesPrivateLinkAccess {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#endpoint_resource_id StorageAccount#endpoint_resource_id}.
     *
     * @stability stable
     */
    readonly endpointResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#endpoint_tenant_id StorageAccount#endpoint_tenant_id}.
     *
     * @stability stable
     */
    readonly endpointTenantId?: string;
}
export declare function storageAccountNetworkRulesPrivateLinkAccessToTerraform(struct?: StorageAccountNetworkRulesPrivateLinkAccess): any;
/**
 * @stability stable
 */
export interface StorageAccountNetworkRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#bypass StorageAccount#bypass}.
     *
     * @stability stable
     */
    readonly bypass?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#default_action StorageAccount#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#ip_rules StorageAccount#ip_rules}.
     *
     * @stability stable
     */
    readonly ipRules?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#virtual_network_subnet_ids StorageAccount#virtual_network_subnet_ids}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetIds?: string[];
    /**
     * private_link_access block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#private_link_access StorageAccount#private_link_access}
     *
     * @stability stable
     */
    readonly privateLinkAccess?: StorageAccountNetworkRulesPrivateLinkAccess[];
}
export declare function storageAccountNetworkRulesToTerraform(struct?: StorageAccountNetworkRulesOutputReference | StorageAccountNetworkRules): any;
/**
 * @stability stable
 */
export declare class StorageAccountNetworkRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountNetworkRules | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountNetworkRules | undefined);
    private _bypass?;
    /**
     * @stability stable
     */
    get bypass(): string[];
    /**
     * @stability stable
     */
    set bypass(value: string[]);
    /**
     * @stability stable
     */
    resetBypass(): void;
    /**
     * @stability stable
     */
    get bypassInput(): string[] | undefined;
    private _defaultAction?;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    set defaultAction(value: string);
    /**
     * @stability stable
     */
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    /**
     * @stability stable
     */
    get ipRules(): string[];
    /**
     * @stability stable
     */
    set ipRules(value: string[]);
    /**
     * @stability stable
     */
    resetIpRules(): void;
    /**
     * @stability stable
     */
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkSubnetIds?;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIds(): string[];
    /**
     * @stability stable
     */
    set virtualNetworkSubnetIds(value: string[]);
    /**
     * @stability stable
     */
    resetVirtualNetworkSubnetIds(): void;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
    private _privateLinkAccess?;
    /**
     * @stability stable
     */
    get privateLinkAccess(): StorageAccountNetworkRulesPrivateLinkAccess[];
    /**
     * @stability stable
     */
    set privateLinkAccess(value: StorageAccountNetworkRulesPrivateLinkAccess[]);
    /**
     * @stability stable
     */
    resetPrivateLinkAccess(): void;
    /**
     * @stability stable
     */
    get privateLinkAccessInput(): StorageAccountNetworkRulesPrivateLinkAccess[] | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountQueuePropertiesCorsRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_headers StorageAccount#allowed_headers}.
     *
     * @stability stable
     */
    readonly allowedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_methods StorageAccount#allowed_methods}.
     *
     * @stability stable
     */
    readonly allowedMethods: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_origins StorageAccount#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#exposed_headers StorageAccount#exposed_headers}.
     *
     * @stability stable
     */
    readonly exposedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#max_age_in_seconds StorageAccount#max_age_in_seconds}.
     *
     * @stability stable
     */
    readonly maxAgeInSeconds: number;
}
export declare function storageAccountQueuePropertiesCorsRuleToTerraform(struct?: StorageAccountQueuePropertiesCorsRule): any;
/**
 * @stability stable
 */
export interface StorageAccountQueuePropertiesHourMetrics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#enabled StorageAccount#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#include_apis StorageAccount#include_apis}.
     *
     * @stability stable
     */
    readonly includeApis?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy_days StorageAccount#retention_policy_days}.
     *
     * @stability stable
     */
    readonly retentionPolicyDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#version StorageAccount#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function storageAccountQueuePropertiesHourMetricsToTerraform(struct?: StorageAccountQueuePropertiesHourMetricsOutputReference | StorageAccountQueuePropertiesHourMetrics): any;
/**
 * @stability stable
 */
export declare class StorageAccountQueuePropertiesHourMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountQueuePropertiesHourMetrics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountQueuePropertiesHourMetrics | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _includeApis?;
    /**
     * @stability stable
     */
    get includeApis(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeApis(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeApis(): void;
    /**
     * @stability stable
     */
    get includeApisInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    /**
     * @stability stable
     */
    get retentionPolicyDays(): number;
    /**
     * @stability stable
     */
    set retentionPolicyDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionPolicyDays(): void;
    /**
     * @stability stable
     */
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountQueuePropertiesLogging {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#delete StorageAccount#delete}.
     *
     * @stability stable
     */
    readonly delete: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#read StorageAccount#read}.
     *
     * @stability stable
     */
    readonly read: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy_days StorageAccount#retention_policy_days}.
     *
     * @stability stable
     */
    readonly retentionPolicyDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#version StorageAccount#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#write StorageAccount#write}.
     *
     * @stability stable
     */
    readonly write: boolean | cdktf.IResolvable;
}
export declare function storageAccountQueuePropertiesLoggingToTerraform(struct?: StorageAccountQueuePropertiesLoggingOutputReference | StorageAccountQueuePropertiesLogging): any;
/**
 * @stability stable
 */
export declare class StorageAccountQueuePropertiesLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountQueuePropertiesLogging | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountQueuePropertiesLogging | undefined);
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set delete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get deleteInput(): boolean | cdktf.IResolvable | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set read(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get readInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    /**
     * @stability stable
     */
    get retentionPolicyDays(): number;
    /**
     * @stability stable
     */
    set retentionPolicyDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionPolicyDays(): void;
    /**
     * @stability stable
     */
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _write?;
    /**
     * @stability stable
     */
    get write(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set write(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get writeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountQueuePropertiesMinuteMetrics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#enabled StorageAccount#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#include_apis StorageAccount#include_apis}.
     *
     * @stability stable
     */
    readonly includeApis?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy_days StorageAccount#retention_policy_days}.
     *
     * @stability stable
     */
    readonly retentionPolicyDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#version StorageAccount#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function storageAccountQueuePropertiesMinuteMetricsToTerraform(struct?: StorageAccountQueuePropertiesMinuteMetricsOutputReference | StorageAccountQueuePropertiesMinuteMetrics): any;
/**
 * @stability stable
 */
export declare class StorageAccountQueuePropertiesMinuteMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountQueuePropertiesMinuteMetrics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountQueuePropertiesMinuteMetrics | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _includeApis?;
    /**
     * @stability stable
     */
    get includeApis(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeApis(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeApis(): void;
    /**
     * @stability stable
     */
    get includeApisInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    /**
     * @stability stable
     */
    get retentionPolicyDays(): number;
    /**
     * @stability stable
     */
    set retentionPolicyDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionPolicyDays(): void;
    /**
     * @stability stable
     */
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountQueueProperties {
    /**
     * cors_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#cors_rule StorageAccount#cors_rule}
     *
     * @stability stable
     */
    readonly corsRule?: StorageAccountQueuePropertiesCorsRule[];
    /**
     * hour_metrics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#hour_metrics StorageAccount#hour_metrics}
     *
     * @stability stable
     */
    readonly hourMetrics?: StorageAccountQueuePropertiesHourMetrics;
    /**
     * logging block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#logging StorageAccount#logging}
     *
     * @stability stable
     */
    readonly logging?: StorageAccountQueuePropertiesLogging;
    /**
     * minute_metrics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#minute_metrics StorageAccount#minute_metrics}
     *
     * @stability stable
     */
    readonly minuteMetrics?: StorageAccountQueuePropertiesMinuteMetrics;
}
export declare function storageAccountQueuePropertiesToTerraform(struct?: StorageAccountQueuePropertiesOutputReference | StorageAccountQueueProperties): any;
/**
 * @stability stable
 */
export declare class StorageAccountQueuePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountQueueProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountQueueProperties | undefined);
    private _corsRule?;
    /**
     * @stability stable
     */
    get corsRule(): StorageAccountQueuePropertiesCorsRule[];
    /**
     * @stability stable
     */
    set corsRule(value: StorageAccountQueuePropertiesCorsRule[]);
    /**
     * @stability stable
     */
    resetCorsRule(): void;
    /**
     * @stability stable
     */
    get corsRuleInput(): StorageAccountQueuePropertiesCorsRule[] | undefined;
    private _hourMetrics;
    /**
     * @stability stable
     */
    get hourMetrics(): StorageAccountQueuePropertiesHourMetricsOutputReference;
    /**
     * @stability stable
     */
    putHourMetrics(value: StorageAccountQueuePropertiesHourMetrics): void;
    /**
     * @stability stable
     */
    resetHourMetrics(): void;
    /**
     * @stability stable
     */
    get hourMetricsInput(): StorageAccountQueuePropertiesHourMetrics | undefined;
    private _logging;
    /**
     * @stability stable
     */
    get logging(): StorageAccountQueuePropertiesLoggingOutputReference;
    /**
     * @stability stable
     */
    putLogging(value: StorageAccountQueuePropertiesLogging): void;
    /**
     * @stability stable
     */
    resetLogging(): void;
    /**
     * @stability stable
     */
    get loggingInput(): StorageAccountQueuePropertiesLogging | undefined;
    private _minuteMetrics;
    /**
     * @stability stable
     */
    get minuteMetrics(): StorageAccountQueuePropertiesMinuteMetricsOutputReference;
    /**
     * @stability stable
     */
    putMinuteMetrics(value: StorageAccountQueuePropertiesMinuteMetrics): void;
    /**
     * @stability stable
     */
    resetMinuteMetrics(): void;
    /**
     * @stability stable
     */
    get minuteMetricsInput(): StorageAccountQueuePropertiesMinuteMetrics | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountRouting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#choice StorageAccount#choice}.
     *
     * @stability stable
     */
    readonly choice?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#publish_internet_endpoints StorageAccount#publish_internet_endpoints}.
     *
     * @stability stable
     */
    readonly publishInternetEndpoints?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#publish_microsoft_endpoints StorageAccount#publish_microsoft_endpoints}.
     *
     * @stability stable
     */
    readonly publishMicrosoftEndpoints?: boolean | cdktf.IResolvable;
}
export declare function storageAccountRoutingToTerraform(struct?: StorageAccountRoutingOutputReference | StorageAccountRouting): any;
/**
 * @stability stable
 */
export declare class StorageAccountRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountRouting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountRouting | undefined);
    private _choice?;
    /**
     * @stability stable
     */
    get choice(): string;
    /**
     * @stability stable
     */
    set choice(value: string);
    /**
     * @stability stable
     */
    resetChoice(): void;
    /**
     * @stability stable
     */
    get choiceInput(): string | undefined;
    private _publishInternetEndpoints?;
    /**
     * @stability stable
     */
    get publishInternetEndpoints(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publishInternetEndpoints(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublishInternetEndpoints(): void;
    /**
     * @stability stable
     */
    get publishInternetEndpointsInput(): boolean | cdktf.IResolvable | undefined;
    private _publishMicrosoftEndpoints?;
    /**
     * @stability stable
     */
    get publishMicrosoftEndpoints(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publishMicrosoftEndpoints(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublishMicrosoftEndpoints(): void;
    /**
     * @stability stable
     */
    get publishMicrosoftEndpointsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountSharePropertiesCorsRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_headers StorageAccount#allowed_headers}.
     *
     * @stability stable
     */
    readonly allowedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_methods StorageAccount#allowed_methods}.
     *
     * @stability stable
     */
    readonly allowedMethods: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_origins StorageAccount#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#exposed_headers StorageAccount#exposed_headers}.
     *
     * @stability stable
     */
    readonly exposedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#max_age_in_seconds StorageAccount#max_age_in_seconds}.
     *
     * @stability stable
     */
    readonly maxAgeInSeconds: number;
}
export declare function storageAccountSharePropertiesCorsRuleToTerraform(struct?: StorageAccountSharePropertiesCorsRule): any;
/**
 * @stability stable
 */
export interface StorageAccountSharePropertiesRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#days StorageAccount#days}.
     *
     * @stability stable
     */
    readonly days?: number;
}
export declare function storageAccountSharePropertiesRetentionPolicyToTerraform(struct?: StorageAccountSharePropertiesRetentionPolicyOutputReference | StorageAccountSharePropertiesRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class StorageAccountSharePropertiesRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountSharePropertiesRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountSharePropertiesRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountSharePropertiesSmb {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#authentication_types StorageAccount#authentication_types}.
     *
     * @stability stable
     */
    readonly authenticationTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#channel_encryption_type StorageAccount#channel_encryption_type}.
     *
     * @stability stable
     */
    readonly channelEncryptionType?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#kerberos_ticket_encryption_type StorageAccount#kerberos_ticket_encryption_type}.
     *
     * @stability stable
     */
    readonly kerberosTicketEncryptionType?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#versions StorageAccount#versions}.
     *
     * @stability stable
     */
    readonly versions?: string[];
}
export declare function storageAccountSharePropertiesSmbToTerraform(struct?: StorageAccountSharePropertiesSmbOutputReference | StorageAccountSharePropertiesSmb): any;
/**
 * @stability stable
 */
export declare class StorageAccountSharePropertiesSmbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountSharePropertiesSmb | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountSharePropertiesSmb | undefined);
    private _authenticationTypes?;
    /**
     * @stability stable
     */
    get authenticationTypes(): string[];
    /**
     * @stability stable
     */
    set authenticationTypes(value: string[]);
    /**
     * @stability stable
     */
    resetAuthenticationTypes(): void;
    /**
     * @stability stable
     */
    get authenticationTypesInput(): string[] | undefined;
    private _channelEncryptionType?;
    /**
     * @stability stable
     */
    get channelEncryptionType(): string[];
    /**
     * @stability stable
     */
    set channelEncryptionType(value: string[]);
    /**
     * @stability stable
     */
    resetChannelEncryptionType(): void;
    /**
     * @stability stable
     */
    get channelEncryptionTypeInput(): string[] | undefined;
    private _kerberosTicketEncryptionType?;
    /**
     * @stability stable
     */
    get kerberosTicketEncryptionType(): string[];
    /**
     * @stability stable
     */
    set kerberosTicketEncryptionType(value: string[]);
    /**
     * @stability stable
     */
    resetKerberosTicketEncryptionType(): void;
    /**
     * @stability stable
     */
    get kerberosTicketEncryptionTypeInput(): string[] | undefined;
    private _versions?;
    /**
     * @stability stable
     */
    get versions(): string[];
    /**
     * @stability stable
     */
    set versions(value: string[]);
    /**
     * @stability stable
     */
    resetVersions(): void;
    /**
     * @stability stable
     */
    get versionsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountShareProperties {
    /**
     * cors_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#cors_rule StorageAccount#cors_rule}
     *
     * @stability stable
     */
    readonly corsRule?: StorageAccountSharePropertiesCorsRule[];
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy StorageAccount#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy?: StorageAccountSharePropertiesRetentionPolicy;
    /**
     * smb block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#smb StorageAccount#smb}
     *
     * @stability stable
     */
    readonly smb?: StorageAccountSharePropertiesSmb;
}
export declare function storageAccountSharePropertiesToTerraform(struct?: StorageAccountSharePropertiesOutputReference | StorageAccountShareProperties): any;
/**
 * @stability stable
 */
export declare class StorageAccountSharePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountShareProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountShareProperties | undefined);
    private _corsRule?;
    /**
     * @stability stable
     */
    get corsRule(): StorageAccountSharePropertiesCorsRule[];
    /**
     * @stability stable
     */
    set corsRule(value: StorageAccountSharePropertiesCorsRule[]);
    /**
     * @stability stable
     */
    resetCorsRule(): void;
    /**
     * @stability stable
     */
    get corsRuleInput(): StorageAccountSharePropertiesCorsRule[] | undefined;
    private _retentionPolicy;
    /**
     * @stability stable
     */
    get retentionPolicy(): StorageAccountSharePropertiesRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetentionPolicy(value: StorageAccountSharePropertiesRetentionPolicy): void;
    /**
     * @stability stable
     */
    resetRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): StorageAccountSharePropertiesRetentionPolicy | undefined;
    private _smb;
    /**
     * @stability stable
     */
    get smb(): StorageAccountSharePropertiesSmbOutputReference;
    /**
     * @stability stable
     */
    putSmb(value: StorageAccountSharePropertiesSmb): void;
    /**
     * @stability stable
     */
    resetSmb(): void;
    /**
     * @stability stable
     */
    get smbInput(): StorageAccountSharePropertiesSmb | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountStaticWebsite {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#error_404_document StorageAccount#error_404_document}.
     *
     * @stability stable
     */
    readonly error404Document?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#index_document StorageAccount#index_document}.
     *
     * @stability stable
     */
    readonly indexDocument?: string;
}
export declare function storageAccountStaticWebsiteToTerraform(struct?: StorageAccountStaticWebsiteOutputReference | StorageAccountStaticWebsite): any;
/**
 * @stability stable
 */
export declare class StorageAccountStaticWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountStaticWebsite | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountStaticWebsite | undefined);
    private _error404Document?;
    /**
     * @stability stable
     */
    get error404Document(): string;
    /**
     * @stability stable
     */
    set error404Document(value: string);
    /**
     * @stability stable
     */
    resetError404Document(): void;
    /**
     * @stability stable
     */
    get error404DocumentInput(): string | undefined;
    private _indexDocument?;
    /**
     * @stability stable
     */
    get indexDocument(): string;
    /**
     * @stability stable
     */
    set indexDocument(value: string);
    /**
     * @stability stable
     */
    resetIndexDocument(): void;
    /**
     * @stability stable
     */
    get indexDocumentInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#create StorageAccount#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#delete StorageAccount#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#read StorageAccount#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#update StorageAccount#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageAccountTimeoutsToTerraform(struct?: StorageAccountTimeoutsOutputReference | StorageAccountTimeouts): any;
/**
 * @stability stable
 */
export declare class StorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account azurerm_storage_account}.
 *
 * @stability stable
 */
export declare class StorageAccount extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account azurerm_storage_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageAccountConfig);
    private _accessTier?;
    /**
     * @stability stable
     */
    get accessTier(): string;
    /**
     * @stability stable
     */
    set accessTier(value: string);
    /**
     * @stability stable
     */
    resetAccessTier(): void;
    /**
     * @stability stable
     */
    get accessTierInput(): string | undefined;
    private _accountKind?;
    /**
     * @stability stable
     */
    get accountKind(): string;
    /**
     * @stability stable
     */
    set accountKind(value: string);
    /**
     * @stability stable
     */
    resetAccountKind(): void;
    /**
     * @stability stable
     */
    get accountKindInput(): string | undefined;
    private _accountReplicationType?;
    /**
     * @stability stable
     */
    get accountReplicationType(): string;
    /**
     * @stability stable
     */
    set accountReplicationType(value: string);
    /**
     * @stability stable
     */
    get accountReplicationTypeInput(): string | undefined;
    private _accountTier?;
    /**
     * @stability stable
     */
    get accountTier(): string;
    /**
     * @stability stable
     */
    set accountTier(value: string);
    /**
     * @stability stable
     */
    get accountTierInput(): string | undefined;
    private _allowBlobPublicAccess?;
    /**
     * @stability stable
     */
    get allowBlobPublicAccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowBlobPublicAccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowBlobPublicAccess(): void;
    /**
     * @stability stable
     */
    get allowBlobPublicAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHttpsTrafficOnly?;
    /**
     * @stability stable
     */
    get enableHttpsTrafficOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableHttpsTrafficOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableHttpsTrafficOnly(): void;
    /**
     * @stability stable
     */
    get enableHttpsTrafficOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _infrastructureEncryptionEnabled?;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInfrastructureEncryptionEnabled(): void;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isHnsEnabled?;
    /**
     * @stability stable
     */
    get isHnsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isHnsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsHnsEnabled(): void;
    /**
     * @stability stable
     */
    get isHnsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _largeFileShareEnabled?;
    /**
     * @stability stable
     */
    get largeFileShareEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set largeFileShareEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLargeFileShareEnabled(): void;
    /**
     * @stability stable
     */
    get largeFileShareEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nfsv3Enabled?;
    /**
     * @stability stable
     */
    get nfsv3Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set nfsv3Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNfsv3Enabled(): void;
    /**
     * @stability stable
     */
    get nfsv3EnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    /**
     * @stability stable
     */
    get primaryBlobConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryBlobEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryBlobHost(): string;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryDfsEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryDfsHost(): string;
    /**
     * @stability stable
     */
    get primaryFileEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryFileHost(): string;
    /**
     * @stability stable
     */
    get primaryLocation(): string;
    /**
     * @stability stable
     */
    get primaryQueueEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryQueueHost(): string;
    /**
     * @stability stable
     */
    get primaryTableEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryTableHost(): string;
    /**
     * @stability stable
     */
    get primaryWebEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryWebHost(): string;
    private _queueEncryptionKeyType?;
    /**
     * @stability stable
     */
    get queueEncryptionKeyType(): string;
    /**
     * @stability stable
     */
    set queueEncryptionKeyType(value: string);
    /**
     * @stability stable
     */
    resetQueueEncryptionKeyType(): void;
    /**
     * @stability stable
     */
    get queueEncryptionKeyTypeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    /**
     * @stability stable
     */
    get secondaryBlobConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryBlobEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryBlobHost(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryDfsEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryDfsHost(): string;
    /**
     * @stability stable
     */
    get secondaryFileEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryFileHost(): string;
    /**
     * @stability stable
     */
    get secondaryLocation(): string;
    /**
     * @stability stable
     */
    get secondaryQueueEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryQueueHost(): string;
    /**
     * @stability stable
     */
    get secondaryTableEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryTableHost(): string;
    /**
     * @stability stable
     */
    get secondaryWebEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryWebHost(): string;
    private _sharedAccessKeyEnabled?;
    /**
     * @stability stable
     */
    get sharedAccessKeyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sharedAccessKeyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSharedAccessKeyEnabled(): void;
    /**
     * @stability stable
     */
    get sharedAccessKeyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tableEncryptionKeyType?;
    /**
     * @stability stable
     */
    get tableEncryptionKeyType(): string;
    /**
     * @stability stable
     */
    set tableEncryptionKeyType(value: string);
    /**
     * @stability stable
     */
    resetTableEncryptionKeyType(): void;
    /**
     * @stability stable
     */
    get tableEncryptionKeyTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _azureFilesAuthentication;
    /**
     * @stability stable
     */
    get azureFilesAuthentication(): StorageAccountAzureFilesAuthenticationOutputReference;
    /**
     * @stability stable
     */
    putAzureFilesAuthentication(value: StorageAccountAzureFilesAuthentication): void;
    /**
     * @stability stable
     */
    resetAzureFilesAuthentication(): void;
    /**
     * @stability stable
     */
    get azureFilesAuthenticationInput(): StorageAccountAzureFilesAuthentication | undefined;
    private _blobProperties;
    /**
     * @stability stable
     */
    get blobProperties(): StorageAccountBlobPropertiesOutputReference;
    /**
     * @stability stable
     */
    putBlobProperties(value: StorageAccountBlobProperties): void;
    /**
     * @stability stable
     */
    resetBlobProperties(): void;
    /**
     * @stability stable
     */
    get blobPropertiesInput(): StorageAccountBlobProperties | undefined;
    private _customDomain;
    /**
     * @stability stable
     */
    get customDomain(): StorageAccountCustomDomainOutputReference;
    /**
     * @stability stable
     */
    putCustomDomain(value: StorageAccountCustomDomain): void;
    /**
     * @stability stable
     */
    resetCustomDomain(): void;
    /**
     * @stability stable
     */
    get customDomainInput(): StorageAccountCustomDomain | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): StorageAccountIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: StorageAccountIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): StorageAccountIdentity | undefined;
    private _networkRules;
    /**
     * @stability stable
     */
    get networkRules(): StorageAccountNetworkRulesOutputReference;
    /**
     * @stability stable
     */
    putNetworkRules(value: StorageAccountNetworkRules): void;
    /**
     * @stability stable
     */
    resetNetworkRules(): void;
    /**
     * @stability stable
     */
    get networkRulesInput(): StorageAccountNetworkRules | undefined;
    private _queueProperties;
    /**
     * @stability stable
     */
    get queueProperties(): StorageAccountQueuePropertiesOutputReference;
    /**
     * @stability stable
     */
    putQueueProperties(value: StorageAccountQueueProperties): void;
    /**
     * @stability stable
     */
    resetQueueProperties(): void;
    /**
     * @stability stable
     */
    get queuePropertiesInput(): StorageAccountQueueProperties | undefined;
    private _routing;
    /**
     * @stability stable
     */
    get routing(): StorageAccountRoutingOutputReference;
    /**
     * @stability stable
     */
    putRouting(value: StorageAccountRouting): void;
    /**
     * @stability stable
     */
    resetRouting(): void;
    /**
     * @stability stable
     */
    get routingInput(): StorageAccountRouting | undefined;
    private _shareProperties;
    /**
     * @stability stable
     */
    get shareProperties(): StorageAccountSharePropertiesOutputReference;
    /**
     * @stability stable
     */
    putShareProperties(value: StorageAccountShareProperties): void;
    /**
     * @stability stable
     */
    resetShareProperties(): void;
    /**
     * @stability stable
     */
    get sharePropertiesInput(): StorageAccountShareProperties | undefined;
    private _staticWebsite;
    /**
     * @stability stable
     */
    get staticWebsite(): StorageAccountStaticWebsiteOutputReference;
    /**
     * @stability stable
     */
    putStaticWebsite(value: StorageAccountStaticWebsite): void;
    /**
     * @stability stable
     */
    resetStaticWebsite(): void;
    /**
     * @stability stable
     */
    get staticWebsiteInput(): StorageAccountStaticWebsite | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageAccountTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageAccountTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
