import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsFunctionJavascriptUdfConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#name StreamAnalyticsFunctionJavascriptUdf#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#resource_group_name StreamAnalyticsFunctionJavascriptUdf#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#script StreamAnalyticsFunctionJavascriptUdf#script}.
     *
     * @stability stable
     */
    readonly script: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#stream_analytics_job_name StreamAnalyticsFunctionJavascriptUdf#stream_analytics_job_name}.
     *
     * @stability stable
     */
    readonly streamAnalyticsJobName: string;
    /**
     * input block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#input StreamAnalyticsFunctionJavascriptUdf#input}
     *
     * @stability stable
     */
    readonly input: StreamAnalyticsFunctionJavascriptUdfInput[];
    /**
     * output block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#output StreamAnalyticsFunctionJavascriptUdf#output}
     *
     * @stability stable
     */
    readonly output: StreamAnalyticsFunctionJavascriptUdfOutput;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#timeouts StreamAnalyticsFunctionJavascriptUdf#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsFunctionJavascriptUdfTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsFunctionJavascriptUdfInput {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#type StreamAnalyticsFunctionJavascriptUdf#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsFunctionJavascriptUdfInputToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdfInput): any;
/**
 * @stability stable
 */
export interface StreamAnalyticsFunctionJavascriptUdfOutput {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#type StreamAnalyticsFunctionJavascriptUdf#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsFunctionJavascriptUdfOutputToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdfOutputOutputReference | StreamAnalyticsFunctionJavascriptUdfOutput): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsFunctionJavascriptUdfOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsFunctionJavascriptUdfOutput | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsFunctionJavascriptUdfOutput | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsFunctionJavascriptUdfTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#create StreamAnalyticsFunctionJavascriptUdf#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#delete StreamAnalyticsFunctionJavascriptUdf#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#read StreamAnalyticsFunctionJavascriptUdf#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#update StreamAnalyticsFunctionJavascriptUdf#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsFunctionJavascriptUdfTimeoutsToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdfTimeoutsOutputReference | StreamAnalyticsFunctionJavascriptUdfTimeouts): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsFunctionJavascriptUdfTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsFunctionJavascriptUdfTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsFunctionJavascriptUdfTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf azurerm_stream_analytics_function_javascript_udf}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsFunctionJavascriptUdf extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf azurerm_stream_analytics_function_javascript_udf} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsFunctionJavascriptUdfConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _script?;
    /**
     * @stability stable
     */
    get script(): string;
    /**
     * @stability stable
     */
    set script(value: string);
    /**
     * @stability stable
     */
    get scriptInput(): string | undefined;
    private _streamAnalyticsJobName?;
    /**
     * @stability stable
     */
    get streamAnalyticsJobName(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsJobName(value: string);
    /**
     * @stability stable
     */
    get streamAnalyticsJobNameInput(): string | undefined;
    private _input?;
    /**
     * @stability stable
     */
    get input(): StreamAnalyticsFunctionJavascriptUdfInput[];
    /**
     * @stability stable
     */
    set input(value: StreamAnalyticsFunctionJavascriptUdfInput[]);
    /**
     * @stability stable
     */
    get inputInput(): StreamAnalyticsFunctionJavascriptUdfInput[] | undefined;
    private _output;
    /**
     * @stability stable
     */
    get output(): StreamAnalyticsFunctionJavascriptUdfOutputOutputReference;
    /**
     * @stability stable
     */
    putOutput(value: StreamAnalyticsFunctionJavascriptUdfOutput): void;
    /**
     * @stability stable
     */
    get outputInput(): StreamAnalyticsFunctionJavascriptUdfOutput | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsFunctionJavascriptUdfTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsFunctionJavascriptUdfTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsFunctionJavascriptUdfTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
