import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#name SynapseSqlPoolVulnerabilityAssessmentBaseline#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#rule_name SynapseSqlPoolVulnerabilityAssessmentBaseline#rule_name}.
     *
     * @stability stable
     */
    readonly ruleName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#sql_pool_vulnerability_assessment_id SynapseSqlPoolVulnerabilityAssessmentBaseline#sql_pool_vulnerability_assessment_id}.
     *
     * @stability stable
     */
    readonly sqlPoolVulnerabilityAssessmentId: string;
    /**
     * baseline block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#baseline SynapseSqlPoolVulnerabilityAssessmentBaseline#baseline}
     *
     * @stability stable
     */
    readonly baseline?: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#timeouts SynapseSqlPoolVulnerabilityAssessmentBaseline#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#result SynapseSqlPoolVulnerabilityAssessmentBaseline#result}.
     *
     * @stability stable
     */
    readonly result: string[];
}
export declare function synapseSqlPoolVulnerabilityAssessmentBaselineBaselineToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline): any;
/**
 * @stability stable
 */
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#create SynapseSqlPoolVulnerabilityAssessmentBaseline#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#delete SynapseSqlPoolVulnerabilityAssessmentBaseline#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#read SynapseSqlPoolVulnerabilityAssessmentBaseline#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#update SynapseSqlPoolVulnerabilityAssessmentBaseline#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference | SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline azurerm_synapse_sql_pool_vulnerability_assessment_baseline}.
 *
 * @stability stable
 */
export declare class SynapseSqlPoolVulnerabilityAssessmentBaseline extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline azurerm_synapse_sql_pool_vulnerability_assessment_baseline} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolVulnerabilityAssessmentBaselineConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _ruleName?;
    /**
     * @stability stable
     */
    get ruleName(): string;
    /**
     * @stability stable
     */
    set ruleName(value: string);
    /**
     * @stability stable
     */
    get ruleNameInput(): string | undefined;
    private _sqlPoolVulnerabilityAssessmentId?;
    /**
     * @stability stable
     */
    get sqlPoolVulnerabilityAssessmentId(): string;
    /**
     * @stability stable
     */
    set sqlPoolVulnerabilityAssessmentId(value: string);
    /**
     * @stability stable
     */
    get sqlPoolVulnerabilityAssessmentIdInput(): string | undefined;
    private _baseline?;
    /**
     * @stability stable
     */
    get baseline(): SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[];
    /**
     * @stability stable
     */
    set baseline(value: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[]);
    /**
     * @stability stable
     */
    resetBaseline(): void;
    /**
     * @stability stable
     */
    get baselineInput(): SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
