import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseSqlPoolWorkloadGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#importance SynapseSqlPoolWorkloadGroup#importance}.
     *
     * @stability stable
     */
    readonly importance?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#max_resource_percent SynapseSqlPoolWorkloadGroup#max_resource_percent}.
     *
     * @stability stable
     */
    readonly maxResourcePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#max_resource_percent_per_request SynapseSqlPoolWorkloadGroup#max_resource_percent_per_request}.
     *
     * @stability stable
     */
    readonly maxResourcePercentPerRequest?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#min_resource_percent SynapseSqlPoolWorkloadGroup#min_resource_percent}.
     *
     * @stability stable
     */
    readonly minResourcePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#min_resource_percent_per_request SynapseSqlPoolWorkloadGroup#min_resource_percent_per_request}.
     *
     * @stability stable
     */
    readonly minResourcePercentPerRequest?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#name SynapseSqlPoolWorkloadGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#query_execution_timeout_in_seconds SynapseSqlPoolWorkloadGroup#query_execution_timeout_in_seconds}.
     *
     * @stability stable
     */
    readonly queryExecutionTimeoutInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#sql_pool_id SynapseSqlPoolWorkloadGroup#sql_pool_id}.
     *
     * @stability stable
     */
    readonly sqlPoolId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#timeouts SynapseSqlPoolWorkloadGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseSqlPoolWorkloadGroupTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseSqlPoolWorkloadGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#create SynapseSqlPoolWorkloadGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#delete SynapseSqlPoolWorkloadGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#read SynapseSqlPoolWorkloadGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#update SynapseSqlPoolWorkloadGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseSqlPoolWorkloadGroupTimeoutsToTerraform(struct?: SynapseSqlPoolWorkloadGroupTimeoutsOutputReference | SynapseSqlPoolWorkloadGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseSqlPoolWorkloadGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSqlPoolWorkloadGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSqlPoolWorkloadGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group azurerm_synapse_sql_pool_workload_group}.
 *
 * @stability stable
 */
export declare class SynapseSqlPoolWorkloadGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group azurerm_synapse_sql_pool_workload_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolWorkloadGroupConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _importance?;
    /**
     * @stability stable
     */
    get importance(): string;
    /**
     * @stability stable
     */
    set importance(value: string);
    /**
     * @stability stable
     */
    resetImportance(): void;
    /**
     * @stability stable
     */
    get importanceInput(): string | undefined;
    private _maxResourcePercent?;
    /**
     * @stability stable
     */
    get maxResourcePercent(): number;
    /**
     * @stability stable
     */
    set maxResourcePercent(value: number);
    /**
     * @stability stable
     */
    get maxResourcePercentInput(): number | undefined;
    private _maxResourcePercentPerRequest?;
    /**
     * @stability stable
     */
    get maxResourcePercentPerRequest(): number;
    /**
     * @stability stable
     */
    set maxResourcePercentPerRequest(value: number);
    /**
     * @stability stable
     */
    resetMaxResourcePercentPerRequest(): void;
    /**
     * @stability stable
     */
    get maxResourcePercentPerRequestInput(): number | undefined;
    private _minResourcePercent?;
    /**
     * @stability stable
     */
    get minResourcePercent(): number;
    /**
     * @stability stable
     */
    set minResourcePercent(value: number);
    /**
     * @stability stable
     */
    get minResourcePercentInput(): number | undefined;
    private _minResourcePercentPerRequest?;
    /**
     * @stability stable
     */
    get minResourcePercentPerRequest(): number;
    /**
     * @stability stable
     */
    set minResourcePercentPerRequest(value: number);
    /**
     * @stability stable
     */
    resetMinResourcePercentPerRequest(): void;
    /**
     * @stability stable
     */
    get minResourcePercentPerRequestInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _queryExecutionTimeoutInSeconds?;
    /**
     * @stability stable
     */
    get queryExecutionTimeoutInSeconds(): number;
    /**
     * @stability stable
     */
    set queryExecutionTimeoutInSeconds(value: number);
    /**
     * @stability stable
     */
    resetQueryExecutionTimeoutInSeconds(): void;
    /**
     * @stability stable
     */
    get queryExecutionTimeoutInSecondsInput(): number | undefined;
    private _sqlPoolId?;
    /**
     * @stability stable
     */
    get sqlPoolId(): string;
    /**
     * @stability stable
     */
    set sqlPoolId(value: string);
    /**
     * @stability stable
     */
    get sqlPoolIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseSqlPoolWorkloadGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseSqlPoolWorkloadGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseSqlPoolWorkloadGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
