import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseWorkspaceKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#active SynapseWorkspaceKey#active}.
     *
     * @stability stable
     */
    readonly active: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#cusomter_managed_key_name SynapseWorkspaceKey#cusomter_managed_key_name}.
     *
     * @stability stable
     */
    readonly cusomterManagedKeyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#customer_managed_key_name SynapseWorkspaceKey#customer_managed_key_name}.
     *
     * @stability stable
     */
    readonly customerManagedKeyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#customer_managed_key_versionless_id SynapseWorkspaceKey#customer_managed_key_versionless_id}.
     *
     * @stability stable
     */
    readonly customerManagedKeyVersionlessId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#synapse_workspace_id SynapseWorkspaceKey#synapse_workspace_id}.
     *
     * @stability stable
     */
    readonly synapseWorkspaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#timeouts SynapseWorkspaceKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseWorkspaceKeyTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#create SynapseWorkspaceKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#delete SynapseWorkspaceKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#read SynapseWorkspaceKey#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#update SynapseWorkspaceKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseWorkspaceKeyTimeoutsToTerraform(struct?: SynapseWorkspaceKeyTimeoutsOutputReference | SynapseWorkspaceKeyTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceKeyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key azurerm_synapse_workspace_key}.
 *
 * @stability stable
 */
export declare class SynapseWorkspaceKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key azurerm_synapse_workspace_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceKeyConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _cusomterManagedKeyName?;
    /**
     * @stability stable
     */
    get cusomterManagedKeyName(): string;
    /**
     * @stability stable
     */
    set cusomterManagedKeyName(value: string);
    /**
     * @stability stable
     */
    resetCusomterManagedKeyName(): void;
    /**
     * @stability stable
     */
    get cusomterManagedKeyNameInput(): string | undefined;
    private _customerManagedKeyName?;
    /**
     * @stability stable
     */
    get customerManagedKeyName(): string;
    /**
     * @stability stable
     */
    set customerManagedKeyName(value: string);
    /**
     * @stability stable
     */
    resetCustomerManagedKeyName(): void;
    /**
     * @stability stable
     */
    get customerManagedKeyNameInput(): string | undefined;
    private _customerManagedKeyVersionlessId?;
    /**
     * @stability stable
     */
    get customerManagedKeyVersionlessId(): string;
    /**
     * @stability stable
     */
    set customerManagedKeyVersionlessId(value: string);
    /**
     * @stability stable
     */
    resetCustomerManagedKeyVersionlessId(): void;
    /**
     * @stability stable
     */
    get customerManagedKeyVersionlessIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _synapseWorkspaceId?;
    /**
     * @stability stable
     */
    get synapseWorkspaceId(): string;
    /**
     * @stability stable
     */
    set synapseWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get synapseWorkspaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseWorkspaceKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseWorkspaceKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseWorkspaceKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
