import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseWorkspaceVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#storage_account_access_key SynapseWorkspaceVulnerabilityAssessment#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#storage_container_path SynapseWorkspaceVulnerabilityAssessment#storage_container_path}.
     *
     * @stability stable
     */
    readonly storageContainerPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#storage_container_sas_key SynapseWorkspaceVulnerabilityAssessment#storage_container_sas_key}.
     *
     * @stability stable
     */
    readonly storageContainerSasKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#workspace_security_alert_policy_id SynapseWorkspaceVulnerabilityAssessment#workspace_security_alert_policy_id}.
     *
     * @stability stable
     */
    readonly workspaceSecurityAlertPolicyId: string;
    /**
     * recurring_scans block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#recurring_scans SynapseWorkspaceVulnerabilityAssessment#recurring_scans}
     *
     * @stability stable
     */
    readonly recurringScans?: SynapseWorkspaceVulnerabilityAssessmentRecurringScans;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#timeouts SynapseWorkspaceVulnerabilityAssessment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseWorkspaceVulnerabilityAssessmentTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceVulnerabilityAssessmentRecurringScans {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#email_subscription_admins_enabled SynapseWorkspaceVulnerabilityAssessment#email_subscription_admins_enabled}.
     *
     * @stability stable
     */
    readonly emailSubscriptionAdminsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#emails SynapseWorkspaceVulnerabilityAssessment#emails}.
     *
     * @stability stable
     */
    readonly emails?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#enabled SynapseWorkspaceVulnerabilityAssessment#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function synapseWorkspaceVulnerabilityAssessmentRecurringScansToTerraform(struct?: SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference | SynapseWorkspaceVulnerabilityAssessmentRecurringScans): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceVulnerabilityAssessmentRecurringScans | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceVulnerabilityAssessmentRecurringScans | undefined);
    private _emailSubscriptionAdminsEnabled?;
    /**
     * @stability stable
     */
    get emailSubscriptionAdminsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailSubscriptionAdminsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailSubscriptionAdminsEnabled(): void;
    /**
     * @stability stable
     */
    get emailSubscriptionAdminsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _emails?;
    /**
     * @stability stable
     */
    get emails(): string[];
    /**
     * @stability stable
     */
    set emails(value: string[]);
    /**
     * @stability stable
     */
    resetEmails(): void;
    /**
     * @stability stable
     */
    get emailsInput(): string[] | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceVulnerabilityAssessmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#create SynapseWorkspaceVulnerabilityAssessment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#delete SynapseWorkspaceVulnerabilityAssessment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#read SynapseWorkspaceVulnerabilityAssessment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment#update SynapseWorkspaceVulnerabilityAssessment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseWorkspaceVulnerabilityAssessmentTimeoutsToTerraform(struct?: SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference | SynapseWorkspaceVulnerabilityAssessmentTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceVulnerabilityAssessmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment azurerm_synapse_workspace_vulnerability_assessment}.
 *
 * @stability stable
 */
export declare class SynapseWorkspaceVulnerabilityAssessment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_vulnerability_assessment azurerm_synapse_workspace_vulnerability_assessment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceVulnerabilityAssessmentConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageContainerPath?;
    /**
     * @stability stable
     */
    get storageContainerPath(): string;
    /**
     * @stability stable
     */
    set storageContainerPath(value: string);
    /**
     * @stability stable
     */
    get storageContainerPathInput(): string | undefined;
    private _storageContainerSasKey?;
    /**
     * @stability stable
     */
    get storageContainerSasKey(): string;
    /**
     * @stability stable
     */
    set storageContainerSasKey(value: string);
    /**
     * @stability stable
     */
    resetStorageContainerSasKey(): void;
    /**
     * @stability stable
     */
    get storageContainerSasKeyInput(): string | undefined;
    private _workspaceSecurityAlertPolicyId?;
    /**
     * @stability stable
     */
    get workspaceSecurityAlertPolicyId(): string;
    /**
     * @stability stable
     */
    set workspaceSecurityAlertPolicyId(value: string);
    /**
     * @stability stable
     */
    get workspaceSecurityAlertPolicyIdInput(): string | undefined;
    private _recurringScans;
    /**
     * @stability stable
     */
    get recurringScans(): SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference;
    /**
     * @stability stable
     */
    putRecurringScans(value: SynapseWorkspaceVulnerabilityAssessmentRecurringScans): void;
    /**
     * @stability stable
     */
    resetRecurringScans(): void;
    /**
     * @stability stable
     */
    get recurringScansInput(): SynapseWorkspaceVulnerabilityAssessmentRecurringScans | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseWorkspaceVulnerabilityAssessmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseWorkspaceVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
