import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TenantTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#debug_level TenantTemplateDeployment#debug_level}.
     *
     * @stability stable
     */
    readonly debugLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#location TenantTemplateDeployment#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#name TenantTemplateDeployment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#parameters_content TenantTemplateDeployment#parameters_content}.
     *
     * @stability stable
     */
    readonly parametersContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#tags TenantTemplateDeployment#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#template_content TenantTemplateDeployment#template_content}.
     *
     * @stability stable
     */
    readonly templateContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#template_spec_version_id TenantTemplateDeployment#template_spec_version_id}.
     *
     * @stability stable
     */
    readonly templateSpecVersionId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#timeouts TenantTemplateDeployment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TenantTemplateDeploymentTimeouts;
}
/**
 * @stability stable
 */
export interface TenantTemplateDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#create TenantTemplateDeployment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#delete TenantTemplateDeployment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#read TenantTemplateDeployment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment#update TenantTemplateDeployment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function tenantTemplateDeploymentTimeoutsToTerraform(struct?: TenantTemplateDeploymentTimeoutsOutputReference | TenantTemplateDeploymentTimeouts): any;
/**
 * @stability stable
 */
export declare class TenantTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TenantTemplateDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TenantTemplateDeploymentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment azurerm_tenant_template_deployment}.
 *
 * @stability stable
 */
export declare class TenantTemplateDeployment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/tenant_template_deployment azurerm_tenant_template_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TenantTemplateDeploymentConfig);
    private _debugLevel?;
    /**
     * @stability stable
     */
    get debugLevel(): string;
    /**
     * @stability stable
     */
    set debugLevel(value: string);
    /**
     * @stability stable
     */
    resetDebugLevel(): void;
    /**
     * @stability stable
     */
    get debugLevelInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outputContent(): string;
    private _parametersContent?;
    /**
     * @stability stable
     */
    get parametersContent(): string;
    /**
     * @stability stable
     */
    set parametersContent(value: string);
    /**
     * @stability stable
     */
    resetParametersContent(): void;
    /**
     * @stability stable
     */
    get parametersContentInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _templateContent?;
    /**
     * @stability stable
     */
    get templateContent(): string;
    /**
     * @stability stable
     */
    set templateContent(value: string);
    /**
     * @stability stable
     */
    resetTemplateContent(): void;
    /**
     * @stability stable
     */
    get templateContentInput(): string | undefined;
    private _templateSpecVersionId?;
    /**
     * @stability stable
     */
    get templateSpecVersionId(): string;
    /**
     * @stability stable
     */
    set templateSpecVersionId(value: string);
    /**
     * @stability stable
     */
    resetTemplateSpecVersionId(): void;
    /**
     * @stability stable
     */
    get templateSpecVersionIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TenantTemplateDeploymentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TenantTemplateDeploymentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TenantTemplateDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
