import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualDesktopHostPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#custom_rdp_properties VirtualDesktopHostPool#custom_rdp_properties}.
     *
     * @stability stable
     */
    readonly customRdpProperties?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#description VirtualDesktopHostPool#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#friendly_name VirtualDesktopHostPool#friendly_name}.
     *
     * @stability stable
     */
    readonly friendlyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#load_balancer_type VirtualDesktopHostPool#load_balancer_type}.
     *
     * @stability stable
     */
    readonly loadBalancerType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#location VirtualDesktopHostPool#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#maximum_sessions_allowed VirtualDesktopHostPool#maximum_sessions_allowed}.
     *
     * @stability stable
     */
    readonly maximumSessionsAllowed?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#name VirtualDesktopHostPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#personal_desktop_assignment_type VirtualDesktopHostPool#personal_desktop_assignment_type}.
     *
     * @stability stable
     */
    readonly personalDesktopAssignmentType?: string;
    /**
     * Preferred App Group type to display.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#preferred_app_group_type VirtualDesktopHostPool#preferred_app_group_type}
     *
     * @stability stable
     */
    readonly preferredAppGroupType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#resource_group_name VirtualDesktopHostPool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#start_vm_on_connect VirtualDesktopHostPool#start_vm_on_connect}.
     *
     * @stability stable
     */
    readonly startVmOnConnect?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#tags VirtualDesktopHostPool#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#type VirtualDesktopHostPool#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#validate_environment VirtualDesktopHostPool#validate_environment}.
     *
     * @stability stable
     */
    readonly validateEnvironment?: boolean | cdktf.IResolvable;
    /**
     * registration_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#registration_info VirtualDesktopHostPool#registration_info}
     *
     * @stability stable
     */
    readonly registrationInfo?: VirtualDesktopHostPoolRegistrationInfo;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#timeouts VirtualDesktopHostPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualDesktopHostPoolTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualDesktopHostPoolRegistrationInfo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#expiration_date VirtualDesktopHostPool#expiration_date}.
     *
     * @stability stable
     */
    readonly expirationDate: string;
}
export declare function virtualDesktopHostPoolRegistrationInfoToTerraform(struct?: VirtualDesktopHostPoolRegistrationInfoOutputReference | VirtualDesktopHostPoolRegistrationInfo): any;
/**
 * @stability stable
 */
export declare class VirtualDesktopHostPoolRegistrationInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualDesktopHostPoolRegistrationInfo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualDesktopHostPoolRegistrationInfo | undefined);
    private _expirationDate?;
    /**
     * @stability stable
     */
    get expirationDate(): string;
    /**
     * @stability stable
     */
    set expirationDate(value: string);
    /**
     * @stability stable
     */
    get expirationDateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualDesktopHostPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#create VirtualDesktopHostPool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#delete VirtualDesktopHostPool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#read VirtualDesktopHostPool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool#update VirtualDesktopHostPool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualDesktopHostPoolTimeoutsToTerraform(struct?: VirtualDesktopHostPoolTimeoutsOutputReference | VirtualDesktopHostPoolTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualDesktopHostPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualDesktopHostPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualDesktopHostPoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool azurerm_virtual_desktop_host_pool}.
 *
 * @stability stable
 */
export declare class VirtualDesktopHostPool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool azurerm_virtual_desktop_host_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualDesktopHostPoolConfig);
    private _customRdpProperties?;
    /**
     * @stability stable
     */
    get customRdpProperties(): string;
    /**
     * @stability stable
     */
    set customRdpProperties(value: string);
    /**
     * @stability stable
     */
    resetCustomRdpProperties(): void;
    /**
     * @stability stable
     */
    get customRdpPropertiesInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _friendlyName?;
    /**
     * @stability stable
     */
    get friendlyName(): string;
    /**
     * @stability stable
     */
    set friendlyName(value: string);
    /**
     * @stability stable
     */
    resetFriendlyName(): void;
    /**
     * @stability stable
     */
    get friendlyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadBalancerType?;
    /**
     * @stability stable
     */
    get loadBalancerType(): string;
    /**
     * @stability stable
     */
    set loadBalancerType(value: string);
    /**
     * @stability stable
     */
    get loadBalancerTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maximumSessionsAllowed?;
    /**
     * @stability stable
     */
    get maximumSessionsAllowed(): number;
    /**
     * @stability stable
     */
    set maximumSessionsAllowed(value: number);
    /**
     * @stability stable
     */
    resetMaximumSessionsAllowed(): void;
    /**
     * @stability stable
     */
    get maximumSessionsAllowedInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _personalDesktopAssignmentType?;
    /**
     * @stability stable
     */
    get personalDesktopAssignmentType(): string;
    /**
     * @stability stable
     */
    set personalDesktopAssignmentType(value: string);
    /**
     * @stability stable
     */
    resetPersonalDesktopAssignmentType(): void;
    /**
     * @stability stable
     */
    get personalDesktopAssignmentTypeInput(): string | undefined;
    private _preferredAppGroupType?;
    /**
     * @stability stable
     */
    get preferredAppGroupType(): string;
    /**
     * @stability stable
     */
    set preferredAppGroupType(value: string);
    /**
     * @stability stable
     */
    resetPreferredAppGroupType(): void;
    /**
     * @stability stable
     */
    get preferredAppGroupTypeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _startVmOnConnect?;
    /**
     * @stability stable
     */
    get startVmOnConnect(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set startVmOnConnect(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStartVmOnConnect(): void;
    /**
     * @stability stable
     */
    get startVmOnConnectInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _validateEnvironment?;
    /**
     * @stability stable
     */
    get validateEnvironment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set validateEnvironment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValidateEnvironment(): void;
    /**
     * @stability stable
     */
    get validateEnvironmentInput(): boolean | cdktf.IResolvable | undefined;
    private _registrationInfo;
    /**
     * @stability stable
     */
    get registrationInfo(): VirtualDesktopHostPoolRegistrationInfoOutputReference;
    /**
     * @stability stable
     */
    putRegistrationInfo(value: VirtualDesktopHostPoolRegistrationInfo): void;
    /**
     * @stability stable
     */
    resetRegistrationInfo(): void;
    /**
     * @stability stable
     */
    get registrationInfoInput(): VirtualDesktopHostPoolRegistrationInfo | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualDesktopHostPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualDesktopHostPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualDesktopHostPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
