import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualHubRouteTableRouteAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#destinations VirtualHubRouteTableRouteA#destinations}.
     *
     * @stability stable
     */
    readonly destinations: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#destinations_type VirtualHubRouteTableRouteA#destinations_type}.
     *
     * @stability stable
     */
    readonly destinationsType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#name VirtualHubRouteTableRouteA#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#next_hop VirtualHubRouteTableRouteA#next_hop}.
     *
     * @stability stable
     */
    readonly nextHop: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#next_hop_type VirtualHubRouteTableRouteA#next_hop_type}.
     *
     * @stability stable
     */
    readonly nextHopType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#route_table_id VirtualHubRouteTableRouteA#route_table_id}.
     *
     * @stability stable
     */
    readonly routeTableId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#timeouts VirtualHubRouteTableRouteA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualHubRouteTableRouteTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualHubRouteTableRouteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#create VirtualHubRouteTableRouteA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#delete VirtualHubRouteTableRouteA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#read VirtualHubRouteTableRouteA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route#update VirtualHubRouteTableRouteA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualHubRouteTableRouteTimeoutsToTerraform(struct?: VirtualHubRouteTableRouteTimeoutsOutputReference | VirtualHubRouteTableRouteTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualHubRouteTableRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualHubRouteTableRouteTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualHubRouteTableRouteTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route azurerm_virtual_hub_route_table_route}.
 *
 * @stability stable
 */
export declare class VirtualHubRouteTableRouteA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table_route azurerm_virtual_hub_route_table_route} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualHubRouteTableRouteAConfig);
    private _destinations?;
    /**
     * @stability stable
     */
    get destinations(): string[];
    /**
     * @stability stable
     */
    set destinations(value: string[]);
    /**
     * @stability stable
     */
    get destinationsInput(): string[] | undefined;
    private _destinationsType?;
    /**
     * @stability stable
     */
    get destinationsType(): string;
    /**
     * @stability stable
     */
    set destinationsType(value: string);
    /**
     * @stability stable
     */
    get destinationsTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nextHop?;
    /**
     * @stability stable
     */
    get nextHop(): string;
    /**
     * @stability stable
     */
    set nextHop(value: string);
    /**
     * @stability stable
     */
    get nextHopInput(): string | undefined;
    private _nextHopType?;
    /**
     * @stability stable
     */
    get nextHopType(): string;
    /**
     * @stability stable
     */
    set nextHopType(value: string);
    /**
     * @stability stable
     */
    resetNextHopType(): void;
    /**
     * @stability stable
     */
    get nextHopTypeInput(): string | undefined;
    private _routeTableId?;
    /**
     * @stability stable
     */
    get routeTableId(): string;
    /**
     * @stability stable
     */
    set routeTableId(value: string);
    /**
     * @stability stable
     */
    get routeTableIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualHubRouteTableRouteTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualHubRouteTableRouteTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualHubRouteTableRouteTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
