import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#active_active VirtualNetworkGateway#active_active}.
     *
     * @stability stable
     */
    readonly activeActive?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#default_local_network_gateway_id VirtualNetworkGateway#default_local_network_gateway_id}.
     *
     * @stability stable
     */
    readonly defaultLocalNetworkGatewayId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#enable_bgp VirtualNetworkGateway#enable_bgp}.
     *
     * @stability stable
     */
    readonly enableBgp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#generation VirtualNetworkGateway#generation}.
     *
     * @stability stable
     */
    readonly generation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#location VirtualNetworkGateway#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#name VirtualNetworkGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#private_ip_address_enabled VirtualNetworkGateway#private_ip_address_enabled}.
     *
     * @stability stable
     */
    readonly privateIpAddressEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#resource_group_name VirtualNetworkGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#sku VirtualNetworkGateway#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#tags VirtualNetworkGateway#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#type VirtualNetworkGateway#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#vpn_type VirtualNetworkGateway#vpn_type}.
     *
     * @stability stable
     */
    readonly vpnType?: string;
    /**
     * bgp_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#bgp_settings VirtualNetworkGateway#bgp_settings}
     *
     * @stability stable
     */
    readonly bgpSettings?: VirtualNetworkGatewayBgpSettings;
    /**
     * custom_route block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#custom_route VirtualNetworkGateway#custom_route}
     *
     * @stability stable
     */
    readonly customRoute?: VirtualNetworkGatewayCustomRoute;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#ip_configuration VirtualNetworkGateway#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: VirtualNetworkGatewayIpConfiguration[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#timeouts VirtualNetworkGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualNetworkGatewayTimeouts;
    /**
     * vpn_client_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#vpn_client_configuration VirtualNetworkGateway#vpn_client_configuration}
     *
     * @stability stable
     */
    readonly vpnClientConfiguration?: VirtualNetworkGatewayVpnClientConfiguration;
}
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayBgpSettingsPeeringAddresses {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#apipa_addresses VirtualNetworkGateway#apipa_addresses}.
     *
     * @stability stable
     */
    readonly apipaAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#ip_configuration_name VirtualNetworkGateway#ip_configuration_name}.
     *
     * @stability stable
     */
    readonly ipConfigurationName?: string;
}
export declare function virtualNetworkGatewayBgpSettingsPeeringAddressesToTerraform(struct?: VirtualNetworkGatewayBgpSettingsPeeringAddresses): any;
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayBgpSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#asn VirtualNetworkGateway#asn}.
     *
     * @stability stable
     */
    readonly asn?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#peer_weight VirtualNetworkGateway#peer_weight}.
     *
     * @stability stable
     */
    readonly peerWeight?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#peering_address VirtualNetworkGateway#peering_address}.
     *
     * @stability stable
     */
    readonly peeringAddress?: string;
    /**
     * peering_addresses block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#peering_addresses VirtualNetworkGateway#peering_addresses}
     *
     * @stability stable
     */
    readonly peeringAddresses?: VirtualNetworkGatewayBgpSettingsPeeringAddresses[];
}
export declare function virtualNetworkGatewayBgpSettingsToTerraform(struct?: VirtualNetworkGatewayBgpSettingsOutputReference | VirtualNetworkGatewayBgpSettings): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkGatewayBgpSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkGatewayBgpSettings | undefined);
    private _asn?;
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    set asn(value: number);
    /**
     * @stability stable
     */
    resetAsn(): void;
    /**
     * @stability stable
     */
    get asnInput(): number | undefined;
    private _peerWeight?;
    /**
     * @stability stable
     */
    get peerWeight(): number;
    /**
     * @stability stable
     */
    set peerWeight(value: number);
    /**
     * @stability stable
     */
    resetPeerWeight(): void;
    /**
     * @stability stable
     */
    get peerWeightInput(): number | undefined;
    private _peeringAddress?;
    /**
     * @stability stable
     */
    get peeringAddress(): string;
    /**
     * @stability stable
     */
    set peeringAddress(value: string);
    /**
     * @stability stable
     */
    resetPeeringAddress(): void;
    /**
     * @stability stable
     */
    get peeringAddressInput(): string | undefined;
    private _peeringAddresses?;
    /**
     * @stability stable
     */
    get peeringAddresses(): VirtualNetworkGatewayBgpSettingsPeeringAddresses[];
    /**
     * @stability stable
     */
    set peeringAddresses(value: VirtualNetworkGatewayBgpSettingsPeeringAddresses[]);
    /**
     * @stability stable
     */
    resetPeeringAddresses(): void;
    /**
     * @stability stable
     */
    get peeringAddressesInput(): VirtualNetworkGatewayBgpSettingsPeeringAddresses[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayCustomRoute {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#address_prefixes VirtualNetworkGateway#address_prefixes}.
     *
     * @stability stable
     */
    readonly addressPrefixes?: string[];
}
export declare function virtualNetworkGatewayCustomRouteToTerraform(struct?: VirtualNetworkGatewayCustomRouteOutputReference | VirtualNetworkGatewayCustomRoute): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkGatewayCustomRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkGatewayCustomRoute | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkGatewayCustomRoute | undefined);
    private _addressPrefixes?;
    /**
     * @stability stable
     */
    get addressPrefixes(): string[];
    /**
     * @stability stable
     */
    set addressPrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetAddressPrefixes(): void;
    /**
     * @stability stable
     */
    get addressPrefixesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#name VirtualNetworkGateway#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#private_ip_address_allocation VirtualNetworkGateway#private_ip_address_allocation}.
     *
     * @stability stable
     */
    readonly privateIpAddressAllocation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#public_ip_address_id VirtualNetworkGateway#public_ip_address_id}.
     *
     * @stability stable
     */
    readonly publicIpAddressId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#subnet_id VirtualNetworkGateway#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function virtualNetworkGatewayIpConfigurationToTerraform(struct?: VirtualNetworkGatewayIpConfiguration): any;
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#create VirtualNetworkGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#delete VirtualNetworkGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#read VirtualNetworkGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#update VirtualNetworkGateway#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualNetworkGatewayTimeoutsToTerraform(struct?: VirtualNetworkGatewayTimeoutsOutputReference | VirtualNetworkGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#name VirtualNetworkGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#thumbprint VirtualNetworkGateway#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function virtualNetworkGatewayVpnClientConfigurationRevokedCertificateToTerraform(struct?: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate): any;
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayVpnClientConfigurationRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#name VirtualNetworkGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#public_cert_data VirtualNetworkGateway#public_cert_data}.
     *
     * @stability stable
     */
    readonly publicCertData: string;
}
export declare function virtualNetworkGatewayVpnClientConfigurationRootCertificateToTerraform(struct?: VirtualNetworkGatewayVpnClientConfigurationRootCertificate): any;
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayVpnClientConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#aad_audience VirtualNetworkGateway#aad_audience}.
     *
     * @stability stable
     */
    readonly aadAudience?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#aad_issuer VirtualNetworkGateway#aad_issuer}.
     *
     * @stability stable
     */
    readonly aadIssuer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#aad_tenant VirtualNetworkGateway#aad_tenant}.
     *
     * @stability stable
     */
    readonly aadTenant?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#address_space VirtualNetworkGateway#address_space}.
     *
     * @stability stable
     */
    readonly addressSpace: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#radius_server_address VirtualNetworkGateway#radius_server_address}.
     *
     * @stability stable
     */
    readonly radiusServerAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#radius_server_secret VirtualNetworkGateway#radius_server_secret}.
     *
     * @stability stable
     */
    readonly radiusServerSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#vpn_auth_types VirtualNetworkGateway#vpn_auth_types}.
     *
     * @stability stable
     */
    readonly vpnAuthTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#vpn_client_protocols VirtualNetworkGateway#vpn_client_protocols}.
     *
     * @stability stable
     */
    readonly vpnClientProtocols?: string[];
    /**
     * revoked_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#revoked_certificate VirtualNetworkGateway#revoked_certificate}
     *
     * @stability stable
     */
    readonly revokedCertificate?: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[];
    /**
     * root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway#root_certificate VirtualNetworkGateway#root_certificate}
     *
     * @stability stable
     */
    readonly rootCertificate?: VirtualNetworkGatewayVpnClientConfigurationRootCertificate[];
}
export declare function virtualNetworkGatewayVpnClientConfigurationToTerraform(struct?: VirtualNetworkGatewayVpnClientConfigurationOutputReference | VirtualNetworkGatewayVpnClientConfiguration): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkGatewayVpnClientConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkGatewayVpnClientConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkGatewayVpnClientConfiguration | undefined);
    private _aadAudience?;
    /**
     * @stability stable
     */
    get aadAudience(): string;
    /**
     * @stability stable
     */
    set aadAudience(value: string);
    /**
     * @stability stable
     */
    resetAadAudience(): void;
    /**
     * @stability stable
     */
    get aadAudienceInput(): string | undefined;
    private _aadIssuer?;
    /**
     * @stability stable
     */
    get aadIssuer(): string;
    /**
     * @stability stable
     */
    set aadIssuer(value: string);
    /**
     * @stability stable
     */
    resetAadIssuer(): void;
    /**
     * @stability stable
     */
    get aadIssuerInput(): string | undefined;
    private _aadTenant?;
    /**
     * @stability stable
     */
    get aadTenant(): string;
    /**
     * @stability stable
     */
    set aadTenant(value: string);
    /**
     * @stability stable
     */
    resetAadTenant(): void;
    /**
     * @stability stable
     */
    get aadTenantInput(): string | undefined;
    private _addressSpace?;
    /**
     * @stability stable
     */
    get addressSpace(): string[];
    /**
     * @stability stable
     */
    set addressSpace(value: string[]);
    /**
     * @stability stable
     */
    get addressSpaceInput(): string[] | undefined;
    private _radiusServerAddress?;
    /**
     * @stability stable
     */
    get radiusServerAddress(): string;
    /**
     * @stability stable
     */
    set radiusServerAddress(value: string);
    /**
     * @stability stable
     */
    resetRadiusServerAddress(): void;
    /**
     * @stability stable
     */
    get radiusServerAddressInput(): string | undefined;
    private _radiusServerSecret?;
    /**
     * @stability stable
     */
    get radiusServerSecret(): string;
    /**
     * @stability stable
     */
    set radiusServerSecret(value: string);
    /**
     * @stability stable
     */
    resetRadiusServerSecret(): void;
    /**
     * @stability stable
     */
    get radiusServerSecretInput(): string | undefined;
    private _vpnAuthTypes?;
    /**
     * @stability stable
     */
    get vpnAuthTypes(): string[];
    /**
     * @stability stable
     */
    set vpnAuthTypes(value: string[]);
    /**
     * @stability stable
     */
    resetVpnAuthTypes(): void;
    /**
     * @stability stable
     */
    get vpnAuthTypesInput(): string[] | undefined;
    private _vpnClientProtocols?;
    /**
     * @stability stable
     */
    get vpnClientProtocols(): string[];
    /**
     * @stability stable
     */
    set vpnClientProtocols(value: string[]);
    /**
     * @stability stable
     */
    resetVpnClientProtocols(): void;
    /**
     * @stability stable
     */
    get vpnClientProtocolsInput(): string[] | undefined;
    private _revokedCertificate?;
    /**
     * @stability stable
     */
    get revokedCertificate(): VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[];
    /**
     * @stability stable
     */
    set revokedCertificate(value: VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[]);
    /**
     * @stability stable
     */
    resetRevokedCertificate(): void;
    /**
     * @stability stable
     */
    get revokedCertificateInput(): VirtualNetworkGatewayVpnClientConfigurationRevokedCertificate[] | undefined;
    private _rootCertificate?;
    /**
     * @stability stable
     */
    get rootCertificate(): VirtualNetworkGatewayVpnClientConfigurationRootCertificate[];
    /**
     * @stability stable
     */
    set rootCertificate(value: VirtualNetworkGatewayVpnClientConfigurationRootCertificate[]);
    /**
     * @stability stable
     */
    resetRootCertificate(): void;
    /**
     * @stability stable
     */
    get rootCertificateInput(): VirtualNetworkGatewayVpnClientConfigurationRootCertificate[] | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway azurerm_virtual_network_gateway}.
 *
 * @stability stable
 */
export declare class VirtualNetworkGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway azurerm_virtual_network_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualNetworkGatewayConfig);
    private _activeActive?;
    /**
     * @stability stable
     */
    get activeActive(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set activeActive(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActiveActive(): void;
    /**
     * @stability stable
     */
    get activeActiveInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultLocalNetworkGatewayId?;
    /**
     * @stability stable
     */
    get defaultLocalNetworkGatewayId(): string;
    /**
     * @stability stable
     */
    set defaultLocalNetworkGatewayId(value: string);
    /**
     * @stability stable
     */
    resetDefaultLocalNetworkGatewayId(): void;
    /**
     * @stability stable
     */
    get defaultLocalNetworkGatewayIdInput(): string | undefined;
    private _enableBgp?;
    /**
     * @stability stable
     */
    get enableBgp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBgp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBgp(): void;
    /**
     * @stability stable
     */
    get enableBgpInput(): boolean | cdktf.IResolvable | undefined;
    private _generation?;
    /**
     * @stability stable
     */
    get generation(): string;
    /**
     * @stability stable
     */
    set generation(value: string);
    /**
     * @stability stable
     */
    resetGeneration(): void;
    /**
     * @stability stable
     */
    get generationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _privateIpAddressEnabled?;
    /**
     * @stability stable
     */
    get privateIpAddressEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateIpAddressEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateIpAddressEnabled(): void;
    /**
     * @stability stable
     */
    get privateIpAddressEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _vpnType?;
    /**
     * @stability stable
     */
    get vpnType(): string;
    /**
     * @stability stable
     */
    set vpnType(value: string);
    /**
     * @stability stable
     */
    resetVpnType(): void;
    /**
     * @stability stable
     */
    get vpnTypeInput(): string | undefined;
    private _bgpSettings;
    /**
     * @stability stable
     */
    get bgpSettings(): VirtualNetworkGatewayBgpSettingsOutputReference;
    /**
     * @stability stable
     */
    putBgpSettings(value: VirtualNetworkGatewayBgpSettings): void;
    /**
     * @stability stable
     */
    resetBgpSettings(): void;
    /**
     * @stability stable
     */
    get bgpSettingsInput(): VirtualNetworkGatewayBgpSettings | undefined;
    private _customRoute;
    /**
     * @stability stable
     */
    get customRoute(): VirtualNetworkGatewayCustomRouteOutputReference;
    /**
     * @stability stable
     */
    putCustomRoute(value: VirtualNetworkGatewayCustomRoute): void;
    /**
     * @stability stable
     */
    resetCustomRoute(): void;
    /**
     * @stability stable
     */
    get customRouteInput(): VirtualNetworkGatewayCustomRoute | undefined;
    private _ipConfiguration?;
    /**
     * @stability stable
     */
    get ipConfiguration(): VirtualNetworkGatewayIpConfiguration[];
    /**
     * @stability stable
     */
    set ipConfiguration(value: VirtualNetworkGatewayIpConfiguration[]);
    /**
     * @stability stable
     */
    get ipConfigurationInput(): VirtualNetworkGatewayIpConfiguration[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualNetworkGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualNetworkGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualNetworkGatewayTimeouts | undefined;
    private _vpnClientConfiguration;
    /**
     * @stability stable
     */
    get vpnClientConfiguration(): VirtualNetworkGatewayVpnClientConfigurationOutputReference;
    /**
     * @stability stable
     */
    putVpnClientConfiguration(value: VirtualNetworkGatewayVpnClientConfiguration): void;
    /**
     * @stability stable
     */
    resetVpnClientConfiguration(): void;
    /**
     * @stability stable
     */
    get vpnClientConfigurationInput(): VirtualNetworkGatewayVpnClientConfiguration | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
