import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#address_space VirtualNetwork#address_space}.
     *
     * @stability stable
     */
    readonly addressSpace: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#bgp_community VirtualNetwork#bgp_community}.
     *
     * @stability stable
     */
    readonly bgpCommunity?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#dns_servers VirtualNetwork#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#flow_timeout_in_minutes VirtualNetwork#flow_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly flowTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#location VirtualNetwork#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#name VirtualNetwork#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#resource_group_name VirtualNetwork#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#subnet VirtualNetwork#subnet}.
     *
     * @stability stable
     */
    readonly subnet?: VirtualNetworkSubnet[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#tags VirtualNetwork#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#vm_protection_enabled VirtualNetwork#vm_protection_enabled}.
     *
     * @stability stable
     */
    readonly vmProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
     * ddos_protection_plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#ddos_protection_plan VirtualNetwork#ddos_protection_plan}
     *
     * @stability stable
     */
    readonly ddosProtectionPlan?: VirtualNetworkDdosProtectionPlan;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#timeouts VirtualNetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualNetworkTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualNetworkSubnet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#address_prefix VirtualNetwork#address_prefix}.
     *
     * @stability stable
     */
    readonly addressPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#id VirtualNetwork#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#name VirtualNetwork#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#security_group VirtualNetwork#security_group}.
     *
     * @stability stable
     */
    readonly securityGroup?: string;
}
export declare function virtualNetworkSubnetToTerraform(struct?: VirtualNetworkSubnet): any;
/**
 * @stability stable
 */
export interface VirtualNetworkDdosProtectionPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#enable VirtualNetwork#enable}.
     *
     * @stability stable
     */
    readonly enable: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#id VirtualNetwork#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
export declare function virtualNetworkDdosProtectionPlanToTerraform(struct?: VirtualNetworkDdosProtectionPlanOutputReference | VirtualNetworkDdosProtectionPlan): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkDdosProtectionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkDdosProtectionPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkDdosProtectionPlan | undefined);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualNetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#create VirtualNetwork#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#delete VirtualNetwork#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#read VirtualNetwork#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network#update VirtualNetwork#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualNetworkTimeoutsToTerraform(struct?: VirtualNetworkTimeoutsOutputReference | VirtualNetworkTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network azurerm_virtual_network}.
 *
 * @stability stable
 */
export declare class VirtualNetwork extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network azurerm_virtual_network} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualNetworkConfig);
    private _addressSpace?;
    /**
     * @stability stable
     */
    get addressSpace(): string[];
    /**
     * @stability stable
     */
    set addressSpace(value: string[]);
    /**
     * @stability stable
     */
    get addressSpaceInput(): string[] | undefined;
    private _bgpCommunity?;
    /**
     * @stability stable
     */
    get bgpCommunity(): string;
    /**
     * @stability stable
     */
    set bgpCommunity(value: string);
    /**
     * @stability stable
     */
    resetBgpCommunity(): void;
    /**
     * @stability stable
     */
    get bgpCommunityInput(): string | undefined;
    private _dnsServers?;
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    set dnsServers(value: string[]);
    /**
     * @stability stable
     */
    resetDnsServers(): void;
    /**
     * @stability stable
     */
    get dnsServersInput(): string[] | undefined;
    private _flowTimeoutInMinutes?;
    /**
     * @stability stable
     */
    get flowTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    set flowTimeoutInMinutes(value: number);
    /**
     * @stability stable
     */
    resetFlowTimeoutInMinutes(): void;
    /**
     * @stability stable
     */
    get flowTimeoutInMinutesInput(): number | undefined;
    /**
     * @stability stable
     */
    get guid(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subnet?;
    /**
     * @stability stable
     */
    get subnet(): VirtualNetworkSubnet[];
    /**
     * @stability stable
     */
    set subnet(value: VirtualNetworkSubnet[]);
    /**
     * @stability stable
     */
    resetSubnet(): void;
    /**
     * @stability stable
     */
    get subnetInput(): VirtualNetworkSubnet[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vmProtectionEnabled?;
    /**
     * @stability stable
     */
    get vmProtectionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vmProtectionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVmProtectionEnabled(): void;
    /**
     * @stability stable
     */
    get vmProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ddosProtectionPlan;
    /**
     * @stability stable
     */
    get ddosProtectionPlan(): VirtualNetworkDdosProtectionPlanOutputReference;
    /**
     * @stability stable
     */
    putDdosProtectionPlan(value: VirtualNetworkDdosProtectionPlan): void;
    /**
     * @stability stable
     */
    resetDdosProtectionPlan(): void;
    /**
     * @stability stable
     */
    get ddosProtectionPlanInput(): VirtualNetworkDdosProtectionPlan | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualNetworkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualNetworkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
