import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualWanConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#allow_branch_to_branch_traffic VirtualWan#allow_branch_to_branch_traffic}.
     *
     * @stability stable
     */
    readonly allowBranchToBranchTraffic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#allow_vnet_to_vnet_traffic VirtualWan#allow_vnet_to_vnet_traffic}.
     *
     * @stability stable
     */
    readonly allowVnetToVnetTraffic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#disable_vpn_encryption VirtualWan#disable_vpn_encryption}.
     *
     * @stability stable
     */
    readonly disableVpnEncryption?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#location VirtualWan#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#name VirtualWan#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#office365_local_breakout_category VirtualWan#office365_local_breakout_category}.
     *
     * @stability stable
     */
    readonly office365LocalBreakoutCategory?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#resource_group_name VirtualWan#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#tags VirtualWan#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#type VirtualWan#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#timeouts VirtualWan#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualWanTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualWanTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#create VirtualWan#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#delete VirtualWan#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#read VirtualWan#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#update VirtualWan#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualWanTimeoutsToTerraform(struct?: VirtualWanTimeoutsOutputReference | VirtualWanTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualWanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualWanTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualWanTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan azurerm_virtual_wan}.
 *
 * @stability stable
 */
export declare class VirtualWan extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan azurerm_virtual_wan} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualWanConfig);
    private _allowBranchToBranchTraffic?;
    /**
     * @stability stable
     */
    get allowBranchToBranchTraffic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowBranchToBranchTraffic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowBranchToBranchTraffic(): void;
    /**
     * @stability stable
     */
    get allowBranchToBranchTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _allowVnetToVnetTraffic?;
    /**
     * @stability stable
     */
    get allowVnetToVnetTraffic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowVnetToVnetTraffic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowVnetToVnetTraffic(): void;
    /**
     * @stability stable
     */
    get allowVnetToVnetTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _disableVpnEncryption?;
    /**
     * @stability stable
     */
    get disableVpnEncryption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableVpnEncryption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableVpnEncryption(): void;
    /**
     * @stability stable
     */
    get disableVpnEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _office365LocalBreakoutCategory?;
    /**
     * @stability stable
     */
    get office365LocalBreakoutCategory(): string;
    /**
     * @stability stable
     */
    set office365LocalBreakoutCategory(value: string);
    /**
     * @stability stable
     */
    resetOffice365LocalBreakoutCategory(): void;
    /**
     * @stability stable
     */
    get office365LocalBreakoutCategoryInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualWanTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualWanTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualWanTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
