import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WindowsVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#admin_password WindowsVirtualMachine#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#admin_username WindowsVirtualMachine#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#allow_extension_operations WindowsVirtualMachine#allow_extension_operations}.
     *
     * @stability stable
     */
    readonly allowExtensionOperations?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#availability_set_id WindowsVirtualMachine#availability_set_id}.
     *
     * @stability stable
     */
    readonly availabilitySetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#computer_name WindowsVirtualMachine#computer_name}.
     *
     * @stability stable
     */
    readonly computerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#custom_data WindowsVirtualMachine#custom_data}.
     *
     * @stability stable
     */
    readonly customData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#dedicated_host_id WindowsVirtualMachine#dedicated_host_id}.
     *
     * @stability stable
     */
    readonly dedicatedHostId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#enable_automatic_updates WindowsVirtualMachine#enable_automatic_updates}.
     *
     * @stability stable
     */
    readonly enableAutomaticUpdates?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#encryption_at_host_enabled WindowsVirtualMachine#encryption_at_host_enabled}.
     *
     * @stability stable
     */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#eviction_policy WindowsVirtualMachine#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#extensions_time_budget WindowsVirtualMachine#extensions_time_budget}.
     *
     * @stability stable
     */
    readonly extensionsTimeBudget?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#license_type WindowsVirtualMachine#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#location WindowsVirtualMachine#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#max_bid_price WindowsVirtualMachine#max_bid_price}.
     *
     * @stability stable
     */
    readonly maxBidPrice?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#name WindowsVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#network_interface_ids WindowsVirtualMachine#network_interface_ids}.
     *
     * @stability stable
     */
    readonly networkInterfaceIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#patch_mode WindowsVirtualMachine#patch_mode}.
     *
     * @stability stable
     */
    readonly patchMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#platform_fault_domain WindowsVirtualMachine#platform_fault_domain}.
     *
     * @stability stable
     */
    readonly platformFaultDomain?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#priority WindowsVirtualMachine#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#provision_vm_agent WindowsVirtualMachine#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#proximity_placement_group_id WindowsVirtualMachine#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#resource_group_name WindowsVirtualMachine#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#secure_boot_enabled WindowsVirtualMachine#secure_boot_enabled}.
     *
     * @stability stable
     */
    readonly secureBootEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#size WindowsVirtualMachine#size}.
     *
     * @stability stable
     */
    readonly size: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#source_image_id WindowsVirtualMachine#source_image_id}.
     *
     * @stability stable
     */
    readonly sourceImageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#tags WindowsVirtualMachine#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#timezone WindowsVirtualMachine#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#user_data WindowsVirtualMachine#user_data}.
     *
     * @stability stable
     */
    readonly userData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#virtual_machine_scale_set_id WindowsVirtualMachine#virtual_machine_scale_set_id}.
     *
     * @stability stable
     */
    readonly virtualMachineScaleSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#vtpm_enabled WindowsVirtualMachine#vtpm_enabled}.
     *
     * @stability stable
     */
    readonly vtpmEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#zone WindowsVirtualMachine#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * additional_capabilities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#additional_capabilities WindowsVirtualMachine#additional_capabilities}
     *
     * @stability stable
     */
    readonly additionalCapabilities?: WindowsVirtualMachineAdditionalCapabilities;
    /**
     * additional_unattend_content block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#additional_unattend_content WindowsVirtualMachine#additional_unattend_content}
     *
     * @stability stable
     */
    readonly additionalUnattendContent?: WindowsVirtualMachineAdditionalUnattendContent[];
    /**
     * boot_diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#boot_diagnostics WindowsVirtualMachine#boot_diagnostics}
     *
     * @stability stable
     */
    readonly bootDiagnostics?: WindowsVirtualMachineBootDiagnostics;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#identity WindowsVirtualMachine#identity}
     *
     * @stability stable
     */
    readonly identity?: WindowsVirtualMachineIdentity;
    /**
     * os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#os_disk WindowsVirtualMachine#os_disk}
     *
     * @stability stable
     */
    readonly osDisk: WindowsVirtualMachineOsDisk;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#plan WindowsVirtualMachine#plan}
     *
     * @stability stable
     */
    readonly plan?: WindowsVirtualMachinePlan;
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#secret WindowsVirtualMachine#secret}
     *
     * @stability stable
     */
    readonly secret?: WindowsVirtualMachineSecret[];
    /**
     * source_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#source_image_reference WindowsVirtualMachine#source_image_reference}
     *
     * @stability stable
     */
    readonly sourceImageReference?: WindowsVirtualMachineSourceImageReference;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#timeouts WindowsVirtualMachine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WindowsVirtualMachineTimeouts;
    /**
     * winrm_listener block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#winrm_listener WindowsVirtualMachine#winrm_listener}
     *
     * @stability stable
     */
    readonly winrmListener?: WindowsVirtualMachineWinrmListener[];
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineAdditionalCapabilities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#ultra_ssd_enabled WindowsVirtualMachine#ultra_ssd_enabled}.
     *
     * @stability stable
     */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineAdditionalCapabilitiesToTerraform(struct?: WindowsVirtualMachineAdditionalCapabilitiesOutputReference | WindowsVirtualMachineAdditionalCapabilities): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineAdditionalCapabilities | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    /**
     * @stability stable
     */
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUltraSsdEnabled(): void;
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineAdditionalUnattendContent {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#content WindowsVirtualMachine#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#setting WindowsVirtualMachine#setting}.
     *
     * @stability stable
     */
    readonly setting: string;
}
export declare function windowsVirtualMachineAdditionalUnattendContentToTerraform(struct?: WindowsVirtualMachineAdditionalUnattendContent): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineBootDiagnostics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#storage_account_uri WindowsVirtualMachine#storage_account_uri}.
     *
     * @stability stable
     */
    readonly storageAccountUri?: string;
}
export declare function windowsVirtualMachineBootDiagnosticsToTerraform(struct?: WindowsVirtualMachineBootDiagnosticsOutputReference | WindowsVirtualMachineBootDiagnostics): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineBootDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineBootDiagnostics | undefined);
    private _storageAccountUri?;
    /**
     * @stability stable
     */
    get storageAccountUri(): string;
    /**
     * @stability stable
     */
    set storageAccountUri(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountUri(): void;
    /**
     * @stability stable
     */
    get storageAccountUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#identity_ids WindowsVirtualMachine#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#type WindowsVirtualMachine#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function windowsVirtualMachineIdentityToTerraform(struct?: WindowsVirtualMachineIdentityOutputReference | WindowsVirtualMachineIdentity): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineOsDiskDiffDiskSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#option WindowsVirtualMachine#option}.
     *
     * @stability stable
     */
    readonly option: string;
}
export declare function windowsVirtualMachineOsDiskDiffDiskSettingsToTerraform(struct?: WindowsVirtualMachineOsDiskDiffDiskSettingsOutputReference | WindowsVirtualMachineOsDiskDiffDiskSettings): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineOsDiskDiffDiskSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineOsDiskDiffDiskSettings | undefined);
    private _option?;
    /**
     * @stability stable
     */
    get option(): string;
    /**
     * @stability stable
     */
    set option(value: string);
    /**
     * @stability stable
     */
    get optionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#caching WindowsVirtualMachine#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#disk_encryption_set_id WindowsVirtualMachine#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#disk_size_gb WindowsVirtualMachine#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#name WindowsVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#storage_account_type WindowsVirtualMachine#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#write_accelerator_enabled WindowsVirtualMachine#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
     * diff_disk_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#diff_disk_settings WindowsVirtualMachine#diff_disk_settings}
     *
     * @stability stable
     */
    readonly diffDiskSettings?: WindowsVirtualMachineOsDiskDiffDiskSettings;
}
export declare function windowsVirtualMachineOsDiskToTerraform(struct?: WindowsVirtualMachineOsDiskOutputReference | WindowsVirtualMachineOsDisk): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineOsDisk | undefined);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    set diskEncryptionSetId(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionSetId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountType?;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    set storageAccountType(value: string);
    /**
     * @stability stable
     */
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWriteAcceleratorEnabled(): void;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    /**
     * @stability stable
     */
    get diffDiskSettings(): WindowsVirtualMachineOsDiskDiffDiskSettingsOutputReference;
    /**
     * @stability stable
     */
    putDiffDiskSettings(value: WindowsVirtualMachineOsDiskDiffDiskSettings): void;
    /**
     * @stability stable
     */
    resetDiffDiskSettings(): void;
    /**
     * @stability stable
     */
    get diffDiskSettingsInput(): WindowsVirtualMachineOsDiskDiffDiskSettings | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachinePlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#name WindowsVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#product WindowsVirtualMachine#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#publisher WindowsVirtualMachine#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function windowsVirtualMachinePlanToTerraform(struct?: WindowsVirtualMachinePlanOutputReference | WindowsVirtualMachinePlan): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachinePlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachinePlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachinePlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineSecretCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#store WindowsVirtualMachine#store}.
     *
     * @stability stable
     */
    readonly store: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#url WindowsVirtualMachine#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function windowsVirtualMachineSecretCertificateToTerraform(struct?: WindowsVirtualMachineSecretCertificate): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineSecret {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#key_vault_id WindowsVirtualMachine#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#certificate WindowsVirtualMachine#certificate}
     *
     * @stability stable
     */
    readonly certificate: WindowsVirtualMachineSecretCertificate[];
}
export declare function windowsVirtualMachineSecretToTerraform(struct?: WindowsVirtualMachineSecret): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineSourceImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#offer WindowsVirtualMachine#offer}.
     *
     * @stability stable
     */
    readonly offer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#publisher WindowsVirtualMachine#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#sku WindowsVirtualMachine#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#version WindowsVirtualMachine#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function windowsVirtualMachineSourceImageReferenceToTerraform(struct?: WindowsVirtualMachineSourceImageReferenceOutputReference | WindowsVirtualMachineSourceImageReference): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineSourceImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineSourceImageReference | undefined);
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#create WindowsVirtualMachine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#delete WindowsVirtualMachine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#read WindowsVirtualMachine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#update WindowsVirtualMachine#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function windowsVirtualMachineTimeoutsToTerraform(struct?: WindowsVirtualMachineTimeoutsOutputReference | WindowsVirtualMachineTimeouts): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineWinrmListener {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#certificate_url WindowsVirtualMachine#certificate_url}.
     *
     * @stability stable
     */
    readonly certificateUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine#protocol WindowsVirtualMachine#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function windowsVirtualMachineWinrmListenerToTerraform(struct?: WindowsVirtualMachineWinrmListener): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine azurerm_windows_virtual_machine}.
 *
 * @stability stable
 */
export declare class WindowsVirtualMachine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine azurerm_windows_virtual_machine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WindowsVirtualMachineConfig);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _allowExtensionOperations?;
    /**
     * @stability stable
     */
    get allowExtensionOperations(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowExtensionOperations(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowExtensionOperations(): void;
    /**
     * @stability stable
     */
    get allowExtensionOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilitySetId?;
    /**
     * @stability stable
     */
    get availabilitySetId(): string;
    /**
     * @stability stable
     */
    set availabilitySetId(value: string);
    /**
     * @stability stable
     */
    resetAvailabilitySetId(): void;
    /**
     * @stability stable
     */
    get availabilitySetIdInput(): string | undefined;
    private _computerName?;
    /**
     * @stability stable
     */
    get computerName(): string;
    /**
     * @stability stable
     */
    set computerName(value: string);
    /**
     * @stability stable
     */
    resetComputerName(): void;
    /**
     * @stability stable
     */
    get computerNameInput(): string | undefined;
    private _customData?;
    /**
     * @stability stable
     */
    get customData(): string;
    /**
     * @stability stable
     */
    set customData(value: string);
    /**
     * @stability stable
     */
    resetCustomData(): void;
    /**
     * @stability stable
     */
    get customDataInput(): string | undefined;
    private _dedicatedHostId?;
    /**
     * @stability stable
     */
    get dedicatedHostId(): string;
    /**
     * @stability stable
     */
    set dedicatedHostId(value: string);
    /**
     * @stability stable
     */
    resetDedicatedHostId(): void;
    /**
     * @stability stable
     */
    get dedicatedHostIdInput(): string | undefined;
    private _enableAutomaticUpdates?;
    /**
     * @stability stable
     */
    get enableAutomaticUpdates(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticUpdates(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutomaticUpdates(): void;
    /**
     * @stability stable
     */
    get enableAutomaticUpdatesInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionAtHostEnabled?;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionAtHostEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    private _extensionsTimeBudget?;
    /**
     * @stability stable
     */
    get extensionsTimeBudget(): string;
    /**
     * @stability stable
     */
    set extensionsTimeBudget(value: string);
    /**
     * @stability stable
     */
    resetExtensionsTimeBudget(): void;
    /**
     * @stability stable
     */
    get extensionsTimeBudgetInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    /**
     * @stability stable
     */
    get maxBidPrice(): number;
    /**
     * @stability stable
     */
    set maxBidPrice(value: number);
    /**
     * @stability stable
     */
    resetMaxBidPrice(): void;
    /**
     * @stability stable
     */
    get maxBidPriceInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkInterfaceIds?;
    /**
     * @stability stable
     */
    get networkInterfaceIds(): string[];
    /**
     * @stability stable
     */
    set networkInterfaceIds(value: string[]);
    /**
     * @stability stable
     */
    get networkInterfaceIdsInput(): string[] | undefined;
    private _patchMode?;
    /**
     * @stability stable
     */
    get patchMode(): string;
    /**
     * @stability stable
     */
    set patchMode(value: string);
    /**
     * @stability stable
     */
    resetPatchMode(): void;
    /**
     * @stability stable
     */
    get patchModeInput(): string | undefined;
    private _platformFaultDomain?;
    /**
     * @stability stable
     */
    get platformFaultDomain(): number;
    /**
     * @stability stable
     */
    set platformFaultDomain(value: number);
    /**
     * @stability stable
     */
    resetPlatformFaultDomain(): void;
    /**
     * @stability stable
     */
    get platformFaultDomainInput(): number | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicIpAddress(): string;
    /**
     * @stability stable
     */
    get publicIpAddresses(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _secureBootEnabled?;
    /**
     * @stability stable
     */
    get secureBootEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secureBootEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecureBootEnabled(): void;
    /**
     * @stability stable
     */
    get secureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): string;
    /**
     * @stability stable
     */
    set size(value: string);
    /**
     * @stability stable
     */
    get sizeInput(): string | undefined;
    private _sourceImageId?;
    /**
     * @stability stable
     */
    get sourceImageId(): string;
    /**
     * @stability stable
     */
    set sourceImageId(value: string);
    /**
     * @stability stable
     */
    resetSourceImageId(): void;
    /**
     * @stability stable
     */
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _userData?;
    /**
     * @stability stable
     */
    get userData(): string;
    /**
     * @stability stable
     */
    set userData(value: string);
    /**
     * @stability stable
     */
    resetUserData(): void;
    /**
     * @stability stable
     */
    get userDataInput(): string | undefined;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    private _virtualMachineScaleSetId?;
    /**
     * @stability stable
     */
    get virtualMachineScaleSetId(): string;
    /**
     * @stability stable
     */
    set virtualMachineScaleSetId(value: string);
    /**
     * @stability stable
     */
    resetVirtualMachineScaleSetId(): void;
    /**
     * @stability stable
     */
    get virtualMachineScaleSetIdInput(): string | undefined;
    private _vtpmEnabled?;
    /**
     * @stability stable
     */
    get vtpmEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vtpmEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVtpmEnabled(): void;
    /**
     * @stability stable
     */
    get vtpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _additionalCapabilities;
    /**
     * @stability stable
     */
    get additionalCapabilities(): WindowsVirtualMachineAdditionalCapabilitiesOutputReference;
    /**
     * @stability stable
     */
    putAdditionalCapabilities(value: WindowsVirtualMachineAdditionalCapabilities): void;
    /**
     * @stability stable
     */
    resetAdditionalCapabilities(): void;
    /**
     * @stability stable
     */
    get additionalCapabilitiesInput(): WindowsVirtualMachineAdditionalCapabilities | undefined;
    private _additionalUnattendContent?;
    /**
     * @stability stable
     */
    get additionalUnattendContent(): WindowsVirtualMachineAdditionalUnattendContent[];
    /**
     * @stability stable
     */
    set additionalUnattendContent(value: WindowsVirtualMachineAdditionalUnattendContent[]);
    /**
     * @stability stable
     */
    resetAdditionalUnattendContent(): void;
    /**
     * @stability stable
     */
    get additionalUnattendContentInput(): WindowsVirtualMachineAdditionalUnattendContent[] | undefined;
    private _bootDiagnostics;
    /**
     * @stability stable
     */
    get bootDiagnostics(): WindowsVirtualMachineBootDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putBootDiagnostics(value: WindowsVirtualMachineBootDiagnostics): void;
    /**
     * @stability stable
     */
    resetBootDiagnostics(): void;
    /**
     * @stability stable
     */
    get bootDiagnosticsInput(): WindowsVirtualMachineBootDiagnostics | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): WindowsVirtualMachineIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: WindowsVirtualMachineIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): WindowsVirtualMachineIdentity | undefined;
    private _osDisk;
    /**
     * @stability stable
     */
    get osDisk(): WindowsVirtualMachineOsDiskOutputReference;
    /**
     * @stability stable
     */
    putOsDisk(value: WindowsVirtualMachineOsDisk): void;
    /**
     * @stability stable
     */
    get osDiskInput(): WindowsVirtualMachineOsDisk | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): WindowsVirtualMachinePlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: WindowsVirtualMachinePlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): WindowsVirtualMachinePlan | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): WindowsVirtualMachineSecret[];
    /**
     * @stability stable
     */
    set secret(value: WindowsVirtualMachineSecret[]);
    /**
     * @stability stable
     */
    resetSecret(): void;
    /**
     * @stability stable
     */
    get secretInput(): WindowsVirtualMachineSecret[] | undefined;
    private _sourceImageReference;
    /**
     * @stability stable
     */
    get sourceImageReference(): WindowsVirtualMachineSourceImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putSourceImageReference(value: WindowsVirtualMachineSourceImageReference): void;
    /**
     * @stability stable
     */
    resetSourceImageReference(): void;
    /**
     * @stability stable
     */
    get sourceImageReferenceInput(): WindowsVirtualMachineSourceImageReference | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): WindowsVirtualMachineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WindowsVirtualMachineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WindowsVirtualMachineTimeouts | undefined;
    private _winrmListener?;
    /**
     * @stability stable
     */
    get winrmListener(): WindowsVirtualMachineWinrmListener[];
    /**
     * @stability stable
     */
    set winrmListener(value: WindowsVirtualMachineWinrmListener[]);
    /**
     * @stability stable
     */
    resetWinrmListener(): void;
    /**
     * @stability stable
     */
    get winrmListenerInput(): WindowsVirtualMachineWinrmListener[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
