from typing import Any, TypeVar, Union, cast
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="UpdateLookupTableFileRequestData")


@_attrs_define
class UpdateLookupTableFileRequestData:
    """
    Attributes:
        id (UUID):
        description (Union[None, Unset, str]): This implements a type which describes whether a value should be updated
            or not, that's used in most update routes in the API.

            This needs to implement Serialize for derive(JsonSchema) to work. It shouldn't ever need to be used in a
            Serialize context, as it's only Serialize in order to generate a JsonSchema properly.

            Please use with #[serde(default, deserialize_with=deserialize_update_value) in the struct.
    """

    id: UUID
    description: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id = str(self.id)

        description: Union[None, Unset, str]
        if isinstance(self.description, Unset):
            description = UNSET
        else:
            description = self.description

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
            }
        )
        if description is not UNSET:
            field_dict["description"] = description

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        id = UUID(d.pop("id"))

        def _parse_description(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        description = _parse_description(d.pop("description", UNSET))

        update_lookup_table_file_request_data = cls(
            id=id,
            description=description,
        )

        update_lookup_table_file_request_data.additional_properties = d
        return update_lookup_table_file_request_data

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
