/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class ResultArray
implements java.sql.Array {
    private Object[] m_aoElements = new Object[0];
    private String m_sBaseTypeName;
    private boolean m_bArrayFreed = false;
    private int m_nDimensions;
    private int m_nArrayCardinality;
    private int[] m_anArrayCardinalities;
    private TDSession m_session;
    private ResultSetHelper m_helper;
    private ColumnProperties m_baseColumnProperties;
    static /* synthetic */ Class class$java$lang$Object;

    public ResultArray(int n) {
        this.m_nArrayCardinality = n;
    }

    public void initArray(TDSession tDSession, ColumnProperties columnProperties, int n, int[] nArray) {
        this.m_session = tDSession;
        this.m_baseColumnProperties = columnProperties;
        this.m_sBaseTypeName = columnProperties.getColumnTypeName();
        this.m_nDimensions = n;
        this.m_anArrayCardinalities = nArray;
    }

    public void free() throws SQLException {
        if (this.m_bArrayFreed) {
            return;
        }
        this.m_aoElements = new Object[0];
        this.m_bArrayFreed = true;
    }

    public String getBaseTypeName() throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        return this.m_sBaseTypeName;
    }

    public int getBaseType() throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        return this.m_baseColumnProperties.getColumnType();
    }

    public Object getArray() throws SQLException {
        return this.getArray(this.m_session.getTypeMap());
    }

    public Object getArray(long l, int n) throws SQLException {
        return this.getArray(l, n, this.m_session.getTypeMap());
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        if (this.m_nDimensions > 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ749");
        }
        return this.internalGetArray(l, n, map);
    }

    public Object getArray(Map map) throws SQLException {
        Object[] objectArray = this.internalGetArray(1L, this.m_aoElements.length, map);
        return ResultArray.aggregateArrayDimensions(objectArray, this.m_anArrayCardinalities);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, this.m_nArrayCardinality, this.m_session.getTypeMap());
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, this.m_session.getTypeMap());
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.getResultSet(1L, this.m_nArrayCardinality, map);
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        if (this.m_nDimensions > 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ749");
        }
        if (l < 1L || l > (long)(this.m_aoElements.length + 1)) {
            throw ErrorFactory.makeDriverJDBCException("TJ747", String.valueOf(l), String.valueOf(this.m_aoElements.length + 1));
        }
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ752", n);
        }
        TeraResultSetMetaData teraResultSetMetaData = this.m_session.constructResultSetMetaData();
        teraResultSetMetaData.addColumnProperties(this.getArrayIndexColumnProperties(), true);
        teraResultSetMetaData.addColumnProperties(this.m_baseColumnProperties, true);
        TDResultSet tDResultSet = this.m_session.constructResultSet(teraResultSetMetaData, 1, null, null, this.m_session.getLog());
        tDResultSet.setActivityCount(this.m_aoElements.length == 0 ? 0L : (long)this.m_nArrayCardinality);
        for (int i = (int)l; (long)i <= l + (long)n && i <= this.m_aoElements.length; ++i) {
            ResultSetRow resultSetRow = new ResultSetRow();
            resultSetRow.addValue(new Integer(i));
            resultSetRow.addValue(TDResultSet.internalGetObject(this.m_helper, i, this.m_aoElements[i - 1], this.m_baseColumnProperties.getColumnType(), this.m_baseColumnProperties.getColumnBaseJDBCType(), this.m_sBaseTypeName, map));
            tDResultSet.addResultSetRow(resultSetRow);
        }
        return (ResultSet)((Object)tDResultSet);
    }

    private ColumnProperties getArrayIndexColumnProperties() {
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.setPrecision(10);
        columnProperties.setScale(0);
        columnProperties.setNullable(1);
        columnProperties.setColumnType(4, 497);
        columnProperties.setTdType(497);
        columnProperties.setColumnDisplaySize(JDBC4Constants.getDisplaySize(496));
        columnProperties.setReadOnly(true);
        columnProperties.setIsSigned(true);
        return columnProperties;
    }

    private Object[] internalGetArray(long l, int n, Map map) throws SQLException {
        if (this.m_bArrayFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ745");
        }
        if (l < 1L || l > (long)(this.m_aoElements.length + 1)) {
            throw ErrorFactory.makeDriverJDBCException("TJ747", String.valueOf(l), String.valueOf(this.m_aoElements.length + 1));
        }
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ752", n);
        }
        int n2 = (int)(l - 1L);
        int n3 = this.m_aoElements.length - n2;
        n = Math.min(n, n3);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = TDResultSet.internalGetObject(this.m_helper, i + n2 + 1, this.m_aoElements[i + n2], this.m_baseColumnProperties.getColumnType(), this.m_baseColumnProperties.getColumnBaseJDBCType(), this.m_sBaseTypeName, map);
        }
        return objectArray;
    }

    private static Object[] aggregateArrayDimensions(Object[] objectArray, int[] nArray) {
        if (objectArray.length == 0) {
            return (Object[])Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = ResultArray.class$("java.lang.Object")) : class$java$lang$Object, new int[nArray.length]);
        }
        int n = 1;
        int n2 = 2;
        for (int i = nArray.length - 1; i >= 1; --i) {
            int n3 = nArray[i];
            int[] nArray2 = new int[n2];
            nArray2[0] = (objectArray.length + n3 - 1) / n3;
            Object[][] objectArray2 = (Object[][])Array.newInstance(class$java$lang$Object == null ? ResultArray.class$("java.lang.Object") : class$java$lang$Object, nArray2);
            for (int j = 0; j < objectArray.length; ++j) {
                if (j % n3 == 0) {
                    int n4 = objectArray.length - j;
                    int[] nArray3 = new int[n];
                    nArray3[0] = Math.min(n3, n4);
                    objectArray2[j / n3] = (Object[])Array.newInstance(class$java$lang$Object == null ? ResultArray.class$("java.lang.Object") : class$java$lang$Object, nArray3);
                }
                objectArray2[j / n3][j % n3] = objectArray[j];
            }
            objectArray = objectArray2;
            ++n;
            ++n2;
        }
        return objectArray;
    }

    public void setArrayElements(Object[] objectArray) {
        this.m_aoElements = objectArray;
    }

    public int getArrayCardinality() {
        return this.m_nArrayCardinality;
    }

    public void setResultSetHelper(ResultSetHelper resultSetHelper) {
        this.m_helper = resultSetHelper;
    }

    public ArrayElementValuesIterator getArrayElementValuesIterator() {
        return new ArrayElementValuesIterator();
    }

    public String toString() {
        return "ResultArray:" + this.m_sBaseTypeName + Arrays.asList(this.m_aoElements);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ArrayElementValuesIterator
    implements Iterator {
        private int index = 0;

        public boolean hasNext() {
            return this.index < ResultArray.this.m_aoElements.length;
        }

        public Object next() {
            return this.hasNext() ? ResultArray.this.m_aoElements[this.index++] : null;
        }

        public void remove() {
        }
    }
}

