# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
import dataclasses
from pkgs.serialization import serial_class
from ... import base_t
from ... import experiment_groups_t
from ... import inputs_t
from ... import outputs_t
from ... import recipe_metadata_t
from ... import recipe_tags_t
from ... import workflows_t

__all__: list[str] = [
    "Arguments",
    "ConditionParameterValue",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "Recipe",
    "RecipeInput",
    "RecipeOutput",
    "RecipeStep",
    "RecipeStepGroup",
    "RecipeStepRelationship",
    "RecipeWorkflowStep",
    "SimpleOutputCondition",
]

ENDPOINT_METHOD = "GET"
ENDPOINT_PATH = "api/external/recipes/external_get_recipes_data"


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class Arguments:
    recipe_ids: typing.Optional[typing.Optional[list[base_t.ObjectId]]] = None
    project_id: typing.Optional[typing.Optional[base_t.ObjectId]] = None
    offset: typing.Optional[typing.Optional[int]] = None
    limit: typing.Optional[typing.Optional[int]] = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclasses.dataclass(kw_only=True)
class RecipeOutput:
    id: base_t.ObjectId
    output_id: base_t.ObjectId
    replicate_num: int
    quantity_json: base_t.JsonValue
    curve_id: typing.Optional[base_t.ObjectId]
    output_condition_id: typing.Optional[base_t.ObjectId]
    quantity_dec: typing.Optional[Decimal] = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclasses.dataclass(kw_only=True)
class ConditionParameterValue:
    condition_parameter_id: base_t.ObjectId
    condition_parameter_name: str
    quantity_json: base_t.JsonValue
    quantity_dec: typing.Optional[Decimal] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class SimpleOutputCondition:
    output_condition_id: base_t.ObjectId
    condition_parameter_values: list[ConditionParameterValue]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"actual_quantity_json", "quantity_json"},
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclasses.dataclass(kw_only=True)
class RecipeInput:
    id: base_t.ObjectId
    input_id: base_t.ObjectId
    input_lot_recipe_id: typing.Optional[base_t.ObjectId]
    recipe_step_id: base_t.ObjectId
    quantity_json: base_t.JsonValue
    curve_id: typing.Optional[base_t.ObjectId]
    actual_quantity_json: base_t.JsonValue
    behavior: str
    ingredient_role_id: typing.Optional[base_t.ObjectId]
    quantity_dec: typing.Optional[Decimal] = None
    actual_quantity_dec: typing.Optional[Decimal] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class RecipeStep:
    name: typing.Optional[str]
    recipe_step_id: base_t.ObjectId
    recipe_step_number: int
    instructions: typing.Optional[str] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class RecipeStepGroup:
    name: typing.Optional[str]
    recipe_steps: list[RecipeStep]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class RecipeWorkflowStep:
    recipe_workflow_step_id: base_t.ObjectId
    workflow_step_id: base_t.ObjectId
    recipe_step_groups: list[RecipeStepGroup]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclasses.dataclass(kw_only=True)
class RecipeStepRelationship:
    step_relationship_id: base_t.ObjectId
    name: typing.Optional[str]
    source_recipe_workflow_step_id: base_t.ObjectId
    target_recipe_step_id: base_t.ObjectId
    quantity_dec: typing.Optional[Decimal] = None
    actual_quantity_dec: typing.Optional[Decimal] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class Recipe:
    recipe_id: base_t.ObjectId
    create_datetime: str
    last_modified_datetime: str
    name: str
    notes: typing.Optional[str]
    workflow_id: base_t.ObjectId
    metadata: list[recipe_metadata_t.RecipeMetadata]
    inputs: list[RecipeInput]
    outputs: list[RecipeOutput]
    workflow_steps: list[RecipeWorkflowStep]
    tag_ids: list[base_t.ObjectId]
    experiment_group_ids: list[base_t.ObjectId]
    step_relationships: list[RecipeStepRelationship]
    creating_user_id: typing.Optional[base_t.ObjectId] = None
    barcode_value: typing.Optional[str] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class Data:
    recipes: list[Recipe]
    workflows: list[workflows_t.SimpleWorkflow]
    metadata: list[recipe_metadata_t.SimpleRecipeMetadataField]
    inputs: list[inputs_t.SimpleInput]
    outputs: list[outputs_t.SimpleOutput]
    output_conditions: list[SimpleOutputCondition]
    recipe_tags: list[recipe_tags_t.SimpleRecipeTag]
    experiment_groups: list[experiment_groups_t.SimpleExperimentGroup]
# DO NOT MODIFY -- This file is generated by type_spec
