/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssCredential;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class TdgssContext
implements GSSContext {
    private final TdgssLogger logger;
    private static final short maxshort = Short.MAX_VALUE;
    private Vector mechanisms;
    private boolean busy = false;
    private boolean initiator;
    private Oid mechOid = null;
    private TdgssName targName = null;
    private TdgssCredential cred = null;
    private int lifetime = 0;
    private ChannelBinding channelBindings = null;
    private short servicesRequested = 0;
    private GSSContext context = null;

    public TdgssContext(TdgssName tdgssName, Oid oid, TdgssCredential tdgssCredential, int n, GSSMechanism[] gSSMechanismArray, TdgssLogger tdgssLogger) throws GSSException {
        if (gSSMechanismArray == null || gSSMechanismArray.length == 0) {
            throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISM_IMPLEMENTATIONS);
        }
        this.logger = tdgssLogger;
        this.targName = tdgssName;
        this.cred = tdgssCredential;
        this.mechOid = oid;
        this.mechanisms = new Vector(gSSMechanismArray.length);
        if (oid != null) {
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                if (!gSSMechanismArray[i].getMech().equals(oid)) continue;
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        } else {
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        }
        if (this.mechanisms.size() == 0) {
            throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
        }
        this.lifetime = n;
        this.initiator = true;
    }

    public TdgssContext(TdgssCredential tdgssCredential, GSSMechanism[] gSSMechanismArray, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.cred = tdgssCredential;
        this.mechanisms = new Vector(gSSMechanismArray.length);
        if (this.mechOid != null) {
            if (tdgssLogger.isDebugEnabled()) {
                tdgssLogger.debug("Requested mechOid is " + this.mechOid.toString());
            }
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                if (!gSSMechanismArray[i].getMech().equals(this.mechOid)) continue;
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        } else {
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        }
        if (this.mechanisms.size() == 0) {
            throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
        }
        this.initiator = false;
    }

    public TdgssContext(byte[] byArray, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("inter-process tokens not supported");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        if (!this.initiator) {
            throw new TdgssException(15, TdgssMinorStatus.TDGSS_ERR_CANT_INIT_SEC_CONTEXT);
        }
        if (!this.busy) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Searching for an appropriate MI");
            }
            if (this.mechanisms.size() == 0) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
            }
            object = this.mechanisms.elements();
            while (object.hasMoreElements()) {
                GSSMechanism gSSMechanism = (GSSMechanism)object.nextElement();
                GSSName gSSName = null;
                if (this.targName != null && (gSSName = this.targName.getNameImplementation(gSSMechanism)) == null) continue;
                GSSCredential gSSCredential = null;
                if (this.cred != null) {
                    gSSCredential = this.cred.getCredentialImplementation(gSSMechanism);
                }
                Object[] objectArray = new Object[]{this.channelBindings};
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking whether mechanism is initable");
                }
                if (!gSSMechanism.initable(gSSCredential, gSSName, this.lifetime, objectArray, this.servicesRequested)) continue;
                this.context = gSSMechanism.getContextForInit(gSSCredential, gSSName, this.lifetime, objectArray, this.servicesRequested);
                break;
            }
            if (this.context == null) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
            }
            this.busy = true;
        }
        object = this.context.initSecContext(byArray, n, n2);
        return object;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stream-based methods not supported yet");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        if (byArray == null) {
            throw new TdgssException(10);
        }
        if (this.initiator) {
            throw new TdgssException(15);
        }
        if (!this.busy) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Searching for an appropriate MI");
            }
            if (this.mechanisms.size() == 0) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
            }
            Enumeration enumeration = this.mechanisms.elements();
            while (enumeration.hasMoreElements()) {
                GSSMechanism gSSMechanism = (GSSMechanism)enumeration.nextElement();
                try {
                    GSSCredential gSSCredential = null;
                    if (this.cred != null) {
                        gSSCredential = this.cred.getCredentialImplementation(gSSMechanism);
                    }
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    Object[] objectArray = new Object[]{this.channelBindings};
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Checking whether mechanism is acceptable");
                    }
                    if (!gSSMechanism.acceptable(byArray2, gSSCredential, objectArray)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found an acceptable mechanism");
                    }
                    this.context = gSSMechanism.getContextForAccept(byArray2, gSSCredential, objectArray);
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("context is " + this.context);
                    break;
                }
                catch (GSSException gSSException) {
                }
            }
            if (this.context == null) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
            }
            this.busy = true;
        }
        return this.context.acceptSecContext(byArray, n, n2);
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stream-based methods not supported yet");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public boolean isEstablished() {
        if (this.context != null) {
            return this.context.isEstablished();
        }
        return false;
    }

    public void dispose() throws GSSException {
        if (this.context != null) {
            this.context.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (this.context != null) {
            return this.context.getWrapSizeLimit(n, bl, n2);
        }
        return 0;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.wrap(byArray, n, n2, messageProp);
        }
        return null;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.wrap(inputStream, outputStream, messageProp);
        }
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.unwrap(byArray, n, n2, messageProp);
        }
        return null;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.unwrap(inputStream, outputStream, messageProp);
        }
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.getMIC(byArray, n, n2, messageProp);
        }
        return null;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.getMIC(inputStream, outputStream, messageProp);
        }
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
        }
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.verifyMIC(inputStream, inputStream2, messageProp);
        }
    }

    public byte[] export() throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("inter-process tokens not supported");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestMutualAuth(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 2) : (short)(this.servicesRequested & 0x7FFD);
        }
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestReplayDet(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 4) : (short)(this.servicesRequested & 0x7FFB);
        }
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestSequenceDet(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 8) : (short)(this.servicesRequested & 0x7FF7);
        }
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestCredDeleg(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 1) : (short)(this.servicesRequested & 0x7FFE);
        }
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestAnonymity(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 0x10) : (short)(this.servicesRequested & 0x7FEF);
        }
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestConf(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 0x20) : (short)(this.servicesRequested & 0x7FDF);
        }
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestInteg(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 0x40) : (short)(this.servicesRequested & 0x7FBF);
        }
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.context != null) {
            this.context.requestLifetime(n);
        } else {
            this.lifetime = n;
        }
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (this.busy) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CONTEXT_BUSY);
        }
        this.channelBindings = channelBinding;
    }

    public boolean getCredDelegState() {
        return this.context == null ? false : this.context.getCredDelegState();
    }

    public boolean getMutualAuthState() {
        return this.context == null ? false : this.context.getMutualAuthState();
    }

    public boolean getReplayDetState() {
        return this.context == null ? false : this.context.getReplayDetState();
    }

    public boolean getSequenceDetState() {
        return this.context == null ? false : this.context.getSequenceDetState();
    }

    public boolean getAnonymityState() {
        return this.context == null ? false : this.context.getAnonymityState();
    }

    public boolean getConfState() {
        return this.context == null ? false : this.context.getConfState();
    }

    public boolean getIntegState() {
        return this.context == null ? false : this.context.getIntegState();
    }

    public int getLifetime() {
        return this.context == null ? 0 : this.context.getLifetime();
    }

    public boolean isTransferable() throws GSSException {
        if (this.context == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
        }
        return this.context.isTransferable();
    }

    public boolean isProtReady() {
        return this.context == null ? false : this.context.isProtReady();
    }

    public GSSName getSrcName() throws GSSException {
        if (this.cred != null) {
            return this.cred.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targName;
    }

    public Oid getMech() throws GSSException {
        return this.context == null ? this.mechOid : this.context.getMech();
    }

    public GSSCredential getDelegCred() throws GSSException {
        if (this.context == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
        }
        return this.context.getDelegCred();
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cred != null) {
            stringBuffer.append("TdgssCredential: ");
            stringBuffer.append(this.cred.toString());
            stringBuffer.append("\n");
        }
        if (this.targName != null) {
            stringBuffer.append("Target: ");
            stringBuffer.append(this.targName.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

